/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World;

import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.Math.LobulatedCurve;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaPlantHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaTreeHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.util.ForgeDirection;

public class EnderOakGenerator
extends WorldGenAbstractTree {
    public final int minTrunkBaseHeight;
    public final int maxTrunkBaseHeight;
    public final int minFoliageHeight;
    public final int maxFoliageHeight;
    public final int minFoliageRadius;
    public final int maxFoliageRadius;
    public final float branchChancePerLevel;
    public final int maxBranchLength;
    public final float columnChancePerLeaf;

    public EnderOakGenerator(int h0, int h1, int f0, int f1, int fr0, int fr1, float b, int bl, float c) {
        super(false);
        this.minTrunkBaseHeight = h0;
        this.maxTrunkBaseHeight = h1;
        this.minFoliageHeight = f0;
        this.maxFoliageHeight = f1;
        this.minFoliageRadius = fr0;
        this.maxFoliageRadius = fr1;
        this.branchChancePerLevel = b;
        this.maxBranchLength = bl;
        this.columnChancePerLeaf = c;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        if (!ReikaPlantHelper.SAPLING.canPlantAt(world, x, y, z)) {
            return false;
        }
        int trunk = ReikaRandomHelper.getRandomBetween((int)this.minTrunkBaseHeight, (int)this.maxTrunkBaseHeight, (Random)rand);
        int leaf = ReikaRandomHelper.getRandomBetween((int)this.minFoliageHeight, (int)this.maxFoliageHeight, (Random)rand);
        Tree tree = new Tree(trunk, leaf);
        tree.calculate(world, rand, x, y, z);
        if (tree.canPlace(world)) {
            tree.place(world);
            return true;
        }
        return false;
    }

    private class Tree {
        private final HashSet<Coordinate> logs = new HashSet();
        private final MultiMap<Integer, Coordinate> leaves = new MultiMap(MultiMap.CollectionType.HASHSET);
        private final HashMap<Coordinate, Branch> branches = new HashMap();
        private final int trunkHeight;
        private final int leafHeight;
        private final int totalHeight;
        private int lowestLeafY = 999;
        private int currentRadius = 0;
        private float currentRadiusExponent = 0.5f;

        private Tree(int ht, int hl) {
            this.trunkHeight = ht;
            this.leafHeight = hl;
            this.totalHeight = ht + hl;
            this.currentRadius = Math.min(3, (int)((double)EnderOakGenerator.this.maxFoliageRadius * 0.8));
        }

        private void calculate(World world, Random rand, int x, int y, int z) {
            LobulatedCurve lc = new LobulatedCurve(1.0, (double)0.2f, 3, 1.0);
            lc.generate(rand);
            double hr = 1.0 + 1.2 * rand.nextDouble();
            for (int h = 0; h <= this.totalHeight; ++h) {
                Coordinate core = new Coordinate(x, y + h, z);
                if (h >= this.totalHeight - 1) {
                    this.leaves.addValue((Object)core.yCoord, (Object)core);
                } else {
                    this.logs.add(core);
                }
                if (h <= this.trunkHeight || h >= this.totalHeight) continue;
                this.generateLayer(world, rand, x, y, z, h, core, lc, hr);
            }
            if (EnderOakGenerator.this.branchChancePerLevel > 0.0f) {
                HashSet levels = new HashSet(this.leaves.keySet());
                for (int i = 0; i < 3; ++i) {
                    levels.remove(y + this.totalHeight - i);
                }
                if (!levels.isEmpty()) {
                    int n = 1;
                    while (n == 1) {
                        n = 0;
                        for (int i = 0; i < 3; ++i) {
                            if (!(rand.nextFloat() < EnderOakGenerator.this.branchChancePerLevel)) continue;
                            ++n;
                        }
                    }
                    if (n > 0) {
                        float phi0 = rand.nextFloat() * 360.0f;
                        float a0 = 360 / n;
                        for (int i = 0; i < n; ++i) {
                            int yl = (Integer)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, levels);
                            int dh = y + this.totalHeight - yl;
                            Coordinate c = new Coordinate(x, yl, z);
                            float phi = phi0 + a0 * (float)i;
                            phi = (float)ReikaRandomHelper.getRandomPlusMinus((double)phi, (double)24.0, (Random)rand);
                            float theta = (float)ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)30.0, (Random)rand);
                            theta = Math.min(theta, (float)Math.max(0, 10 * (dh - 3)));
                            this.branches.put(c, new Branch(c, phi, theta));
                        }
                    }
                }
                if (!this.branches.isEmpty()) {
                    for (Branch b : this.branches.values()) {
                        b.calculate(world, rand);
                        this.logs.addAll(b.logs);
                        ArrayList li = new ArrayList(b.leaves);
                        li.removeAll(this.logs);
                        for (Coordinate c : li) {
                            this.leaves.addValue((Object)c.yCoord, (Object)c);
                        }
                    }
                }
            }
            if (EnderOakGenerator.this.columnChancePerLeaf > 0.0f) {
                Collection li = this.leaves.get((Object)this.lowestLeafY);
                HashSet<Coordinate> leavesToAdd = new HashSet<Coordinate>();
                for (Coordinate c : li) {
                    if (c.xCoord == x && c.zCoord == z) continue;
                    int n = 0;
                    for (int i = 2; i < 6; ++i) {
                        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                        if (!li.contains(new Coordinate(c.xCoord + dir.offsetX, c.yCoord, c.zCoord + dir.offsetZ))) continue;
                        ++n;
                    }
                    if (n == 4 || !(rand.nextFloat() < EnderOakGenerator.this.columnChancePerLeaf)) continue;
                    for (int y2 = this.lowestLeafY; y2 >= 0 && this.canReplace(world, c.xCoord, y2, c.zCoord); --y2) {
                        Coordinate c2 = new Coordinate(c.xCoord, y2, c.zCoord);
                        leavesToAdd.add(c2);
                    }
                }
                for (Coordinate c : leavesToAdd) {
                    this.leaves.addValue((Object)c.yCoord, (Object)c);
                }
            }
        }

        private void generateLayer(World world, Random rand, int x, int y, int z, int h, Coordinate core, LobulatedCurve lc, double hr) {
            this.permuteRadius(rand, h);
            int r = this.currentRadius + 2;
            int dh = this.totalHeight - h;
            for (int i = -r; i <= r; ++i) {
                for (int k = -r; k <= r; ++k) {
                    double ia = Math.pow(Math.abs(i), 1.0 / (double)this.currentRadiusExponent);
                    double ka = Math.pow(Math.abs(k), 1.0 / (double)this.currentRadiusExponent);
                    double d = Math.pow(Math.abs(ia + ka), this.currentRadiusExponent);
                    double ang = Math.toDegrees(Math.atan2(k, i));
                    double dr = (double)this.currentRadius + 0.5;
                    dr *= lc.getRadius(ang);
                    double maxr = EnderOakGenerator.this.maxFoliageRadius;
                    maxr = Math.min(maxr, (double)dh * hr);
                    dr = MathHelper.func_151237_a((double)dr, (double)EnderOakGenerator.this.minFoliageRadius, (double)maxr);
                    if (!(d <= (dr = Math.min(maxr, dr)))) continue;
                    Coordinate c = new Coordinate(x + i, core.yCoord, z + k);
                    this.leaves.addValue((Object)c.yCoord, (Object)c);
                    this.lowestLeafY = Math.min(this.lowestLeafY, c.yCoord);
                }
            }
        }

        private void permuteRadius(Random rand, int y) {
            boolean decr;
            boolean incr;
            if (this.currentRadius == 0 || rand.nextInt(3) > 0) {
                incr = this.currentRadius < EnderOakGenerator.this.maxFoliageRadius;
                boolean bl = decr = this.currentRadius > EnderOakGenerator.this.minFoliageRadius;
                if (incr && decr) {
                    this.currentRadius += rand.nextBoolean() ? 1 : -1;
                } else if (incr) {
                    ++this.currentRadius;
                } else if (decr) {
                    --this.currentRadius;
                }
            }
            if (rand.nextInt(2) == 0) {
                incr = this.currentRadiusExponent < 0.65f;
                decr = this.currentRadiusExponent > 0.35f;
                int sign = 0;
                if (incr && decr) {
                    sign = rand.nextBoolean() ? 1 : -1;
                } else if (incr) {
                    sign = 1;
                } else if (decr) {
                    sign = -1;
                }
                this.currentRadiusExponent = (float)((double)this.currentRadiusExponent + (double)sign * ReikaRandomHelper.getRandomBetween((double)0.025, (double)0.1, (Random)rand));
            }
            int r = EnderOakGenerator.this.maxFoliageRadius;
            int dh = this.totalHeight - y;
            r = Math.min(r, dh);
            this.currentRadius = MathHelper.func_76125_a((int)this.currentRadius, (int)EnderOakGenerator.this.minFoliageRadius, (int)r);
            this.currentRadius = Math.min(this.currentRadius, r);
            this.currentRadiusExponent = MathHelper.func_76131_a((float)this.currentRadiusExponent, (float)0.35f, (float)0.65f);
        }

        private boolean canPlace(World world) {
            for (Coordinate c : this.logs) {
                boolean canPlace = this.canReplace(world, c.xCoord, c.yCoord, c.zCoord);
                if (canPlace) continue;
                return false;
            }
            int minLeaves = (int)((double)this.leaves.totalSize() * 0.75);
            int placeable = 0;
            for (Coordinate c : this.leaves.allValues(false)) {
                boolean canPlace = this.canReplace(world, c.xCoord, c.yCoord, c.zCoord);
                if (!canPlace) continue;
                ++placeable;
            }
            return placeable >= minLeaves;
        }

        private boolean canReplace(World world, int x, int y, int z) {
            if (ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)x, (int)y, (int)z)) {
                return true;
            }
            Block b = world.func_147439_a(x, y, z);
            if (b == Blocks.field_150349_c || b == Blocks.field_150346_d) {
                return false;
            }
            return b.canBeReplacedByLeaves((IBlockAccess)world, x, y, z) || EnderOakGenerator.super.isReplaceable(world, x, y, z);
        }

        private void place(World world) {
            for (Coordinate c : this.logs) {
                c.setBlock(world, ReikaTreeHelper.OAK.getLogID(), ReikaTreeHelper.OAK.getBaseLogMeta(), 2);
            }
            for (Coordinate c : this.leaves.allValues(false)) {
                if (this.logs.contains(c)) continue;
                c.setBlock(world, ReikaTreeHelper.OAK.getLeafID(), ReikaTreeHelper.OAK.getBaseLeafMeta(), 2);
            }
        }

        private class Branch {
            private final Coordinate root;
            private final HashSet<Coordinate> logs = new HashSet();
            private final HashSet<Coordinate> leaves = new HashSet();
            private final double xStep;
            private final double yStep;
            private final double zStep;

            private Branch(Coordinate c, float phi, float theta) {
                this.root = c;
                double[] xyz = ReikaPhysicsHelper.polarToCartesian((double)1.0, (double)theta, (double)phi);
                this.xStep = xyz[0];
                this.yStep = xyz[1];
                this.zStep = xyz[2];
            }

            private void calculate(World world, Random rand) {
                int l = Math.min((int)((double)Tree.this.leafHeight * 0.67), ReikaRandomHelper.getRandomBetween((int)2, (int)EnderOakGenerator.this.maxBranchLength));
                for (double d = 0.5; d <= (double)l; d += 0.5) {
                    double dx = (double)this.root.xCoord + 0.5 + this.xStep * d;
                    double dy = (double)this.root.yCoord + 0.5 + this.yStep * d;
                    double dz = (double)this.root.zCoord + 0.5 + this.zStep * d;
                    Coordinate core = new Coordinate(dx, dy, dz);
                    this.logs.add(core);
                    int n = ReikaRandomHelper.getRandomBetween((int)8, (int)20, (Random)rand);
                    for (int i = 0; i < n; ++i) {
                        double dz2;
                        double dy2;
                        double dx2 = ReikaRandomHelper.getRandomPlusMinus((double)dx, (double)1.5);
                        Coordinate c = new Coordinate(dx2, dy2 = ReikaRandomHelper.getRandomPlusMinus((double)dy, (double)1.5), dz2 = ReikaRandomHelper.getRandomPlusMinus((double)dz, (double)1.5));
                        if (this.logs.contains(c)) continue;
                        this.leaves.add(c);
                    }
                }
            }
        }
    }
}

