/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.IWG;

import Reika.ChromatiCraft.Auxiliary.Interfaces.ChromaDecorator;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.BiomeGlowingCliffs;
import Reika.DragonAPI.Interfaces.RetroactiveGenerator;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;

public class CaveIndicatorGenerator
implements RetroactiveGenerator,
ChromaDecorator {
    public static final CaveIndicatorGenerator instance = new CaveIndicatorGenerator();

    private CaveIndicatorGenerator() {
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.func_72912_H().func_76067_t() != WorldType.field_77138_c) {
            chunkX *= 16;
            chunkZ *= 16;
            for (int i = 0; i < 16; ++i) {
                for (int k = 0; k < 16; ++k) {
                    int posX = chunkX + i;
                    int posZ = chunkZ + k;
                    if (!BiomeGlowingCliffs.isGlowingCliffs(world.func_72807_a(posX, posZ))) continue;
                    int maxy = 64;
                    for (int n = 0; n < 2; ++n) {
                        int posY = 4 + random.nextInt(maxy - 4);
                        if (!CaveIndicatorGenerator.canGenerateAt(world, posX, posY, posZ)) continue;
                        world.func_147449_b(posX, posY, posZ, ChromaBlocks.CAVEINDICATOR.getBlockInstance());
                    }
                }
            }
        }
    }

    public static boolean canGenerateAt(World world, int x, int y, int z) {
        Block ida = world.func_147439_a(x, y + 1, z);
        if (ida != Blocks.field_150350_a && !ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)x, (int)(y + 1), (int)z)) {
            return false;
        }
        return CaveIndicatorGenerator.canGenerateIn(world, x, y, z) && !world.func_72937_j(x, y + 1, z) && world.func_72957_l(x, y, z) < 8;
    }

    public static boolean canGenerateIn(World world, int x, int y, int z) {
        Block id = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (id == Blocks.field_150350_a) {
            return false;
        }
        if (id == Blocks.field_150348_b) {
            return true;
        }
        if (id == Blocks.field_150346_d) {
            // empty if block
        }
        if (id == Blocks.field_150351_n) {
            // empty if block
        }
        if (id == Blocks.field_150347_e) {
            // empty if block
        }
        if (id == Blocks.field_150341_Y) {
            // empty if block
        }
        return id.isReplaceableOreGen(world, x, y, z, Blocks.field_150348_b);
    }

    public boolean canGenerateAt(World world, int chunkX, int chunkZ) {
        return true;
    }

    public String getIDString() {
        return "ChromatiCraft Piezo Crystals";
    }

    @Override
    public String getCommandID() {
        return "piezo";
    }
}

