/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.IWG;

import Reika.ChromatiCraft.API.Interfaces.DyeTreeBlocker;
import Reika.ChromatiCraft.Auxiliary.Interfaces.ChromaDecorator;
import Reika.ChromatiCraft.Block.Dye.BlockDyeSapling;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.ModInterface.MystPages;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.World.RainbowTreeGenerator;
import Reika.ChromatiCraft.World.TreeShaper;
import Reika.DragonAPI.Interfaces.RetroactiveGenerator;
import Reika.DragonAPI.Libraries.Registry.ReikaDyeHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaMystcraftHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.ThaumIDHandler;
import Reika.DragonAPI.ModInteract.ReikaTwilightHelper;
import Reika.DragonAPI.ModList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.BiomeDictionary;

public class ColorTreeGenerator
implements RetroactiveGenerator,
ChromaDecorator {
    public static final ColorTreeGenerator instance = new ColorTreeGenerator();
    private static final int CHANCE = 128;

    private ColorTreeGenerator() {
    }

    public void generate(Random r, int chunkX, int chunkZ, World world, IChunkProvider cg, IChunkProvider cp) {
        BiomeGenBase biome = world.func_72807_a(chunkX *= 16, chunkZ *= 16);
        int trees = ColorTreeGenerator.getTreeCount(world, biome);
        if (trees > 0) {
            int x = chunkX + r.nextInt(16);
            int z = chunkZ + r.nextInt(16);
            if (ColorTreeGenerator.canGenerateTree(world, x, z)) {
                for (int i = 0; i < trees; ++i) {
                    if (r.nextInt(128) != 0) continue;
                    int y = world.func_72825_h(x, z);
                    Block b = world.func_147439_a(x, y, z);
                    if (r.nextInt(this.getRainbowChance(world)) == 0 && RainbowTreeGenerator.getInstance().checkRainbowTreeSpace(world, x, y, z)) {
                        RainbowTreeGenerator.getInstance().generateLargeRainbowTree(world, x, y, z, r);
                        continue;
                    }
                    TreeShaper.getInstance().generateRandomWeightedTree(world, x, y, z, r, ReikaDyeHelper.dyes[r.nextInt(16)], false, 1.0f, 1.0f);
                }
            }
        }
    }

    private int getRainbowChance(World world) {
        return world.field_73011_w.field_76574_g == ReikaTwilightHelper.getDimensionID() ? 16 : 32;
    }

    public static int getTreeCount(World world, BiomeGenBase biome) {
        if (ModList.THAUMCRAFT.isLoaded() && biome.field_76756_M == ThaumIDHandler.Biomes.TAINT.getID()) {
            return 0;
        }
        BiomeDecorator dec = biome.field_76760_I;
        int trees = Math.max(0, dec.field_76832_z);
        if (biome == BiomeGenBase.field_76772_c) {
            trees += 2;
        }
        if (biome == BiomeGenBase.field_76767_f || biome == BiomeGenBase.field_76785_t) {
            trees += 6;
        }
        if (biome == BiomeGenBase.field_76770_e || biome == BiomeGenBase.field_76783_v) {
            trees += 3;
        }
        if (biome == BiomeGenBase.field_76775_o || biome == BiomeGenBase.field_76774_n) {
            trees += 3;
        }
        if (biome == BiomeGenBase.field_76782_w) {
            trees += 3;
        }
        if (biome == BiomeGenBase.field_76780_h) {
            trees += 3;
        }
        if (ModList.MYSTCRAFT.isLoaded() && ReikaMystcraftHelper.isMystAge((World)world) && MystPages.Pages.DENSE.existsInWorld(world)) {
            trees *= 2;
        }
        if (trees > 0) {
            return trees;
        }
        BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome);
        for (int i = 0; i < types.length; ++i) {
            if (types[i] == BiomeDictionary.Type.FOREST) {
                trees = Math.max(trees, ColorTreeGenerator.getTreeCount(world, BiomeGenBase.field_76767_f));
            }
            if (types[i] == BiomeDictionary.Type.MOUNTAIN) {
                trees = Math.max(trees, ColorTreeGenerator.getTreeCount(world, BiomeGenBase.field_76770_e));
            }
            if (types[i] == BiomeDictionary.Type.JUNGLE) {
                trees = Math.max(trees, ColorTreeGenerator.getTreeCount(world, BiomeGenBase.field_76782_w));
            }
            if (types[i] == BiomeDictionary.Type.HILLS) {
                trees = Math.max(trees, ColorTreeGenerator.getTreeCount(world, BiomeGenBase.field_76785_t));
            }
            if (types[i] == BiomeDictionary.Type.SNOWY) {
                trees = Math.max(trees, ColorTreeGenerator.getTreeCount(world, BiomeGenBase.field_76774_n));
            }
            if (types[i] == BiomeDictionary.Type.PLAINS) {
                trees = Math.max(trees, ColorTreeGenerator.getTreeCount(world, BiomeGenBase.field_76772_c));
            }
            if (types[i] != BiomeDictionary.Type.SWAMP) continue;
            trees = Math.max(trees, ColorTreeGenerator.getTreeCount(world, BiomeGenBase.field_76780_h));
        }
        return trees;
    }

    public static boolean canGenerateTree(World world, int x, int z) {
        if (world.field_72995_K) {
            return false;
        }
        if (Math.abs(world.field_73011_w.field_76574_g) == 1) {
            return false;
        }
        if (Math.abs(world.field_73011_w.field_76574_g) == ReikaTwilightHelper.getDimensionID()) {
            return false;
        }
        if (world.func_72912_H().func_76067_t() == WorldType.field_77138_c && !ChromaOptions.FLATGEN.getState()) {
            return false;
        }
        BiomeGenBase biome = world.func_72807_a(x, z);
        if (ModList.MYSTCRAFT.isLoaded() && ReikaMystcraftHelper.isMystAge((World)world) && !ChromatiCraft.isRainbowForest(biome) && !MystPages.Pages.TREES.existsInWorld(world)) {
            return false;
        }
        if (biome instanceof DyeTreeBlocker) {
            return false;
        }
        BiomeDecorator dec = biome.field_76760_I;
        if (biome == BiomeGenBase.field_76771_b || biome == BiomeGenBase.field_76776_l) {
            return false;
        }
        if (biome == BiomeGenBase.field_76769_d || biome == BiomeGenBase.field_76786_s || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY)) {
            return false;
        }
        if (biome == BiomeGenBase.field_76789_p || biome == BiomeGenBase.field_76788_q || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) {
            return false;
        }
        int y = world.func_72825_h(x, z);
        return BlockDyeSapling.canGrowAt(world, x, y, z, true);
    }

    public boolean canGenerateAt(World world, int chunkX, int chunkZ) {
        return true;
    }

    public String getIDString() {
        return "ChromatiCraft Trees";
    }

    @Override
    public String getCommandID() {
        return "dyetree";
    }
}

