/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.IWG;

import Reika.ChromatiCraft.API.Event.CrystalGenEvent;
import Reika.ChromatiCraft.Auxiliary.Interfaces.ChromaDecorator;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.ModInterface.MystPages;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.DragonAPI.Interfaces.RetroactiveGenerator;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaMystcraftHelper;
import Reika.DragonAPI.ModInteract.ReikaTwilightHelper;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.MinecraftForge;

public class CrystalGenerator
implements RetroactiveGenerator,
ChromaDecorator {
    public static final CrystalGenerator instance = new CrystalGenerator();
    private static final int PER_CHUNK = 60;

    private CrystalGenerator() {
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        chunkX *= 16;
        chunkZ *= 16;
        int i = 0;
        while (true) {
            if (!((float)i < 60.0f * CrystalGenerator.getDensityFactor(world, chunkX, chunkZ))) break;
            int posX = chunkX + random.nextInt(16);
            int posZ = chunkZ + random.nextInt(16);
            int maxy = 64;
            if (world.field_73011_w.field_76575_d) {
                maxy = 128;
            }
            int posY = 4 + random.nextInt(maxy - 4);
            Block id = ChromaBlocks.CRYSTAL.getBlockInstance();
            int meta = random.nextInt(16);
            if (CrystalGenerator.canGenerateAt(world, posX, posY, posZ)) {
                world.func_147465_d(posX, posY, posZ, id, meta, 3);
                MinecraftForge.EVENT_BUS.post((Event)new CrystalGenEvent(world, posX, posY, posZ, random, meta));
            }
            int r = 3;
            for (int k = -r; k <= r; ++k) {
                for (int l = -r; l <= r; ++l) {
                    for (int m = -r; m <= r; ++m) {
                        world.func_147479_m(posX, posY, posZ);
                    }
                }
            }
            ++i;
        }
    }

    public static boolean canGenerateAt(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        Block idb = world.func_147439_a(x, y - 1, z);
        int metab = world.func_72805_g(x, y - 1, z);
        if (b != Blocks.field_150350_a && !ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)x, (int)y, (int)z)) {
            return false;
        }
        if (b instanceof BlockLiquid) {
            return false;
        }
        if (!CrystalGenerator.canGenerateOn(world, x, y - 1, z)) {
            return false;
        }
        return ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150350_a) != null;
    }

    public static boolean canGenerateOn(World world, int x, int y, int z) {
        Block id = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (id == Blocks.field_150350_a) {
            return false;
        }
        if (id == Blocks.field_150348_b) {
            return true;
        }
        if (id == Blocks.field_150346_d) {
            return true;
        }
        if (id == Blocks.field_150351_n) {
            return true;
        }
        if (id == Blocks.field_150344_f) {
            return true;
        }
        if (id == Blocks.field_150357_h) {
            return true;
        }
        if (id == Blocks.field_150343_Z) {
            return true;
        }
        if (id == Blocks.field_150417_aV) {
            return true;
        }
        if (id == Blocks.field_150418_aU) {
            return true;
        }
        if (id == Blocks.field_150347_e) {
            return true;
        }
        if (id == Blocks.field_150341_Y) {
            return true;
        }
        if (id == Blocks.field_150424_aL) {
            return true;
        }
        if (ReikaBlockHelper.isOre((Block)id, (int)meta)) {
            return true;
        }
        return id.isReplaceableOreGen(world, x, y, z, Blocks.field_150348_b);
    }

    public static float getDensityFactor(World world, int x, int z) {
        if (world.field_73011_w.field_76577_b == WorldType.field_77138_c) {
            return 0.0f;
        }
        if (world.field_73011_w.field_76574_g == 1) {
            return 0.0f;
        }
        if (ModList.MYSTCRAFT.isLoaded() && ReikaMystcraftHelper.isMystAge((World)world) && !MystPages.Pages.CRYSTALS.existsInWorld(world)) {
            return 0.0f;
        }
        if (world.field_73011_w.field_76575_d) {
            return ChromaOptions.NETHER.getState() ? 0.25f : 0.0f;
        }
        if (ModList.MYSTCRAFT.isLoaded() && ReikaMystcraftHelper.isMystAge((World)world) && MystPages.Pages.DENSE.existsInWorld(world)) {
            return 1.75f;
        }
        BiomeGenBase biome = world.func_72807_a(x, z);
        if (world.field_73011_w.field_76574_g == ReikaTwilightHelper.getDimensionID()) {
            return 2.0f;
        }
        if (ChromatiCraft.isRainbowForest(biome)) {
            return 1.5f;
        }
        if (biome == BiomeGenBase.field_76789_p || biome == BiomeGenBase.field_76788_q) {
            return 1.375f;
        }
        if (biome == BiomeGenBase.field_76771_b || biome == BiomeGenBase.field_76776_l) {
            return 1.25f;
        }
        if (biome == BiomeGenBase.field_76770_e || biome == BiomeGenBase.field_76783_v) {
            return 1.125f;
        }
        return 1.0f;
    }

    public boolean canGenerateAt(World world, int chunkX, int chunkZ) {
        return true;
    }

    public String getIDString() {
        return "ChromatiCraft Crystals";
    }

    @Override
    public String getCommandID() {
        return "crystal";
    }
}

