/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.IWG;

import Reika.ChromatiCraft.Auxiliary.Structure.Worldgen.BurrowStructure;
import Reika.ChromatiCraft.Auxiliary.Structure.Worldgen.DesertStructure;
import Reika.ChromatiCraft.Auxiliary.Structure.Worldgen.OceanStructure;
import Reika.ChromatiCraft.Base.ChromaStructureBase;
import Reika.ChromatiCraft.Base.FragmentStructureBase;
import Reika.ChromatiCraft.Base.GeneratedStructureBase;
import Reika.ChromatiCraft.Block.Worldgen.BlockLootChest;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.ModInterface.MystPages;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaStructures;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Registry.ExtraChromaIDs;
import Reika.ChromatiCraft.TileEntity.Technical.TileEntityStructControl;
import Reika.ChromatiCraft.World.BiomeGlowingCliffs;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldChunk;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.Maps.TileEntityCache;
import Reika.DragonAPI.Instantiable.IO.NBTFile;
import Reika.DragonAPI.Instantiable.Math.Noise.VoronoiNoiseGenerator;
import Reika.DragonAPI.Interfaces.RetroactiveGenerator;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaTreeHelper;
import Reika.DragonAPI.Libraries.ReikaSpawnerHelper;
import Reika.DragonAPI.Libraries.World.ReikaBiomeHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.PlanetDimensionHandler;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaMystcraftHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.ExtraUtilsHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.TwilightForestHandler;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import Reika.Satisforestry.API.SFAPI;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.BlockFluidBase;

public class DungeonGenerator
implements RetroactiveGenerator {
    public static final DungeonGenerator instance = new DungeonGenerator();
    private final ForgeDirection[] dirs = ForgeDirection.values();
    private File statusCacheFile;
    private EnumMap<ChromaStructures, VoronoiNoiseGenerator> structs = new EnumMap(ChromaStructures.class);
    private EnumMap<ChromaStructures, HashMap<WorldChunk, StructureGenStatus>> statusMap = new EnumMap(ChromaStructures.class);
    private EnumMap<ChromaStructures, TileEntityCache<StructureGenData>> structureMap = new EnumMap(ChromaStructures.class);

    private DungeonGenerator() {
        ChromaStructures[] li;
        for (ChromaStructures s : li = new ChromaStructures[]{ChromaStructures.CAVERN, ChromaStructures.BURROW, ChromaStructures.OCEAN, ChromaStructures.DESERT, ChromaStructures.SNOWSTRUCT, ChromaStructures.BIOMEFRAG}) {
            this.structs.put(s, null);
            this.structureMap.put(s, (TileEntityCache<StructureGenData>)new TileEntityCache());
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void updateNoisemaps(World world) {
        for (Map.Entry<ChromaStructures, VoronoiNoiseGenerator> e : this.structs.entrySet()) {
            VoronoiNoiseGenerator v = e.getValue();
            ChromaStructures s = e.getKey();
            ReikaWorldHelper.WorldID id = ReikaWorldHelper.getCurrentWorldID((World)world);
            long sd = world.func_72905_C() ^ (long)(s.ordinal() * 41381) ^ (id.worldCreationTime ^ 0xFFFFFFFFFFFFFFFFL);
            if (v != null && v.seed == sd) continue;
            v = (VoronoiNoiseGenerator)new VoronoiNoiseGenerator(sd ^ (long)(ReikaFileReader.getRealPath((File)world.func_72860_G().func_75765_b()).hashCode() + s.ordinal())).setFrequency(0.75 / (double)this.getNoiseScale(s));
            v.randomFactor = 0.55;
            e.setValue(v);
        }
    }

    public Collection<ChromaStructures> getStructureTypes() {
        return Collections.unmodifiableCollection(this.structs.keySet());
    }

    private Collection<WorldLocation> getNearbyZones(ChromaStructures s, WorldServer world, double x, double z, double r) {
        this.updateNoisemaps((World)world);
        Collection li = this.structs.get((Object)s).getCellsWithin2D(x, z, r);
        ArrayList<WorldLocation> ret = new ArrayList<WorldLocation>();
        HashMap<WorldChunk, StructureGenStatus> cache = this.getStatusCache(s);
        for (DecimalPosition d : li) {
            int cz;
            int cx = MathHelper.func_76128_c((double)d.xCoord) >> 4;
            WorldChunk wc = new WorldChunk((World)world, cx, cz = MathHelper.func_76128_c((double)d.zCoord) >> 4);
            StructureGenStatus get = cache.get(wc);
            if (get == null) {
                cache.put(wc, StructureGenStatus.PLANNED);
            }
            if (get != null && get.isFinalized() && !get.hasStructure()) continue;
            ret.add(new WorldLocation((World)world, d));
        }
        return ret;
    }

    private WorldLocation getNearestZone(ChromaStructures s, WorldServer world, double x, double z, double r) {
        return this.getNearestZone(s, world, x, z, r, null);
    }

    private WorldLocation getNearestZone(ChromaStructures s, WorldServer world, double x, double z, double r, WorldLocation exclude) {
        Collection<WorldLocation> c = this.getNearbyZones(s, world, MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)z), r);
        WorldLocation closest = null;
        double d = Double.POSITIVE_INFINITY;
        for (WorldLocation loc : c) {
            if (exclude != null && exclude.equals((Object)loc)) continue;
            double dist = loc.getDistanceTo(x, (double)loc.yCoord, z);
            if (closest != null && !(dist < d) || !(dist <= r)) continue;
            d = dist;
            closest = loc;
        }
        return closest;
    }

    public StructureSeekData getNearestRealStructure(ChromaStructures s, WorldServer world, double x, double z, double r, boolean requireGenned) {
        this.updateNoisemaps((World)world);
        WorldLocation src = new WorldLocation((World)world, x, 0.0, z);
        TileEntityCache<StructureGenData> cache = this.structureMap.get((Object)s);
        Collection li = cache.getAllLocationsNear(src, r);
        Iterator it = li.iterator();
        while (it.hasNext()) {
            WorldLocation loc = (WorldLocation)it.next();
            StructureGenData dat = (StructureGenData)cache.get(loc);
            StructureGenStatus stat = dat.status;
            if (!stat.hasStructure() && stat.isFinalized()) {
                it.remove();
                continue;
            }
            if (requireGenned && !stat.isGenerated()) {
                it.remove();
                continue;
            }
            if (stat != StructureGenStatus.INERT && stat != StructureGenStatus.INERT_GEN) continue;
            it.remove();
        }
        boolean genned = true;
        if (!requireGenned && li.isEmpty()) {
            genned = false;
            Collection li2 = this.structs.get((Object)s).getCellsWithin2D(x, z, r);
            Iterator it2 = li2.iterator();
            while (it2.hasNext()) {
                DecimalPosition loc = (DecimalPosition)it2.next();
                StructureGenStatus stat = this.getGenStatus(s, world, MathHelper.func_76128_c((double)loc.xCoord), MathHelper.func_76128_c((double)loc.zCoord));
                if (!stat.hasStructure() && stat.isFinalized()) {
                    it2.remove();
                    continue;
                }
                if (requireGenned && !stat.isGenerated()) {
                    it2.remove();
                    continue;
                }
                if (stat == StructureGenStatus.INERT || stat == StructureGenStatus.INERT_GEN) {
                    it2.remove();
                    continue;
                }
                if (this.isValidBiomeNear((World)world, MathHelper.func_76128_c((double)loc.xCoord), MathHelper.func_76128_c((double)loc.zCoord), s)) continue;
                it2.remove();
            }
            if (li2.isEmpty()) {
                return null;
            }
            for (DecimalPosition loc : li2) {
                li.add(new WorldLocation((World)world, loc));
            }
        }
        if (li.isEmpty()) {
            return null;
        }
        WorldLocation closest = null;
        double d = Double.POSITIVE_INFINITY;
        for (WorldLocation loc : li) {
            double dist = loc.getDistanceTo(x, (double)loc.yCoord, z);
            if (closest != null && !(dist < d) || !(dist <= r)) continue;
            d = dist;
            closest = loc;
        }
        return closest == null ? null : new StructureSeekData(closest, genned);
    }

    public StructureGenStatus getGenStatus(ChromaStructures s, WorldServer world, int x, int z) {
        StructureGenStatus def = this.isGennableChunk((World)world, x, z, s);
        boolean genned = ReikaWorldHelper.isChunkGenerated((WorldServer)world, (int)x, (int)z);
        if (def == StructureGenStatus.INERT && genned) {
            def = StructureGenStatus.INERT_GEN;
        }
        Collection<WorldLocation> c = this.getNearbyZones(s, world, x, z, 32.0);
        HashMap<WorldChunk, StructureGenStatus> cache = this.getStatusCache(s);
        for (WorldLocation loc : c) {
            WorldChunk wc = new WorldChunk((World)world, loc.xCoord >> 4, loc.zCoord >> 4);
            StructureGenStatus get = cache.get(wc);
            if (get != null && !def.canOverwrite(get)) continue;
            cache.put(wc, def);
        }
        WorldChunk wc = new WorldChunk((World)world, x >> 4, z >> 4);
        StructureGenStatus stat = cache.get(wc);
        if (stat == StructureGenStatus.INERT && genned) {
            stat = StructureGenStatus.INERT_GEN;
            cache.put(wc, stat);
        }
        return stat != null ? stat : def;
    }

    private void markChunkStatus(World world, int x, int z, ChromaStructures s, StructureGenStatus stat) {
        WorldChunk wc = new WorldChunk(world, x, z);
        this.getStatusCache(s).put(wc, stat);
        TileEntityCache<StructureGenData> cache = this.structureMap.get((Object)s);
        WorldLocation loc = new WorldLocation(world, x << 4, 0, z << 4);
        StructureGenData data = (StructureGenData)cache.get(loc);
        if (data == null) {
            data = new StructureGenData(wc, stat);
            cache.put(loc, (Object)data);
        }
        data.status = stat;
    }

    public void recacheStructureTile(TileEntityStructControl te) {
        this.markChunkStatus(te.field_145850_b, te.field_145851_c >> 4, te.field_145849_e >> 4, te.getStructureType(), StructureGenStatus.SUCCESS);
    }

    public void removeStructureTile(TileEntityStructControl te) {
        this.markChunkStatus(te.field_145850_b, te.field_145851_c >> 4, te.field_145849_e >> 4, te.getStructureType(), StructureGenStatus.REMOVED);
    }

    private HashMap<WorldChunk, StructureGenStatus> getStatusCache(ChromaStructures s) {
        HashMap<Object, StructureGenStatus> set;
        if (this.statusMap.isEmpty()) {
            try {
                this.loadStatusCache();
            }
            catch (IOException e) {
                ChromatiCraft.logger.logError((Object)"Could not load structure status cache!");
                e.printStackTrace();
            }
        }
        if ((set = this.statusMap.get((Object)s)) == null) {
            set = new HashMap();
            this.statusMap.put(s, set);
        }
        return set;
    }

    private void loadStatusCache() throws IOException {
        HashMap ret = new HashMap();
        NBTFile.SimpleNBTFile nf = new NBTFile.SimpleNBTFile(this.statusCacheFile);
        nf.load();
        if (nf.data != null) {
            this.loadStatusCacheFromNBT(nf.data);
        }
    }

    @SubscribeEvent
    public void saveStatusCache(WorldEvent.Save evt) throws IOException {
        if (evt.world.field_73011_w.field_76574_g == 0) {
            NBTTagCompound tag = new NBTTagCompound();
            this.writeStatusCacheToNBT(tag);
            NBTFile.SimpleNBTFile nf = new NBTFile.SimpleNBTFile(this.statusCacheFile);
            nf.data = tag;
            nf.save();
        }
    }

    private void loadStatusCacheFromNBT(NBTTagCompound data) {
        for (Object o : data.func_150296_c()) {
            String sg = (String)o;
            NBTTagCompound tag = data.func_74775_l(sg);
            ChromaStructures s = ChromaStructures.valueOf(sg);
            HashMap<WorldChunk, StructureGenStatus> map = this.loadMapFromNBT(s, tag);
            this.statusMap.put(s, map);
        }
    }

    private void writeStatusCacheToNBT(NBTTagCompound nbt) {
        for (ChromaStructures s : this.statusMap.keySet()) {
            HashMap<WorldChunk, StructureGenStatus> map = this.statusMap.get((Object)s);
            NBTTagCompound tag = new NBTTagCompound();
            this.writeMapToNBT(tag, map);
            nbt.func_74782_a(s.name(), (NBTBase)tag);
        }
    }

    private HashMap<WorldChunk, StructureGenStatus> loadMapFromNBT(ChromaStructures s, NBTTagCompound tag) {
        HashMap<WorldChunk, StructureGenStatus> map = new HashMap<WorldChunk, StructureGenStatus>();
        for (Object o : tag.func_150296_c()) {
            String sg = (String)o;
            WorldChunk wc = WorldChunk.fromSerialString((String)sg);
            map.put(wc, StructureGenStatus.valueOf(tag.func_74779_i(sg)));
        }
        return map;
    }

    private void writeMapToNBT(NBTTagCompound tag, HashMap<WorldChunk, StructureGenStatus> map) {
        for (Map.Entry<WorldChunk, StructureGenStatus> e : map.entrySet()) {
            tag.func_74778_a(e.getKey().toSerialString(), e.getValue().name());
        }
    }

    public void updateStatusCacheFile() {
        File f = DimensionManager.getCurrentSaveRootDirectory();
        if (f == null) {
            throw new IllegalStateException("Could not find a world to define structure status cache!");
        }
        this.statusCacheFile = new File(f, "ChromatiCraft_Data/StructureStatus.dat");
    }

    private int getNoiseScale(ChromaStructures s) {
        switch (s) {
            case DESERT: {
                return 440;
            }
            case OCEAN: {
                return 640;
            }
            case CAVERN: {
                return 144;
            }
            case BURROW: {
                return 240;
            }
            case SNOWSTRUCT: {
                return 480;
            }
            case BIOMEFRAG: {
                return 640;
            }
        }
        return 1;
    }

    private int getExclusionZone(ChromaStructures s) {
        switch (s) {
            case DESERT: {
                return 256;
            }
            case OCEAN: {
                return 512;
            }
            case CAVERN: {
                return 64;
            }
            case BURROW: {
                return 64;
            }
            case SNOWSTRUCT: {
                return 256;
            }
            case BIOMEFRAG: {
                return 440;
            }
        }
        return 1;
    }

    public void onGenerateStructure(ChromaStructures s, FragmentStructureBase s2, World world, TileEntityStructControl te) {
        s2.onPlace(world, te);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (this.canGenerateIn(world)) {
            for (ChromaStructures s : this.structs.keySet()) {
                this.checkChunk(world, chunkX, chunkZ, random, s);
            }
        }
    }

    private boolean checkChunk(World world, int chunkX, int chunkZ, Random random, ChromaStructures s) {
        if (!this.isVoidWorld(world, chunkX * 16, chunkZ * 16) && this.isGennableChunk(world, chunkX * 16, chunkZ * 16, s) == StructureGenStatus.PLANNED) {
            ChunkCoordIntPair pos = this.tryGenerateInChunk(world, chunkX * 16, chunkZ * 16, random, s, ChromaOptions.getStructureTriesPerChunk());
            if (pos == null) {
                pos = this.tryGenerateInChunksAround(world, chunkX * 16, chunkZ * 16, random, s, ChromaOptions.getStructureTriesPerChunk());
            }
            if (pos != null) {
                this.markChunkStatus(world, chunkX, chunkZ, s, StructureGenStatus.INERT_GEN);
                this.markChunkStatus(world, pos.field_77276_a, pos.field_77275_b, s, StructureGenStatus.SUCCESS);
                return true;
            }
            this.markChunkStatus(world, chunkX, chunkZ, s, StructureGenStatus.FAILURE);
        }
        return false;
    }

    private ChunkCoordIntPair tryGenerateInChunksAround(World world, int cx, int cz, Random rnd, ChromaStructures s, int tries) {
        for (int r = 16; r <= this.getChunkKeepTryingRange(s); r += 16) {
            for (int i = -r; i <= r; i += 16) {
                for (int k = -r; k <= r; k += 16) {
                    int dz;
                    int dx;
                    ChunkCoordIntPair ret;
                    if (i == 0 && k == 0 || (ret = this.tryGenerateInChunk(world, dx = cx + i, dz = cz + k, rnd, s, tries)) == null) continue;
                    return ret;
                }
            }
        }
        return null;
    }

    private int getChunkKeepTryingRange(ChromaStructures s) {
        switch (s) {
            case OCEAN: 
            case SNOWSTRUCT: {
                return 96;
            }
            case DESERT: 
            case BIOMEFRAG: {
                return 64;
            }
        }
        return 48;
    }

    private ChunkCoordIntPair tryGenerateInChunk(World world, int cx, int cz, Random r, ChromaStructures s, int tries) {
        this.markChunkStatus(world, cx >> 4, cz >> 4, s, StructureGenStatus.GENERATING);
        boolean flag = false;
        int n = 0;
        block20: while (!flag && n < tries) {
            int x = cx + r.nextInt(16);
            int z = cz + r.nextInt(16);
            int rx = x;
            int rz = z;
            FragmentStructureBase s2 = (FragmentStructureBase)s.getStructure();
            s2.resetToDefaults();
            s2.markForWorldgen();
            s2.setRNG(r);
            ++n;
            if (!this.isValidBiome(s, world.func_72807_a(x, z))) continue;
            switch (s) {
                default: {
                    break;
                }
                case CAVERN: {
                    int y = 10 + r.nextInt(40);
                    FilledBlockArray struct = ChromaStructures.CAVERN.getArray(world, x, y, z, r);
                    if (!this.isValidCavernLocation(world, x, y, z, struct)) break;
                    struct.place(2);
                    TileEntityStructControl te = null;
                    for (int i = 7; i < 18; ++i) {
                        int dx = x + i;
                        Block b = world.func_147439_a(dx, y, z);
                        Block b2 = world.func_147439_a(dx, y - 1, z);
                        if (b.isAir((IBlockAccess)world, dx, y, z) && b2.isAir((IBlockAccess)world, dx, y - 1, z)) break;
                        world.func_147449_b(dx, y, z, Blocks.field_150350_a);
                        world.func_147449_b(dx, y - 1, z, Blocks.field_150350_a);
                    }
                    try {
                        world.func_147465_d(x, y, z, ChromaTiles.STRUCTCONTROL.getBlock(), ChromaTiles.STRUCTCONTROL.getBlockMetadata(), 3);
                        te = (TileEntityStructControl)world.func_147438_o(x, y, z);
                        te.generate(s, CrystalElement.WHITE);
                        rx = te.field_145851_c;
                        rz = te.field_145849_e;
                        this.onGenerateStructure(s, s2, world, te);
                    }
                    catch (Exception e) {
                        ((GeneratedStructureBase)s.getStructure()).addError(new Exception("Failed to place controller @ " + x + ", " + y + ", " + z, e));
                    }
                    this.populateChests(s, struct, r);
                    ((GeneratedStructureBase)s.getStructure()).runCallbacks(world, r);
                    flag = true;
                    this.logErrors(world, x, y, z, s, te);
                    break;
                }
                case BURROW: {
                    int y = this.getTop(world, x, z) - 1;
                    CrystalElement e = CrystalElement.randomElement();
                    FilledBlockArray arr = ChromaStructures.BURROW.getArray(world, x, y, z, r, e);
                    if (!this.isValidBurrowLocation(world, x, y, z, arr)) break;
                    ((GeneratedStructureBase)s.getStructure()).markForWorldgen();
                    arr.place(2);
                    TileEntityStructControl te = null;
                    this.populateChests(s, arr, r);
                    FilledBlockArray furn = null;
                    FilledBlockArray loot = null;
                    if (r.nextInt(2) == 0 && (furn = this.tryGenerateBurrowFurnaceRoom(world, x, y, z, s, arr, r)) != null && r.nextInt(2) == 0) {
                        loot = this.tryGenerateBurrowLootRoom(world, x, y, z, s, arr, r);
                    }
                    try {
                        world.func_147465_d(x - 5, y - 8, z - 2, ChromaTiles.STRUCTCONTROL.getBlock(), ChromaTiles.STRUCTCONTROL.getBlockMetadata(), 3);
                        te = (TileEntityStructControl)world.func_147438_o(x - 5, y - 8, z - 2);
                        te.generate(s, e);
                        te.setBurrowAddons(furn != null, loot != null);
                        rx = te.field_145851_c;
                        rz = te.field_145849_e;
                        this.onGenerateStructure(s, s2, world, te);
                    }
                    catch (Exception ex) {
                        ((GeneratedStructureBase)s.getStructure()).addError(new Exception("Failed to place controller @ " + (x - 5) + ", " + (y - 8) + ", " + (z - 2), ex));
                    }
                    ((GeneratedStructureBase)s.getStructure()).runCallbacks(world, r);
                    this.modifyBlocks(s, arr, r, Modify.MOSSIFY, Modify.GRASSDIRT);
                    if (furn != null) {
                        this.modifyBlocks(s, furn, r, Modify.MOSSIFY, Modify.GRASSDIRT);
                    }
                    if (loot != null) {
                        this.modifyBlocks(s, loot, r, Modify.MOSSIFY, Modify.GRASSDIRT);
                    }
                    flag = true;
                    this.logErrors(world, x, y, z, s, te);
                    break;
                }
                case OCEAN: {
                    int d = 3;
                    int y = this.getTop(world, x, z) - d;
                    Block b = world.func_147439_a(x, y + d, z);
                    if (b != Blocks.field_150355_j && b != Blocks.field_150358_i) break;
                    FilledBlockArray struct = ChromaStructures.OCEAN.getArray(world, x, y, z, r);
                    if (y <= 0 || !this.isValidOceanLocation(world, x, y, z, struct)) break;
                    struct.place(2);
                    TileEntityStructControl te = null;
                    try {
                        world.func_147465_d(x, y, z, ChromaTiles.STRUCTCONTROL.getBlock(), ChromaTiles.STRUCTCONTROL.getBlockMetadata(), 3);
                        te = (TileEntityStructControl)world.func_147438_o(x, y, z);
                        te.generate(s, CrystalElement.WHITE);
                        rx = te.field_145851_c;
                        rz = te.field_145849_e;
                        this.onGenerateStructure(s, s2, world, te);
                    }
                    catch (Exception e) {
                        ((GeneratedStructureBase)s.getStructure()).addError(new Exception("Failed to place controller @ " + x + ", " + y + ", " + z, e));
                    }
                    this.populateChests(s, struct, r);
                    this.programSpawners(s, struct);
                    ((GeneratedStructureBase)s.getStructure()).runCallbacks(world, r);
                    this.modifyBlocks(s, struct, r, Modify.MOSSIFY);
                    this.generatePit(world, x, y, z);
                    flag = true;
                    this.logErrors(world, x, y, z, s, te);
                    break;
                }
                case DESERT: {
                    int y = this.getTop(world, x, z);
                    if (world.func_147439_a(x, y - 1, z) != Blocks.field_150354_m) continue block20;
                    Block b = world.func_147439_a(x, y -= 8, z);
                    BiomeGenBase biome = world.func_72807_a(x, z);
                    if (!this.isValidBiomeForDesertStruct(biome)) break;
                    FilledBlockArray struct = ChromaStructures.DESERT.getArray(world, x -= 7, y -= 3, z -= 7, r);
                    DesertStructure.getTerrain(struct, x, y, z);
                    if (!this.isValidDesertLocation(world, x, y, z, struct)) break;
                    struct.place(2);
                    TileEntityStructControl te = null;
                    try {
                        world.func_147465_d(x + 7, y + 3, z + 7, ChromaTiles.STRUCTCONTROL.getBlock(), ChromaTiles.STRUCTCONTROL.getBlockMetadata(), 3);
                        te = (TileEntityStructControl)world.func_147438_o(x + 7, y + 3, z + 7);
                        te.generate(s, CrystalElement.WHITE);
                        rx = te.field_145851_c;
                        rz = te.field_145849_e;
                        this.onGenerateStructure(s, s2, world, te);
                    }
                    catch (Exception e) {
                        ((GeneratedStructureBase)s.getStructure()).addError(new Exception("Failed to place controller @ " + (x + 7) + ", " + (y + 3) + ", " + (z + 7), e));
                    }
                    this.populateChests(s, struct, r);
                    this.programSpawners(s, struct);
                    ((GeneratedStructureBase)s.getStructure()).runCallbacks(world, r);
                    for (int k = 0; k < struct.getSize(); ++k) {
                        Coordinate c = struct.getNthBlock(k);
                        if (c.yCoord <= struct.getMaxY() - 2) continue;
                        Block b1 = c.offset(0, 1, 0).getBlock((IBlockAccess)world);
                        Block b2 = c.offset(0, -1, 0).getBlock((IBlockAccess)world);
                        if (b1 != Blocks.field_150350_a || b2 != Blocks.field_150354_m || !ReikaRandomHelper.doWithChance((double)(20.0 + 30.0 * (double)Math.abs(Math.abs(c.xCoord - struct.getMidX()) + Math.abs(c.zCoord - struct.getMidZ())) / 7.0))) continue;
                        c.setBlock(world, Blocks.field_150350_a);
                    }
                    for (int k1 = struct.getMinX(); k1 <= struct.getMaxX(); ++k1) {
                        for (int k2 = struct.getMinZ(); k2 <= struct.getMaxZ(); ++k2) {
                            Coordinate c = new Coordinate(k1, this.getTop(world, k1, k2), k2);
                            if (c.getBlock((IBlockAccess)world) != Blocks.field_150350_a || c.offset(0, -1, 0).getBlock((IBlockAccess)world) != Blocks.field_150354_m || !ReikaRandomHelper.doWithChance((double)2.0) || c.offset(1, 0, 0).getBlock((IBlockAccess)world) != Blocks.field_150350_a || c.offset(-1, 0, 0).getBlock((IBlockAccess)world) != Blocks.field_150350_a || c.offset(0, 0, 1).getBlock((IBlockAccess)world) != Blocks.field_150350_a || c.offset(0, 0, -1).getBlock((IBlockAccess)world) != Blocks.field_150350_a) continue;
                            c.setBlock(world, Blocks.field_150434_aF);
                            if (!ReikaRandomHelper.doWithChance((double)40.0)) continue;
                            c.offset(0, 1, 0).setBlock(world, Blocks.field_150434_aF);
                            if (!ReikaRandomHelper.doWithChance((double)40.0)) continue;
                            c.offset(0, 2, 0).setBlock(world, Blocks.field_150434_aF);
                        }
                    }
                    flag = true;
                    this.logErrors(world, x, y, z, s, te);
                    break;
                }
                case SNOWSTRUCT: {
                    int y = this.getTop(world, x, z) - 1;
                    FilledBlockArray arr = ChromaStructures.SNOWSTRUCT.getArray(world, x, y, z, r);
                    if (!this.isValidSnowStructLocation(world, x, y, z, arr)) break;
                    ((GeneratedStructureBase)s.getStructure()).offset(0, -6, 0, arr);
                    arr.place(2);
                    TileEntityStructControl te = null;
                    try {
                        world.func_147465_d(x + 8, y - 3, z + 6, ChromaTiles.STRUCTCONTROL.getBlock(), ChromaTiles.STRUCTCONTROL.getBlockMetadata(), 3);
                        te = (TileEntityStructControl)world.func_147438_o(x + 8, y - 3, z + 6);
                        te.generate(s, CrystalElement.WHITE);
                        rx = te.field_145851_c;
                        rz = te.field_145849_e;
                        this.onGenerateStructure(s, s2, world, te);
                    }
                    catch (Exception e) {
                        ((GeneratedStructureBase)s.getStructure()).addError(new Exception("Failed to place controller @ " + (x + 8) + ", " + (y - 3) + ", " + (z + 6), e));
                    }
                    this.modifyBlocks(s, arr, r, Modify.MOSSIFY, Modify.GRASSDIRT, Modify.ADJTREES, Modify.CLEANENTRANCE);
                    this.addMissingSupport(arr, Blocks.field_150348_b, 0, 5);
                    this.addSnowCover(arr, 4);
                    this.programSpawners(s, arr);
                    this.populateChests(s, arr, r);
                    ((GeneratedStructureBase)s.getStructure()).runCallbacks(world, r);
                    flag = true;
                    this.logErrors(world, x, y, z, s, te);
                    break;
                }
                case BIOMEFRAG: {
                    int y = this.getTop(world, x, z) - 5;
                    FilledBlockArray arr = ChromaStructures.BIOMEFRAG.getArray(world, x, y, z, r);
                    arr.sink(world, new Material[]{Material.field_151575_d, Material.field_151584_j, Material.field_151585_k, Material.field_151572_C, Material.field_151586_h, Material.field_151587_i});
                    if (!this.isValidBiomeStructLocation(world, x, y, z, arr)) break;
                    arr.place(2);
                    TileEntityStructControl te = null;
                    try {
                        world.func_147465_d(x, y, z, ChromaTiles.STRUCTCONTROL.getBlock(), ChromaTiles.STRUCTCONTROL.getBlockMetadata(), 3);
                        te = (TileEntityStructControl)world.func_147438_o(x, y, z);
                        te.generate(s, CrystalElement.WHITE);
                        rx = te.field_145851_c;
                        rz = te.field_145849_e;
                        this.onGenerateStructure(s, s2, world, te);
                    }
                    catch (Exception e) {
                        ((GeneratedStructureBase)s.getStructure()).addError(new Exception("Failed to place controller @ " + x + ", " + y + ", " + z, e));
                    }
                    this.modifyBlocks(s, arr, r, Modify.MOSSIFY, Modify.GRASSDIRT, Modify.ADJTREES2, Modify.CLEANENTRANCE);
                    this.populateChests(s, arr, r);
                    ((GeneratedStructureBase)s.getStructure()).runCallbacks(world, r);
                    flag = true;
                    this.logErrors(world, x, y, z, s, te);
                    break;
                }
            }
            if (!flag) continue;
            if (rx != cx || rz != cz) {
                this.markChunkStatus(world, cx >> 4, cz >> 4, s, StructureGenStatus.INERT_GEN);
            }
            return new ChunkCoordIntPair(rx >> 4, rz >> 4);
        }
        this.markChunkStatus(world, cx >> 4, cz >> 4, s, StructureGenStatus.INERT_GEN);
        return null;
    }

    private int getTop(World world, int x, int z) {
        int y = world.func_72825_h(x, z);
        if (ModList.SATISFORESTRY.isLoaded()) {
            y = Math.min(y, SFAPI.biomeHandler.getTrueTopAt(world, x, z));
        }
        Block b = world.func_147439_a(x, y, z);
        while (b.isAir((IBlockAccess)world, x, y, z) || b.isWood((IBlockAccess)world, x, y, z) || b.isLeaves((IBlockAccess)world, x, y, z)) {
            b = world.func_147439_a(x, --y, z);
        }
        return y + 1;
    }

    private void logErrors(World world, int x, int y, int z, ChromaStructures s, TileEntityStructControl te) {
        Collection<Exception> errors = ((GeneratedStructureBase)s.getStructure()).getErrors();
        if (!errors.isEmpty()) {
            long id = world.field_73012_v.nextLong();
            EntityPlayer ep = world.func_72977_a((double)x, (double)y, (double)z, -1.0);
            if (ep != null) {
                ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, (String)("Structure " + (Object)((Object)s) + " encountered " + errors.size() + " errors during generation. Check your log for details. Error ID: " + id));
            }
            ChromatiCraft.logger.logError((Object)("Structure " + (Object)((Object)s) + " encountered " + errors.size() + " errors during generation @ " + x + ", " + y + ", " + z + "; Error ID: " + id));
            int top = this.getTop(world, x, z) - 1;
            ReikaJavaLibrary.pConsole((Object)("Regional metadata: Biome - " + world.func_72807_a(x, z) + "; top block: " + BlockKey.getAt((IBlockAccess)world, (int)x, (int)top, (int)z) + " @ y=" + top + "; block =" + BlockKey.getAt((IBlockAccess)world, (int)x, (int)y, (int)z)));
            ReikaJavaLibrary.pConsole((Object)"Error list:");
            for (Exception e : errors) {
                ReikaJavaLibrary.pConsole((Object)"=======================");
                e.printStackTrace();
                ReikaJavaLibrary.pConsole((Object)"=======================");
            }
        }
    }

    private boolean isValidBiomeForDesertStruct(BiomeGenBase biome) {
        return biome.field_76752_A == Blocks.field_150354_m && BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) && !BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MESA);
    }

    private boolean isValidDesertLocation(World world, int x, int y, int z, FilledBlockArray struct) {
        if (!this.isValidBiomeForDesertStruct(world.func_72807_a(struct.getMinX(), struct.getMinZ()))) {
            return false;
        }
        if (!this.isValidBiomeForDesertStruct(world.func_72807_a(struct.getMaxX(), struct.getMinZ()))) {
            return false;
        }
        if (!this.isValidBiomeForDesertStruct(world.func_72807_a(struct.getMinX(), struct.getMaxZ()))) {
            return false;
        }
        if (!this.isValidBiomeForDesertStruct(world.func_72807_a(struct.getMaxX(), struct.getMaxZ()))) {
            return false;
        }
        if (world.func_147439_a(struct.getMinX(), struct.getMinY() + 3, struct.getMinZ()) == Blocks.field_150350_a) {
            return false;
        }
        if (world.func_147439_a(struct.getMaxX(), struct.getMinY() + 3, struct.getMinZ()) == Blocks.field_150350_a) {
            return false;
        }
        if (world.func_147439_a(struct.getMinX(), struct.getMinY() + 3, struct.getMaxZ()) == Blocks.field_150350_a) {
            return false;
        }
        return world.func_147439_a(struct.getMaxX(), struct.getMinY() + 3, struct.getMaxZ()) != Blocks.field_150350_a;
    }

    private boolean isValidBiomeNear(World world, int x, int z, ChromaStructures s) {
        for (int i = -32; i <= 32; i += 8) {
            for (int k = -32; k <= 32; k += 8) {
                if (!this.isValidBiomeAt(world, x, z, s)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isValidBiomeAt(World world, int x, int z, ChromaStructures s) {
        BiomeGenBase biome = world.func_72959_q().func_76935_a(x, z);
        return this.isValidBiome(s, biome);
    }

    private boolean isValidBiome(ChromaStructures s, BiomeGenBase b) {
        boolean ocean = ReikaBiomeHelper.isOcean((BiomeGenBase)b);
        switch (s) {
            case OCEAN: {
                return ocean;
            }
            case CAVERN: {
                return true;
            }
            case BURROW: {
                return !ocean && b.field_76752_A == Blocks.field_150349_c && !this.isValidBiome(ChromaStructures.SNOWSTRUCT, b) && !ChromatiCraft.isCCBiome(b);
            }
            case DESERT: {
                return !ocean && this.isValidBiomeForDesertStruct(b);
            }
            case SNOWSTRUCT: {
                return b != BiomeGenBase.field_76773_a[BiomeGenBase.field_76774_n.field_76756_M + 128] && !ocean && b.field_76752_A == Blocks.field_150349_c && b.func_76746_c() && ReikaBiomeHelper.getBiomeDecorator((BiomeGenBase)b).field_76832_z < 1 && !b.field_76791_y.toLowerCase(Locale.ENGLISH).contains("forest");
            }
            case BIOMEFRAG: {
                return b != ChromatiCraft.rainbowRiver && ChromatiCraft.isCCBiome(b);
            }
        }
        return false;
    }

    private FilledBlockArray tryGenerateBurrowFurnaceRoom(World world, int x, int y, int z, ChromaStructures s, FilledBlockArray arr, Random r) {
        FilledBlockArray arr2 = ((BurrowStructure)s.getStructure()).getFurnaceRoom(world, x, y, z);
        for (Coordinate c : arr2.keySet()) {
            if (!c.isEmpty((IBlockAccess)world)) continue;
            return null;
        }
        arr2.place();
        return arr2;
    }

    private FilledBlockArray tryGenerateBurrowLootRoom(World world, int x, int y, int z, ChromaStructures s, FilledBlockArray arr, Random r) {
        FilledBlockArray arr2 = ((BurrowStructure)s.getStructure()).getLootRoom(world, x, y, z);
        for (Coordinate c : arr2.keySet()) {
            if (!c.isEmpty((IBlockAccess)world)) continue;
            return null;
        }
        arr2.place();
        return arr2;
    }

    private static FilledBlockArray getPitSlice(World world, int x, int y, int z) {
        FilledBlockArray array = new FilledBlockArray(world);
        Block b = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
        array.setBlock((x -= 3) + 1, y + 0, (z -= 3) + 1, b, 8);
        array.setBlock(x + 1, y + 0, z + 2, b, 8);
        array.setBlock(x + 1, y + 0, z + 3, b, 8);
        array.setBlock(x + 1, y + 0, z + 4, b, 8);
        array.setBlock(x + 1, y + 0, z + 5, b, 8);
        array.setBlock(x + 2, y + 0, z + 1, b, 8);
        array.setBlock(x + 2, y + 0, z + 5, b, 8);
        array.setBlock(x + 3, y + 0, z + 1, b, 8);
        array.setBlock(x + 3, y + 0, z + 5, b, 8);
        array.setBlock(x + 5, y + 0, z + 1, b, 8);
        array.setBlock(x + 5, y + 0, z + 2, b, 8);
        array.setBlock(x + 5, y + 0, z + 3, b, 8);
        array.setBlock(x + 5, y + 0, z + 4, b, 8);
        array.setBlock(x + 5, y + 0, z + 5, b, 8);
        array.setBlock(x + 4, y + 0, z + 1, b, 8);
        array.setBlock(x + 4, y + 0, z + 5, b, 8);
        array.setBlock(x + 2, y + 0, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 0, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 0, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 0, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 0, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 0, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 0, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 0, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 0, z + 4, Blocks.field_150350_a);
        return array;
    }

    private static FilledBlockArray getEndcap1(World world, int x, int y, int z) {
        FilledBlockArray array = new FilledBlockArray(world);
        Block b = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
        array.setBlock((x -= 3) + 30, y + 8, (z -= 3) + 2, Blocks.field_150350_a);
        array.setBlock(x + 30, y + 8, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 30, y + 8, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 30, y + 9, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 30, y + 9, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 30, y + 9, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 30, y + 10, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 30, y + 10, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 30, y + 10, z + 4, Blocks.field_150350_a);
        return array;
    }

    private static FilledBlockArray getEndcap2(World world, int x, int y, int z) {
        FilledBlockArray array = new FilledBlockArray(world);
        Block b = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
        array.setBlock((x -= 3) + 2, y + 8, (z -= 3) + 30, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 9, z + 30, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 10, z + 30, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 8, z + 30, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 9, z + 30, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 10, z + 30, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 8, z + 30, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 9, z + 30, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 10, z + 30, Blocks.field_150350_a);
        return array;
    }

    private void generatePit(World world, int x, int y, int z) {
        for (int i = 3; i < 32; ++i) {
            FilledBlockArray arr = DungeonGenerator.getPitSlice(world, x, y - i, z);
            boolean flag = true;
            for (int k = 0; k < arr.getSize(); ++k) {
                Coordinate c = arr.getNthBlock(k);
                Block b = c.getBlock((IBlockAccess)world);
                if (b == Blocks.field_150350_a) continue;
                flag = false;
            }
            if (flag && i > 6) break;
            arr.place();
        }
        BlockArray arr = OceanStructure.getPitCover(x, y, z);
        for (int k = 0; k < arr.getSize(); ++k) {
            Coordinate c = arr.getNthBlock(k);
            Block b = c.getBlock((IBlockAccess)world);
            c.setBlock(world, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.metadata);
        }
    }

    public void modifyBlocks(ChromaStructures s, FilledBlockArray arr, Random r, Modify ... flags) {
        for (Modify m : flags) {
            try {
                m.apply(s, arr, r);
            }
            catch (Exception e) {
                ((GeneratedStructureBase)s.getStructure()).addError(new Exception("Failed to run pass '" + (Object)((Object)m) + "'", e));
            }
        }
        for (int k = 0; k < arr.getSize(); ++k) {
            Coordinate c = arr.getNthBlock(k);
            for (Modify m : flags) {
                try {
                    m.applyEach(s, arr, c, r);
                }
                catch (Exception e) {
                    ((GeneratedStructureBase)s.getStructure()).addError(new Exception("Failed to run localized pass '" + (Object)((Object)m) + "' @ " + c, e));
                }
            }
        }
    }

    public void programSpawners(ChromaStructures s, FilledBlockArray arr) {
        switch (s) {
            case OCEAN: {
                for (Coordinate c : ((GeneratedStructureBase)s.getStructure()).getCachedBlocks(Blocks.field_150474_ac)) {
                    Block b = c.getBlock((IBlockAccess)arr.world);
                    if (b != Blocks.field_150474_ac) continue;
                    TileEntityMobSpawner te = (TileEntityMobSpawner)arr.world.func_147438_o(c.xCoord, c.yCoord, c.zCoord);
                    te.func_145881_a().field_98289_l = 8;
                    te.func_145881_a().field_98292_k = 16;
                    te.func_145881_a().field_98293_h = 400;
                    ReikaSpawnerHelper.setMobSpawnerMob((TileEntityMobSpawner)te, (String)((String)EntityList.field_75626_c.get(EntityCreeper.class)));
                }
                break;
            }
            case DESERT: {
                for (Coordinate c : ((GeneratedStructureBase)s.getStructure()).getCachedBlocks(Blocks.field_150474_ac)) {
                    Block b = c.getBlock((IBlockAccess)arr.world);
                    if (b != Blocks.field_150474_ac) continue;
                    TileEntityMobSpawner te = (TileEntityMobSpawner)arr.world.func_147438_o(c.xCoord, c.yCoord, c.zCoord);
                    Class mob = c.yCoord <= arr.getMinY() + 4 ? EntityBlaze.class : (Math.abs(c.xCoord - arr.getMinX()) == Math.abs(c.zCoord - arr.getMinZ()) ? EntitySpider.class : EntitySilverfish.class);
                    ReikaSpawnerHelper.setMobSpawnerMob((TileEntityMobSpawner)te, (String)((String)EntityList.field_75626_c.get(mob)));
                    te.func_145881_a().field_98289_l = 4;
                    te.func_145881_a().field_98286_b = 0;
                    if (mob != EntityBlaze.class) continue;
                    te.func_145881_a().field_98293_h = 100;
                    te.func_145881_a().field_98283_g = 40;
                }
                break;
            }
            case SNOWSTRUCT: {
                for (Coordinate c : ((GeneratedStructureBase)s.getStructure()).getCachedBlocks(Blocks.field_150474_ac)) {
                    Block b = c.getBlock((IBlockAccess)arr.world);
                    if (b != Blocks.field_150474_ac) continue;
                    TileEntityMobSpawner te = (TileEntityMobSpawner)arr.world.func_147438_o(c.xCoord, c.yCoord, c.zCoord);
                    ReikaSpawnerHelper.setMobSpawnerMob((TileEntityMobSpawner)te, (String)((String)EntityList.field_75626_c.get(EntityWolf.class)));
                    te.func_145881_a().field_98289_l = 30;
                    te.func_145881_a().field_98286_b = 0;
                    te.func_145881_a().field_98292_k = 8;
                }
                break;
            }
        }
    }

    public void populateChests(ChromaStructures struct, FilledBlockArray arr, Random r) {
        try {
            for (Coordinate c : ((GeneratedStructureBase)struct.getStructure()).getCachedBlocks(GeneratedStructureBase.getChestGen())) {
                Block b = c.getBlock((IBlockAccess)arr.world);
                if (b != ChromaStructureBase.getChestGen()) continue;
                BlockLootChest.TileEntityLootChest te = (BlockLootChest.TileEntityLootChest)c.getTileEntity((IBlockAccess)arr.world);
                if (te.isUntouchedWorldgen()) {
                    int bonus = ((FragmentStructureBase)struct.getStructure()).getChestYield(c, te, arr, r);
                    this.populateChest(c, te, struct, arr, bonus, r);
                    continue;
                }
                ChromatiCraft.logger.logError((Object)("Structure " + (Object)((Object)struct) + " gen in chest " + (Object)((Object)te) + " @ " + c + " failed because is not untouched worldgen."));
            }
        }
        catch (Exception e) {
            ((GeneratedStructureBase)struct.getStructure()).addError(new Exception("Failed to populate chests", e));
        }
    }

    public void populateChest(Coordinate c, BlockLootChest.TileEntityLootChest te, ChromaStructures struct, FilledBlockArray arr, int bonus, Random r) {
        String s = ((FragmentStructureBase)struct.getStructure()).getChestLootTable(c, te, arr, r);
        if (s == null) {
            return;
        }
        te.populateChest(s, struct, bonus, r);
    }

    private void addMissingSupport(FilledBlockArray arr, Block b, int meta, int d) {
        for (int x = arr.getMinX(); x <= arr.getMaxX(); ++x) {
            for (int z = arr.getMinZ(); z <= arr.getMaxZ(); ++z) {
                int bottom = arr.getBottomBlockAtXZ(x, z);
                if (bottom == Integer.MAX_VALUE) continue;
                --bottom;
                for (int i = 1; i <= d; ++i) {
                    int y = bottom - i;
                    if (!ReikaWorldHelper.softBlocks((IBlockAccess)arr.world, (int)x, (int)y, (int)z)) continue;
                    arr.world.func_147465_d(x, y, z, b, meta, 2);
                }
            }
        }
    }

    private void addSnowCover(FilledBlockArray arr, int r) {
        for (int x = arr.getMinX() - r; x <= arr.getMaxX() + r; ++x) {
            for (int z = arr.getMinZ() - r; z <= arr.getMaxZ() + r; ++z) {
                int top = this.getTop(arr.world, x, z) - 1;
                if (arr.world.func_147439_a(x, top, z) == Blocks.field_150431_aC || arr.world.func_147439_a(x, top + 1, z) != Blocks.field_150350_a) continue;
                arr.world.func_147449_b(x, top + 1, z, Blocks.field_150431_aC);
            }
        }
    }

    private boolean isValidCavernLocation(World world, int x, int y, int z, FilledBlockArray arr) {
        boolean flag = false;
        for (int i = 6; i < 18; ++i) {
            int dx = x + i;
            Block b = world.func_147439_a(dx, y, z);
            Block b2 = world.func_147439_a(dx, y - 1, z);
            if (!b.isAir((IBlockAccess)world, dx, y, z) || !b2.isAir((IBlockAccess)world, dx, y - 1, z)) continue;
            flag = true;
            break;
        }
        if (flag) {
            for (int k = 0; k < arr.getSize(); ++k) {
                Coordinate c = arr.getNthBlock(k);
                Coordinate c2 = c.offset(0, 1, 0);
                Block b = c.getBlock((IBlockAccess)world);
                Block b2 = c2.getBlock((IBlockAccess)world);
                if (b.isAir((IBlockAccess)world, c.xCoord, c.yCoord, c.zCoord) || ReikaBlockHelper.isLiquid((Block)b)) {
                    return false;
                }
                if (!b.isAir((IBlockAccess)world, c2.xCoord, c2.yCoord, c2.zCoord) && !ReikaBlockHelper.isLiquid((Block)b2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isValidBurrowLocation(World world, int x, int y, int z, FilledBlockArray arr) {
        int k;
        if (world.func_147439_a(x, y, z) != Blocks.field_150349_c) {
            return false;
        }
        for (int i = 1; i <= 8; ++i) {
            for (k = -3; k <= 1; ++k) {
                Block b = world.func_147439_a(x, y + i, z + k);
                if (ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)x, (int)(y + i), (int)(z + k))) continue;
                return false;
            }
        }
        int r = 1;
        for (int i = -r; i <= r; ++i) {
            for (int j = -r; j <= r; ++j) {
                for (int k2 = -r; k2 <= r; ++k2) {
                    Block b = world.func_147439_a(x + i, y + j, z + k2);
                    if (!(b instanceof BlockLiquid) && !(b instanceof BlockFluidBase)) continue;
                    return false;
                }
            }
        }
        for (k = 0; k < arr.getSize(); ++k) {
            Coordinate c = arr.getNthBlock(k);
            int dx = c.xCoord;
            int dy = c.yCoord;
            int dz = c.zCoord;
            Block b = world.func_147439_a(dx, dy, dz);
            if (b == ChromaBlocks.CLIFFSTONE.getBlockInstance()) {
                return false;
            }
            if (this.getTop(world, dx, dz) < y - 2) {
                return false;
            }
            if (!arr.hasBlockAt(dx, dy, dz, Blocks.field_150348_b) && !arr.hasBlockAt(dx, dy, dz, ChromaBlocks.STRUCTSHIELD.getBlockInstance()) || !b.isAir((IBlockAccess)world, dx, dy, dz) && ReikaWorldHelper.checkForAdjMaterial((World)world, (int)dx, (int)dy, (int)dz, (Material)Material.field_151579_a) == null) continue;
            return false;
        }
        return true;
    }

    private boolean isValidOceanLocation(World world, int x, int y, int z, FilledBlockArray struct) {
        Block b;
        Coordinate c;
        int k;
        if (world.func_147439_a(x, y + 8, z) != Blocks.field_150355_j && world.func_147439_a(x, y + 8, z) != Blocks.field_150358_i) {
            ChromatiCraft.logger.debug((Object)("Ocean Temple generation @ " + x + ", " + y + ", " + z + " failed: Not deep enough"));
            return false;
        }
        boolean flag1 = true;
        boolean flag2 = true;
        FilledBlockArray cap = (FilledBlockArray)DungeonGenerator.getEndcap1(world, x, y, z).offset(1, 0, 0);
        for (k = 0; k < cap.getSize(); ++k) {
            c = cap.getNthBlock(k);
            b = c.getBlock((IBlockAccess)world);
            if (b == Blocks.field_150355_j || b == Blocks.field_150358_i) continue;
            flag1 = false;
        }
        cap = (FilledBlockArray)DungeonGenerator.getEndcap2(world, x, y, z).offset(0, 0, 1);
        for (k = 0; k < cap.getSize(); ++k) {
            c = cap.getNthBlock(k);
            b = c.getBlock((IBlockAccess)world);
            if (b == Blocks.field_150355_j || b == Blocks.field_150358_i) continue;
            flag2 = false;
        }
        if (!flag1 && !flag2) {
            ChromatiCraft.logger.debug((Object)("Ocean Temple generation @ " + x + ", " + y + ", " + z + " failed: Blocked ends"));
            return false;
        }
        for (k = 0; k < struct.getSize(); ++k) {
            c = struct.getNthBlock(k);
            b = c.getBlock((IBlockAccess)world);
            if (b == ChromaBlocks.STRUCTSHIELD.getBlockInstance()) {
                ChromatiCraft.logger.debug((Object)("Ocean Temple generation @ " + x + ", " + y + ", " + z + " failed: Intersects other structure"));
                return false;
            }
            if (c.yCoord >= 55 && c.getBlock((IBlockAccess)world).isAir((IBlockAccess)world, x, y, z)) {
                ChromatiCraft.logger.debug((Object)("Ocean Temple generation @ " + x + ", " + y + ", " + z + " failed: Extends out of water"));
                return false;
            }
            if (ReikaBiomeHelper.isOcean((BiomeGenBase)c.getBiome(world))) continue;
            ChromatiCraft.logger.debug((Object)("Ocean Temple generation @ " + x + ", " + y + ", " + z + " failed: Bounds outside ocean"));
            return false;
        }
        int consec = 0;
        for (int i = 3; i < y; ++i) {
            FilledBlockArray slice = DungeonGenerator.getPitSlice(world, x, y - i, z);
            boolean flag = true;
            for (int k2 = 0; k2 < slice.getSize(); ++k2) {
                Coordinate c2 = slice.getNthBlock(k2);
                Block b2 = c2.getBlock((IBlockAccess)world);
                if (b2 == Blocks.field_150350_a) continue;
                flag = false;
            }
            if (flag && i > 6) {
                if (++consec < 3) continue;
                return true;
            }
            consec = 0;
        }
        ChromatiCraft.logger.debug((Object)("Ocean Temple generation @ " + x + ", " + y + ", " + z + " failed: No cave."));
        return false;
    }

    private boolean isValidSnowStructLocation(World world, int x, int y, int z, FilledBlockArray arr) {
        int min;
        int h4;
        int h3;
        int h2;
        int h1 = this.getTop(world, arr.getMinX(), arr.getMinZ());
        int max = ReikaMathLibrary.multiMax((int[])new int[]{h1, h2 = this.getTop(world, arr.getMaxX(), arr.getMinZ()), h3 = this.getTop(world, arr.getMinX(), arr.getMaxZ()), h4 = this.getTop(world, arr.getMaxX(), arr.getMaxZ())});
        if (Math.abs(max - (min = ReikaMathLibrary.multiMin((int[])new int[]{h1, h2, h3, h4}))) > 2) {
            return false;
        }
        BiomeGenBase b1 = world.func_72807_a(arr.getMinX(), arr.getMinZ());
        BiomeGenBase b2 = world.func_72807_a(arr.getMaxX(), arr.getMinZ());
        BiomeGenBase b3 = world.func_72807_a(arr.getMinX(), arr.getMaxZ());
        BiomeGenBase b4 = world.func_72807_a(arr.getMaxX(), arr.getMaxZ());
        if (b1 != b2 || b1 != b3 || b1 != b4) {
            return false;
        }
        for (int d = 1; d <= 5; ++d) {
            Block id1 = world.func_147439_a(arr.getMinX(), h1 - d, arr.getMinZ());
            Block id2 = world.func_147439_a(arr.getMaxX(), h2 - d, arr.getMinZ());
            Block id3 = world.func_147439_a(arr.getMinX(), h3 - d, arr.getMaxZ());
            Block id4 = world.func_147439_a(arr.getMaxX(), h4 - d, arr.getMaxZ());
            if (id1 == Blocks.field_150350_a || id2 == Blocks.field_150350_a || id3 == Blocks.field_150350_a || id4 == Blocks.field_150350_a) {
                return false;
            }
            if (!ReikaBlockHelper.isLiquid((Block)id1) && !ReikaBlockHelper.isLiquid((Block)id2) && !ReikaBlockHelper.isLiquid((Block)id3) && !ReikaBlockHelper.isLiquid((Block)id4)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidBiomeStructLocation(World world, int x, int y, int z, FilledBlockArray arr) {
        int min;
        int h4;
        int h3;
        int h2;
        if (BiomeGlowingCliffs.isGlowingCliffs(world.func_72807_a(x, z)) && y > 114) {
            return false;
        }
        int h1 = this.getTop(world, arr.getMinX(), arr.getMinZ());
        int max = ReikaMathLibrary.multiMax((int[])new int[]{h1, h2 = this.getTop(world, arr.getMaxX(), arr.getMinZ()), h3 = this.getTop(world, arr.getMinX(), arr.getMaxZ()), h4 = this.getTop(world, arr.getMaxX(), arr.getMaxZ())});
        if (Math.abs(max - (min = ReikaMathLibrary.multiMin((int[])new int[]{h1, h2, h3, h4}))) > 2) {
            return false;
        }
        BiomeGenBase b1 = world.func_72807_a(arr.getMinX(), arr.getMinZ());
        BiomeGenBase b2 = world.func_72807_a(arr.getMaxX(), arr.getMinZ());
        BiomeGenBase b3 = world.func_72807_a(arr.getMinX(), arr.getMaxZ());
        BiomeGenBase b4 = world.func_72807_a(arr.getMaxX(), arr.getMaxZ());
        if (b1 != b2 || b1 != b3 || b1 != b4) {
            return false;
        }
        for (int d = 1; d <= 4; ++d) {
            Block id1 = world.func_147439_a(arr.getMinX(), h1 - d, arr.getMinZ());
            Block id2 = world.func_147439_a(arr.getMaxX(), h2 - d, arr.getMinZ());
            Block id3 = world.func_147439_a(arr.getMinX(), h3 - d, arr.getMaxZ());
            Block id4 = world.func_147439_a(arr.getMaxX(), h4 - d, arr.getMaxZ());
            if (id1 == Blocks.field_150350_a || id2 == Blocks.field_150350_a || id3 == Blocks.field_150350_a || id4 == Blocks.field_150350_a) {
                return false;
            }
            if (!ReikaBlockHelper.isLiquid((Block)id1) && !ReikaBlockHelper.isLiquid((Block)id2) && !ReikaBlockHelper.isLiquid((Block)id3) && !ReikaBlockHelper.isLiquid((Block)id4)) continue;
            return false;
        }
        return true;
    }

    private boolean isVoidWorld(World world, int x, int z) {
        return world.func_147439_a(x, 0, z) == Blocks.field_150350_a || world.func_72937_j(x, 1, z);
    }

    public StructureGenStatus isGennableChunk(World world, int x, int z, ChromaStructures s) {
        this.updateNoisemaps(world);
        ArrayList<WorldLocation> c = new ArrayList<WorldLocation>(this.getNearbyZones(s, (WorldServer)world, x, z, this.getExclusionZone(s)));
        if (c.isEmpty()) {
            return StructureGenStatus.INERT;
        }
        StructureGenStatus failret = StructureGenStatus.INERT;
        Iterator<WorldLocation> it = c.iterator();
        while (it.hasNext()) {
            WorldLocation loc = it.next();
            if (this.isValidBiomeNear(world, loc.xCoord, loc.zCoord, s)) continue;
            it.remove();
            if (x >> 4 != loc.xCoord >> 4 || z >> 4 != loc.zCoord >> 4) continue;
            failret = StructureGenStatus.BIOMEFAIL;
        }
        if (c.isEmpty()) {
            return failret;
        }
        WorldLocation usable = null;
        if (c.size() == 1) {
            usable = c.get(0);
        } else {
            usable = this.getBestFromCluster(c);
            for (WorldLocation loc : c) {
                if (usable.equals((Object)loc)) continue;
                this.markChunkStatus(world, loc.xCoord >> 4, loc.zCoord >> 4, s, StructureGenStatus.CLUSTERED);
            }
        }
        return x >> 4 == usable.xCoord >> 4 && z >> 4 == usable.zCoord >> 4 ? StructureGenStatus.PLANNED : StructureGenStatus.INERT;
    }

    private WorldLocation getBestFromCluster(ArrayList<WorldLocation> c) {
        Collections.sort(c);
        return c.get(0);
    }

    private boolean canGenerateIn(World world) {
        if (ModList.MYSTCRAFT.isLoaded() && ReikaMystcraftHelper.isMystAge((World)world) && !MystPages.Pages.STRUCTURES.existsInWorld(world)) {
            return false;
        }
        if (world.func_72912_H().func_76067_t() == WorldType.field_77138_c) {
            return ChromaOptions.FLATGEN.getState() && ReikaWorldHelper.getSuperflatHeight((World)world) > 15;
        }
        if (world.field_73011_w.field_76574_g == 0) {
            return true;
        }
        if (world.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue()) {
            return false;
        }
        if (Math.abs(world.field_73011_w.field_76574_g) == 1) {
            return false;
        }
        if (world.field_73011_w.field_76574_g == ExtraUtilsHandler.getInstance().darkID) {
            return false;
        }
        if (world.field_73011_w.field_76574_g == TwilightForestHandler.getInstance().dimensionID) {
            return false;
        }
        if (world.field_73011_w.getClass().getName().equals("WorldProviderMiner")) {
            return false;
        }
        if (PlanetDimensionHandler.isOtherWorld((World)world)) {
            return false;
        }
        return !ChromatiCraft.config.isDimensionBlacklistedForStructures(world.field_73011_w.field_76574_g);
    }

    public boolean canGenerateAt(World world, int chunkX, int chunkZ) {
        return true;
    }

    public String getIDString() {
        return "ChromatiCraft Prefab Structures";
    }

    public static class StructureSeekData {
        public final WorldLocation location;
        public final boolean isKnownSuccess;

        private StructureSeekData(WorldLocation loc, boolean b) {
            this.location = loc;
            this.isKnownSuccess = b;
        }
    }

    private static class StructureGenData {
        private StructureGenStatus status;
        private final WorldChunk rootLocation;
        private Coordinate generatedLocation;

        private StructureGenData(WorldChunk wc, StructureGenStatus def) {
            this.status = def;
            this.rootLocation = wc;
        }

        public static StructureGenData readFromNBT(NBTTagCompound tag) {
            StructureGenStatus stat = StructureGenStatus.valueOf(tag.func_74779_i("status"));
            StructureGenData ret = new StructureGenData(WorldChunk.fromSerialString((String)tag.func_74779_i("chunk")), stat);
            if (tag.func_74764_b("location")) {
                ret.generatedLocation = Coordinate.readFromNBT((String)"location", (NBTTagCompound)tag);
            }
            return ret;
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound ret = new NBTTagCompound();
            ret.func_74778_a("status", this.status.name());
            ret.func_74778_a("chunk", this.rootLocation.toSerialString());
            if (this.generatedLocation != null) {
                this.generatedLocation.writeToNBT("location", ret);
            }
            return ret;
        }
    }

    public static enum StructureGenStatus {
        INERT(0),
        INERT_GEN(0x303030),
        BIOMEFAIL(16748576),
        PLANNED(0xFFFFFF),
        GENERATING(0x22AAFF),
        SUCCESS(65280),
        FAILURE(0xFF0000),
        CLUSTERED(0xFF00FF),
        REMOVED(0xFFFF00);

        public static final StructureGenStatus[] list;
        public final int renderColor;

        private StructureGenStatus(int c) {
            this.renderColor = c;
        }

        public boolean hasStructure() {
            return this == SUCCESS || this == PLANNED || this == GENERATING;
        }

        public boolean isGenerated() {
            return this == SUCCESS || this == FAILURE || this == REMOVED || this == INERT_GEN;
        }

        public boolean isFinalized() {
            return this.isGenerated() || this == CLUSTERED || this == BIOMEFAIL;
        }

        public boolean canOverwrite(StructureGenStatus g) {
            if (this == INERT_GEN && g == PLANNED) {
                return false;
            }
            return this.isFinalized() && !g.isFinalized();
        }

        static {
            list = StructureGenStatus.values();
        }
    }

    public static enum Modify {
        MOSSIFY,
        GRASSDIRT,
        ADJTREES,
        ADJTREES2,
        CLEANENTRANCE,
        ENCRUSTED;

        private final int bit = 1 << this.ordinal();

        private static int getFlags(Modify ... flags) {
            int ret = 0;
            for (Modify m : flags) {
                ret |= m.bit;
            }
            return ret;
        }

        private void apply(ChromaStructures s, FilledBlockArray arr, Random r) {
            switch (this) {
                case ADJTREES: {
                    break;
                }
                case ADJTREES2: {
                    for (int x = arr.getMinX() - 1; x <= arr.getMaxX() + 1; ++x) {
                        for (int z = arr.getMinZ() - 1; z <= arr.getMaxZ() + 1; ++z) {
                            boolean walls = x >= arr.getMinX() && x <= arr.getMaxX() && z >= arr.getMinZ() && z <= arr.getMaxZ();
                            for (int y = arr.getMinY(); y <= arr.getMaxY() + 2; ++y) {
                                if (!ReikaBlockHelper.isWood((IBlockAccess)arr.world, (int)x, (int)y, (int)z) && (!walls || !ReikaBlockHelper.isLeaf((IBlockAccess)arr.world, (int)x, (int)y, (int)z))) continue;
                                arr.world.func_147468_f(x, y, z);
                            }
                        }
                    }
                    break;
                }
                case CLEANENTRANCE: {
                    if (s != ChromaStructures.BIOMEFRAG) break;
                    for (int dx = arr.getMinX() - 2; dx <= arr.getMaxX() + 2; ++dx) {
                        block11: for (int dz = arr.getMinZ() - 2; dz <= arr.getMaxZ() + 2; ++dz) {
                            if (dx >= arr.getMinX() && dx <= arr.getMaxX() && dz >= arr.getMinZ() && dz <= arr.getMaxZ()) continue;
                            int ymin = arr.getMaxY() - 3;
                            if (dx >= arr.getMinX() - 1 && dx <= arr.getMaxX() + 1 && dz >= arr.getMinZ() - 1 && dz <= arr.getMaxZ() + 1) {
                                ymin -= 2;
                            }
                            int y0 = arr.getMaxY();
                            Block b0 = arr.world.func_147439_a(dx, y0, dz);
                            Block b = arr.world.func_147439_a(dx, y0 + 1, dz);
                            if (b.isWood((IBlockAccess)arr.world, dx, y0 + 1, dz) || b.isLeaves((IBlockAccess)arr.world, dx, y0 + 1, dz) || b0.isWood((IBlockAccess)arr.world, dx, y0, dz) || b0.isLeaves((IBlockAccess)arr.world, dx, y0, dz)) continue;
                            for (int dy = y0; dy >= ymin; --dy) {
                                b = arr.world.func_147439_a(dx, dy, dz);
                                if (!ReikaWorldHelper.softBlocks((IBlockAccess)arr.world, (int)dx, (int)dy, (int)dz) && b != Blocks.field_150346_d && b != Blocks.field_150349_c && b.func_149688_o() != Material.field_151578_c) continue block11;
                                arr.world.func_147449_b(dx, dy, dz, Blocks.field_150350_a);
                                if (ReikaWorldHelper.softBlocks((IBlockAccess)arr.world, (int)dx, (int)(dy - 1), (int)dz)) continue;
                                arr.world.func_147449_b(dx, dy - 1, dz, (Block)Blocks.field_150349_c);
                            }
                        }
                    }
                    break;
                }
                case ENCRUSTED: {
                    break;
                }
                case GRASSDIRT: {
                    break;
                }
            }
        }

        private boolean applyEach(ChromaStructures s, FilledBlockArray arr, Coordinate c, Random r) {
            switch (this) {
                case ADJTREES: {
                    for (int i = 0; i < 6; ++i) {
                        Coordinate c2 = c.offset(ForgeDirection.VALID_DIRECTIONS[i], 1);
                        Block b = c2.getBlock((IBlockAccess)arr.world);
                        if (b == Blocks.field_150350_a || b == ChromaBlocks.STRUCTSHIELD.getBlockInstance()) continue;
                        int meta = c2.getBlockMetadata((IBlockAccess)arr.world);
                        ReikaTreeHelper tree = ReikaTreeHelper.getTree((Block)b, (int)meta);
                        if (tree == null) {
                            tree = ModWoodList.getModWood((Block)b, (int)meta);
                        }
                        if (tree == null) continue;
                        BlockArray barr = new BlockArray();
                        barr.recursiveMultiAddWithBounds((IBlockAccess)arr.world, c2.xCoord, c2.yCoord, c2.zCoord, c2.xCoord - 12, c2.yCoord - 12, c2.zCoord - 12, c2.xCoord + 12, c2.yCoord + 12, c2.zCoord + 12, new Block[]{b, tree.getLeafID()});
                        for (Coordinate c3 : barr.keySet()) {
                            c3.setBlock(arr.world, Blocks.field_150350_a);
                        }
                        return true;
                    }
                    break;
                }
                case ADJTREES2: {
                    break;
                }
                case CLEANENTRANCE: {
                    Block b3;
                    Block b;
                    if (s != ChromaStructures.SNOWSTRUCT || (b = c.getBlock((IBlockAccess)arr.world)) != ChromaBlocks.STRUCTSHIELD.getBlockInstance() || c.getBlockMetadata((IBlockAccess)arr.world) != BlockStructureShield.BlockType.MOSS.metadata || (b3 = c.offset(0, 1, 0).getBlock((IBlockAccess)arr.world)) == b) break;
                    for (int i = 1; i < 5; ++i) {
                        for (int dx = -i; dx <= i; ++dx) {
                            for (int dz = -i; dz <= i; ++dz) {
                                Coordinate c2 = c.offset(dx, i, dz);
                                Block b2 = c2.getBlock((IBlockAccess)arr.world);
                                if (b2 != Blocks.field_150349_c && b2.func_149688_o() != Material.field_151578_c && b2.func_149688_o() != Material.field_151585_k && b2 != Blocks.field_150348_b && b2 != Blocks.field_150431_aC) continue;
                                c2.setBlock(arr.world, Blocks.field_150350_a);
                            }
                        }
                    }
                    return true;
                }
                case GRASSDIRT: {
                    Block b = c.getBlock((IBlockAccess)arr.world);
                    if (b != Blocks.field_150346_d || arr.world.func_72957_l(c.xCoord, c.yCoord + 1, c.zCoord) <= 8) break;
                    c.setBlock(arr.world, (Block)Blocks.field_150349_c);
                    return true;
                }
                case MOSSIFY: {
                    int dc;
                    int dh;
                    int dy;
                    int ct;
                    int meta;
                    Block b = c.getBlock((IBlockAccess)arr.world);
                    if (b != ChromaBlocks.STRUCTSHIELD.getBlockInstance() || (meta = c.getBlockMetadata((IBlockAccess)arr.world)) != BlockStructureShield.BlockType.STONE.metadata || r.nextInt(ct = Math.max(1, (dy = c.yCoord - arr.getMinY()) * (dh = s == ChromaStructures.BURROW ? 1 : 2) - 2 + (dc = s == ChromaStructures.BURROW ? 5 : 0))) != 0) break;
                    arr.world.func_72921_c(c.xCoord, c.yCoord, c.zCoord, BlockStructureShield.BlockType.MOSS.metadata, 2);
                    return true;
                }
                case ENCRUSTED: {
                    Block b;
                    int n;
                    int n2 = n = s == ChromaStructures.BURROW ? 12 : 20;
                    if (r.nextInt(n) != 0 || (b = c.getBlock((IBlockAccess)arr.world)) != ChromaBlocks.STRUCTSHIELD.getBlockInstance()) break;
                    for (int i = 0; i < 6; ++i) {
                        Coordinate c2 = c.offset(ForgeDirection.VALID_DIRECTIONS[i], 1);
                        Block b2 = c2.getBlock((IBlockAccess)arr.world);
                        if (b2 != Blocks.field_150350_a) continue;
                    }
                    break;
                }
            }
            return false;
        }
    }
}

