/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.IWG;

import Reika.ChromatiCraft.Block.Worldgen.BlockCliffStone;
import Reika.ChromatiCraft.Block.Worldgen.BlockDecoFlower;
import Reika.ChromatiCraft.Block.Worldgen.BlockTieredPlant;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.BiomeGlowingCliffs;
import Reika.ChromatiCraft.World.GlowingCliffsDecorator;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Instantiable.Math.LobulatedCurve;
import Reika.DragonAPI.Instantiable.Math.Noise.NoiseGeneratorBase;
import Reika.DragonAPI.Instantiable.Math.Noise.Simplex3DGenerator;
import Reika.DragonAPI.Instantiable.Math.Noise.SimplexNoiseGenerator;
import Reika.DragonAPI.Instantiable.Worldgen.ControllableOreVein;
import Reika.DragonAPI.Interfaces.Registry.OreType;
import Reika.DragonAPI.Interfaces.Registry.TreeType;
import Reika.DragonAPI.Interfaces.RetroactiveGenerator;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaOreHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaTreeHelper;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import Reika.DragonAPI.Libraries.World.ReikaChunkHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.MystCraftHandler;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModOreList;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class GlowingCliffsAuxGenerator
implements RetroactiveGenerator {
    public static final GlowingCliffsAuxGenerator instance = new GlowingCliffsAuxGenerator();
    private static final int MAX_CONTOUR_HEIGHT = 6;
    private static final int SCALE_RANGE = 2;
    private static final BlockKey STONE = new BlockKey(ChromaBlocks.CLIFFSTONE.getBlockInstance(), BlockCliffStone.Variants.STONE.getMeta(false, true));
    private static final BlockKey DIRT = new BlockKey(Blocks.field_150346_d);
    private static final BlockKey GRASS = new BlockKey((Block)Blocks.field_150349_c);
    private NoiseGeneratorBase contours;
    private NoiseGeneratorBase islandFrequency;
    private NoiseGeneratorBase crystalNoise;
    private long noiseSeed;
    private final WeightedRandom<TreeType> treeRand = new WeightedRandom();
    public final WeightedRandom<OreType> oreRand = new WeightedRandom();
    public static final HashMap<Coordinate, ImmutablePair<Integer, Integer>> TEMP_ISLAND_CACHE = new HashMap();

    private GlowingCliffsAuxGenerator() {
    }

    public void initialize() {
        this.treeRand.addEntry((Object)ReikaTreeHelper.OAK, 100.0);
        this.treeRand.addEntry((Object)ReikaTreeHelper.BIRCH, 20.0);
        if (ModWoodList.GREATWOOD.exists()) {
            this.treeRand.addEntry((Object)ModWoodList.GREATWOOD, 10.0);
        }
        if (ModWoodList.SILVERWOOD.exists()) {
            this.treeRand.addEntry((Object)ModWoodList.SILVERWOOD, 4.0);
        }
        if (ModWoodList.LOFTWOOD.exists()) {
            this.treeRand.addEntry((Object)ModWoodList.LOFTWOOD, 8.0);
        }
        if (ModWoodList.SAKURA.exists()) {
            this.treeRand.addEntry((Object)ModWoodList.SAKURA, 10.0);
        }
        this.oreRand.addEntry((Object)ReikaOreHelper.DIAMOND, 20.0);
        this.oreRand.addEntry((Object)ReikaOreHelper.EMERALD, 10.0);
        this.oreRand.addEntry((Object)ReikaOreHelper.REDSTONE, 40.0);
        this.oreRand.addEntry((Object)ReikaOreHelper.GOLD, 30.0);
        if (ModOreList.AMBER.existsInGame()) {
            this.oreRand.addEntry((Object)ModOreList.AMBER, 30.0);
        }
        if (ModOreList.AMETHYST.existsInGame()) {
            this.oreRand.addEntry((Object)ModOreList.AMETHYST, 10.0);
        }
        if (ModOreList.IRIDIUM.existsInGame()) {
            this.oreRand.addEntry((Object)ModOreList.IRIDIUM, 5.0);
        }
        if (ModOreList.MOONSTONE.existsInGame()) {
            this.oreRand.addEntry((Object)ModOreList.MOONSTONE, 5.0);
        }
        if (ModOreList.PLATINUM.existsInGame()) {
            this.oreRand.addEntry((Object)ModOreList.PLATINUM, 10.0);
        }
        if (ModOreList.RUBY.existsInGame()) {
            this.oreRand.addEntry((Object)ModOreList.RUBY, 20.0);
        }
        if (ModOreList.SAPPHIRE.existsInGame()) {
            this.oreRand.addEntry((Object)ModOreList.SAPPHIRE, 20.0);
        }
        if (ModOreList.PERIDOT.existsInGame()) {
            this.oreRand.addEntry((Object)ModOreList.PERIDOT, 20.0);
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        long seed = world.func_72905_C();
        if (this.contours == null || this.noiseSeed != seed) {
            this.contours = new SimplexNoiseGenerator(seed >> 1).setFrequency(0.0625).addOctave(2.0, 0.5, 1000.0);
            this.islandFrequency = new SimplexNoiseGenerator(seed << 1).setFrequency(0.03125);
            this.crystalNoise = new Simplex3DGenerator(-seed).setFrequency(0.041666666666666664);
            this.noiseSeed = seed;
            this.treeRand.setSeed(seed);
        }
        this.generateMaterialVeins(world, chunkX *= 16, chunkZ *= 16, random);
        this.generateIslands(world, chunkX, chunkZ, random);
        this.growSaplings(world, chunkX, chunkZ, random);
        this.cleanupBlocks(world, chunkX, chunkZ);
    }

    private void growSaplings(World world, int chunkX, int chunkZ, Random rand) {
        for (int i = 0; i < 16; ++i) {
            for (int k = 0; k < 16; ++k) {
                int x = chunkX + i;
                int z = chunkZ + k;
                BiomeGenBase biome = world.func_72807_a(x, z);
                if (!BiomeGlowingCliffs.isGlowingCliffs(biome)) continue;
                for (int y = 62; y <= 113; ++y) {
                    Block b = world.func_147439_a(x, y, z);
                    if (b != Blocks.field_150345_g) continue;
                    world.func_147449_b(x, y, z, Blocks.field_150350_a);
                    WorldGenAbstractTree tree = ChromatiCraft.glowingcliffs.getUndergroundTreeGen(rand, true, 40);
                    ((BiomeGlowingCliffs.GlowingTreeGen)tree).setGlowChance(10);
                    tree.func_76487_a(1.0, 1.0, 1.0);
                    boolean flag = tree.func_76484_a(world, rand, x, y, z);
                    for (int n = 8; !flag && n <= 8; ++n) {
                        flag = tree.func_76484_a(world, rand, x, y, z);
                    }
                    if (!flag) continue;
                    tree.func_150524_b(world, rand, x, y, z);
                }
            }
        }
    }

    private void cleanupBlocks(World world, int chunkX, int chunkZ) {
        for (int i = 0; i < 16; ++i) {
            for (int k = 0; k < 16; ++k) {
                int x = chunkX + i;
                int z = chunkZ + k;
                if (!BiomeGlowingCliffs.isGlowingCliffs(world.func_72807_a(x, z))) continue;
                for (int y = 58; y <= 160; ++y) {
                    Block b = world.func_147439_a(x, y, z);
                    int meta = world.func_72805_g(x, y, z);
                    Block b2 = b;
                    if (b == Blocks.field_150349_c && world.func_147439_a(x, y + 1, z).func_149662_c()) {
                        b2 = Blocks.field_150346_d;
                    }
                    if ((b == Blocks.field_150346_d || b == Blocks.field_150349_c) && !world.func_147439_a(x, y - 1, z).func_149688_o().func_76220_a() && world.func_147439_a(x, y + 1, z).func_149688_o().func_76220_a()) {
                        b2 = Blocks.field_150348_b;
                    }
                    if ((b instanceof BlockTieredPlant && meta == BlockTieredPlant.TieredPlants.FLOWER.ordinal() || b instanceof BlockDecoFlower && meta == BlockDecoFlower.Flowers.GLOWDAISY.ordinal()) && !world.func_147439_a(x, y - 1, z).func_149688_o().func_76220_a()) {
                        b2 = Blocks.field_150350_a;
                    }
                    if (b2 == b) continue;
                    world.func_147465_d(x, y, z, b2, 0, 2);
                }
            }
        }
    }

    private void generateMaterialVeins(World world, int chunkX, int chunkZ, Random random) {
        if (ReikaChunkHelper.chunkContainsBiomeTypeBlockCoords((World)world, (int)chunkX, (int)chunkZ, BiomeGlowingCliffs.class)) {
            int n = 1 + random.nextInt(6);
            for (int i = 0; i < n; ++i) {
                Block b;
                int z;
                int x = chunkX + random.nextInt(16) + 8;
                if (!BiomeGlowingCliffs.isGlowingCliffs(world.func_72807_a(x, z = chunkZ + random.nextInt(16) + 8))) continue;
                int y = 64 + random.nextInt(192);
                if (!ModList.MYSTCRAFT.isLoaded() || (b = MystCraftHandler.getInstance().crystalID) == null) continue;
                int s = 32 + random.nextInt(33);
                new CrystalOreVein(b, s).func_76484_a(world, random, x, y, z);
            }
        }
    }

    private void generateIslands(World world, int chunkX, int chunkZ, Random random) {
        int z;
        int x;
        double s = ReikaMathLibrary.normalizeToBounds((double)this.islandFrequency.getValue((double)chunkX, (double)chunkZ), (double)0.5, (double)2.0);
        if (ReikaRandomHelper.doWithChance((double)(33.0 / s)) && BiomeGlowingCliffs.isGlowingCliffs(world.func_72807_a(x = chunkX + random.nextInt(16) + 8, z = chunkZ + random.nextInt(16) + 8))) {
            int c;
            boolean water = world.func_147439_a(x, world.func_72825_h(x, z) + 1, z) == Blocks.field_150355_j;
            int n = c = water ? 3 : 6;
            if (random.nextInt(c) == 0) {
                Island is = this.initializeIsland(world, x, z, random, s, water);
                this.generateIsland(world, x, z, random, is);
            }
        }
    }

    private Island initializeIsland(World world, int x, int z, Random rand, double sizeScale, boolean overWater) {
        Island is = new Island(x, z);
        is.degree = 3 + rand.nextInt(4);
        is.scale = sizeScale;
        is.overWater = overWater;
        is.innerRadius = (8.0 + 4.0 * rand.nextDouble()) * sizeScale;
        is.outerRadius = (12.0 + 6.0 * rand.nextDouble()) * sizeScale;
        is.maxThickness = (18.0 + 12.0 * rand.nextDouble()) * sizeScale;
        is.originX = x;
        is.originZ = z;
        is.originY = Math.min(250, Math.max(world.func_72825_h(x, z) + 10 + (int)is.maxThickness, 90) + rand.nextInt(80));
        is.hasLake = overWater ? rand.nextInt(3) > 0 : rand.nextInt(2) == 0;
        is.hasRiver = rand.nextInt(overWater ? 4 : 5) == 0;
        if ((is.hasLake || is.hasRiver) && overWater && is.originY > 220 && rand.nextInt(20) == 0) {
            is.liquid = ChromaBlocks.LUMA.getBlockInstance();
        }
        if (rand.nextInt(20) == 0) {
            is.hasLake = (is.hasRiver = true);
        }
        if (is.hasLake) {
            is.lakeDepth = 2 + rand.nextInt(5);
            is.lakeScale = 0.25 + rand.nextDouble() * 0.625;
        }
        if (is.hasRiver) {
            is.allowableChildren = rand.nextInt(4) > 0 ? 0 : (rand.nextInt(8) == 0 ? 2 : 1);
        }
        return is;
    }

    private boolean generateIsland(World world, int x, int z, Random rand, Island is) {
        is.calculate(world, x, z, rand);
        if (is.canGenerate(world)) {
            is.generate(world);
            BiomeGlowingCliffs b = ChromatiCraft.glowingcliffs;
            ((GlowingCliffsDecorator)b.field_76760_I).genIslandDecorations(world, b, is);
            int n = 2 + rand.nextInt(7);
            for (int i = 0; i < n; ++i) {
                OreType ore = (OreType)this.oreRand.getRandomEntry();
                BlockKey bk = BlockKey.fromItem((ItemStack)ore.getFirstOreBlock());
                int dx = is.getRandomX(rand);
                int dy = is.getRandomY(rand);
                int dz = is.getRandomZ(rand);
                int size = 12 + rand.nextInt(20);
                new WorldGenMinable(bk.blockID, bk.metadata, size, Blocks.field_150348_b).func_76484_a(world, rand, dx, dy, dz);
            }
            return true;
        }
        return false;
    }

    public boolean canGenerateAt(World world, int chunkX, int chunkZ) {
        return true;
    }

    public String getIDString() {
        return "Glowing Cliffs Floating Islands";
    }

    private static class CrystalOreVein
    extends ControllableOreVein.ExposedOreVein {
        public CrystalOreVein(Block block, int size) {
            super(block, size);
        }

        public boolean canPlaceBlockHere(World world, int x, int y, int z) {
            return super.canPlaceBlockHere(world, x, y, z) && world.func_147439_a(x, y, z) != ChromaBlocks.CLIFFSTONE.getBlockInstance();
        }
    }

    public static class Island {
        private final HashMap<Coordinate, BlockKey> blocks = new HashMap();
        private final HashMap<Coordinate, Integer> topMap = new HashMap();
        private int originX;
        private int originY;
        private int originZ;
        private double scale = 1.0;
        private double innerRadius = 10.0;
        private double outerRadius = 18.0;
        private double minThickness = 2.0;
        private double maxThickness = 24.0;
        private int degree = 6;
        private boolean overWater;
        private boolean hasLake = false;
        private boolean hasRiver = false;
        private Block liquid = Blocks.field_150358_i;
        private double lakeDepth = 5.0;
        private double lakeScale = 0.5;
        private int allowableChildren = 0;

        private Island(int x, int z) {
            this.originX = x;
            this.originZ = z;
        }

        private void calculate(World world, int x, int z, Random rand) {
            double da = 1.0;
            LobulatedCurve lb = LobulatedCurve.fromMinMaxRadii((double)this.innerRadius, (double)this.outerRadius, (int)this.degree);
            lb.generate(rand);
            for (double d = 0.0; d < 360.0; d += da) {
                double r = lb.getRadius(d);
                double cos = Math.cos(Math.toRadians(d));
                double sin = Math.sin(Math.toRadians(d));
                for (double dr = 0.0; dr <= r; dr += 0.5) {
                    double ax = (double)x + dr * cos;
                    double az = (double)z + dr * sin;
                    int dx = MathHelper.func_76128_c((double)ax);
                    int dz = MathHelper.func_76128_c((double)az);
                    double t = ReikaMathLibrary.linterpolate((double)(r - dr), (double)0.0, (double)this.outerRadius, (double)this.minThickness, (double)this.maxThickness);
                    double cont = Math.abs(instance.contours.getValue((double)dx, (double)dz));
                    int oy = (int)(cont * 6.0);
                    double lr = r * this.lakeScale;
                    if (this.hasLake && dr <= lr) {
                        double ld = 2.0 * this.lakeDepth * ((lr - dr) / r / this.lakeScale);
                        oy = (int)Math.max(0.0, (double)oy - ld);
                    }
                    int ty = this.originY + oy;
                    int i = 0;
                    while ((double)i <= t) {
                        Coordinate c = new Coordinate(dx, ty - i, dz);
                        BlockKey bk = STONE;
                        double dt = ReikaMathLibrary.linterpolate((double)dr, (double)0.0, (double)this.outerRadius, (double)0.5, (double)3.0);
                        if (i == 0) {
                            bk = GRASS;
                        } else if ((double)i < dt) {
                            bk = DIRT;
                        }
                        if (bk.blockID != Blocks.field_150348_b || !this.blocks.containsKey(c)) {
                            this.blocks.put(c, bk);
                        }
                        ++i;
                    }
                    if ((this.hasRiver || this.hasLake && dr < lr) && cont < 0.125) {
                        BlockKey bk = new BlockKey(this.liquid);
                        this.blocks.put(new Coordinate(dx, ty, dz), bk);
                        this.blocks.put(new Coordinate(dx, ty - 1, dz), GRASS);
                        if (cont < 0.0625) {
                            this.blocks.put(new Coordinate(dx, ty - 1, dz), bk);
                            this.blocks.put(new Coordinate(dx, ty - 2, dz), GRASS);
                        }
                        if (dr >= r - 1.0 && this.allowableChildren > 0) {
                            this.generateChild(world, dx, dz, rand);
                        }
                    }
                    this.topMap.put(new Coordinate(dx, 0, dz), ty);
                }
            }
        }

        private void generateChild(World world, int dx, int dz, Random rand) {
            Island is = instance.initializeIsland(world, dx, dz, rand, this.scale, this.overWater);
            is.originY = this.originY - (int)this.maxThickness - 10 - rand.nextInt(30);
            is.hasLake = true;
            is.lakeDepth = 2 + rand.nextInt(5);
            is.lakeScale = 0.375 + rand.nextDouble() * 0.5;
            is.hasRiver = false;
            is.innerRadius = 6.0 + 2.0 * rand.nextDouble();
            is.outerRadius = 10.0 + 2.0 * rand.nextDouble();
            is.maxThickness = 12.0 + 6.0 * rand.nextDouble();
            if (instance.generateIsland(world, dx, dz, rand, is)) {
                --this.allowableChildren;
            }
        }

        private boolean canGenerate(World world) {
            for (Coordinate c : this.blocks.keySet()) {
                if (c.getBlock((IBlockAccess)world).isAir((IBlockAccess)world, c.xCoord, c.yCoord, c.zCoord)) continue;
                return false;
            }
            return true;
        }

        private void generate(World world) {
            for (Coordinate c : this.topMap.keySet()) {
                TEMP_ISLAND_CACHE.put(c, (ImmutablePair<Integer, Integer>)new ImmutablePair((Object)(world.func_72825_h(c.xCoord, c.zCoord) + 1), (Object)this.topMap.get(c)));
            }
            HashSet<Coordinate> placedBlocks = new HashSet<Coordinate>();
            HashMap<Coordinate, BlockKey> toplace = this.placeBlocks(world, this.blocks, placedBlocks);
            while (!toplace.isEmpty()) {
                toplace = this.placeBlocks(world, toplace, placedBlocks);
            }
        }

        private HashMap<Coordinate, BlockKey> placeBlocks(World world, HashMap<Coordinate, BlockKey> blocks, HashSet<Coordinate> placedBlocks) {
            HashMap<Coordinate, BlockKey> deferredBlocks = new HashMap<Coordinate, BlockKey>();
            for (Coordinate c : blocks.keySet()) {
                ForgeDirection dir;
                boolean water;
                BlockKey bk = blocks.get(c);
                boolean bl = water = bk.blockID == Blocks.field_150358_i;
                if (water && (dir = this.getEdgeSide(c)) != null) {
                    dir = ReikaDirectionHelper.getLeftBy90((ForgeDirection)dir);
                    Coordinate c2 = c.offset(dir, 1);
                    Coordinate c3 = c.offset(dir.getOpposite(), 1);
                    BlockKey e1 = blocks.get(c2);
                    BlockKey e2 = blocks.get(c3);
                    if (e1 == null || e2 == null || e1.blockID == Blocks.field_150358_i && this.getEdgeSide(c2) != null || e2.blockID == Blocks.field_150358_i && this.getEdgeSide(c3) != null) {
                        bk = blocks.containsKey(c.offset(0, 1, 0)) ? DIRT : GRASS;
                    }
                }
                Coordinate ca = c.offset(0, 1, 0);
                Coordinate cb = c.offset(0, -1, 0);
                if (!(bk.blockID != DIRT.blockID && bk.blockID != GRASS.blockID || this.blocks.containsKey(cb))) {
                    bk = STONE;
                }
                if (bk.blockID == GRASS.blockID && this.blocks.containsKey(ca)) {
                    bk = DIRT;
                }
                if ((bk.blockID == DIRT.blockID || bk.blockID == GRASS.blockID) && this.blocks.containsKey(cb) && !placedBlocks.contains(cb)) {
                    deferredBlocks.put(c, bk);
                    continue;
                }
                placedBlocks.add(c);
                bk.place(world, c.xCoord, c.yCoord, c.zCoord, 10);
                if (!water) continue;
                c.triggerBlockUpdate(world, false);
            }
            return deferredBlocks;
        }

        private ForgeDirection getEdgeSide(Coordinate c) {
            for (int i = 2; i < 6; ++i) {
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                Coordinate c2 = c.offset(dir, 1);
                if (this.blocks.containsKey(c2)) continue;
                return dir;
            }
            return null;
        }

        public int getRandomX(Random rand) {
            int minX = MathHelper.func_76128_c((double)((double)this.originX + 0.5 - this.outerRadius));
            int maxX = MathHelper.func_76128_c((double)((double)this.originX + 0.5 + this.outerRadius));
            return minX + rand.nextInt(maxX - minX + 1);
        }

        public int getRandomY(Random rand) {
            int maxY = this.originY + 6;
            int minY = (int)((double)(this.originY - 6) - this.maxThickness);
            return minY + rand.nextInt(maxY - minY + 1);
        }

        public int getRandomZ(Random rand) {
            int minZ = MathHelper.func_76128_c((double)((double)this.originZ + 0.5 - this.outerRadius));
            int maxZ = MathHelper.func_76128_c((double)((double)this.originZ + 0.5 + this.outerRadius));
            return minZ + rand.nextInt(maxZ - minZ + 1);
        }

        public int getTopY(World world, int x, int z) {
            return 1 + Math.max(this.originY, world.func_72825_h(x, z));
        }
    }
}

