/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.IWG;

import Reika.ChromatiCraft.Auxiliary.Interfaces.ChromaDecorator;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.World.BiomeGlowingCliffs;
import Reika.DragonAPI.Interfaces.RetroactiveGenerator;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.util.ForgeDirection;

public class LumaGenerator
implements RetroactiveGenerator,
ChromaDecorator {
    public static final LumaGenerator instance = new LumaGenerator();

    private LumaGenerator() {
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        BiomeGenBase b;
        if (this.generateIn(world) && BiomeGlowingCliffs.isGlowingCliffs(b = world.func_72807_a(chunkX *= 16, chunkZ *= 16))) {
            int n = 1 + rand.nextInt(ChromatiCraft.isRainbowForest(b) ? 6 : 2);
            for (int in = 0; in < n; ++in) {
                int x = chunkX + rand.nextInt(16);
                int z = chunkZ + rand.nextInt(16);
                int y = 10 + rand.nextInt(39);
                if (rand.nextBoolean()) {
                    y = 10 + (y - 10) / 2;
                }
                int r = 2 + rand.nextInt(5);
                int ry = 1 + rand.nextInt(3);
                double dmax = ReikaMathLibrary.py3d((double)r, (double)ry, (double)r);
                for (int i = -r; i <= r; ++i) {
                    for (int k = -r; k <= r; ++k) {
                        for (int j = -ry; j <= ry; ++j) {
                            if (!ReikaMathLibrary.isPointInsideEllipse((double)i, (double)j, (double)k, (double)r, (double)ry, (double)r)) continue;
                            double dd = ReikaMathLibrary.py3d((double)i, (double)j, (double)k);
                            int dx = x + i;
                            int dy = y + j;
                            int dz = z + k;
                            double c = 0.8 - 0.5 * dd / dmax;
                            if (!ReikaRandomHelper.doWithChance((double)c) || !this.isValidLocation(world, dx, dy, dz)) continue;
                            world.func_147449_b(dx, dy, dz, ChromaBlocks.LUMA.getBlockInstance());
                        }
                    }
                }
            }
        }
    }

    private boolean isValidLocation(World world, int x, int y, int z) {
        if (!world.func_147439_a(x, y, z).isReplaceableOreGen(world, x, y, z, Blocks.field_150348_b) && !world.func_147439_a(x, y, z).isReplaceableOreGen(world, x, y, z, Blocks.field_150346_d)) {
            return false;
        }
        if (!world.func_147439_a(x, y + 1, z).isAir((IBlockAccess)world, x, y + 1, z)) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            int dz;
            int dy;
            int dx;
            Block b;
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            if (dir == ForgeDirection.UP || (b = world.func_147439_a(dx = x + dir.offsetX, dy = y + dir.offsetY, dz = z + dir.offsetZ)) == ChromaBlocks.LUMA.getBlockInstance() || b.func_149688_o().func_76220_a()) continue;
            return false;
        }
        return true;
    }

    private boolean generateIn(World world) {
        return Math.abs(world.field_73011_w.field_76574_g) != 1 && (world.func_72912_H().func_76067_t() != WorldType.field_77138_c || ChromaOptions.FLATGEN.getState());
    }

    public boolean canGenerateAt(World world, int chunkX, int chunkZ) {
        return true;
    }

    public String getIDString() {
        return "ChromatiCraft Aether";
    }

    @Override
    public String getCommandID() {
        return "aether";
    }
}

