/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.IWG;

import Reika.ChromatiCraft.API.Event.PylonGenerationEvent;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.Aura.BaseAura;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.Network.PylonLinkNetwork;
import Reika.ChromatiCraft.ModInterface.MystPages;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaStructures;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Auxiliary.TileEntityChromaCrystal;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalPylon;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.StructuredBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.ShuffledGrid;
import Reika.DragonAPI.Instantiable.Event.Client.ClientLogoutEvent;
import Reika.DragonAPI.Instantiable.Event.Client.SinglePlayerLogoutEvent;
import Reika.DragonAPI.Interfaces.RetroactiveGenerator;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaMystcraftHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.ExtraUtilsHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.TwilightForestHandler;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.BlockFluidBase;

public final class PylonGenerator
implements RetroactiveGenerator {
    public static final PylonGenerator instance = new PylonGenerator();
    private final ForgeDirection[] dirs = ForgeDirection.values();
    private final Random rand = new Random();
    private final int GRIDSIZE = 256;
    private final HashMap<Integer, ShuffledGrid> chunkFilter = new HashMap();
    public static final String NBT_TAG = "pylonloc";
    private final EnumMap<CrystalElement, Collection<PylonEntry>> colorCache = new EnumMap(CrystalElement.class);

    private PylonGenerator() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void savePylonLocations(NBTTagCompound NBT) {
        NBTTagList li = NBT.func_150295_c(NBT_TAG, ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        for (CrystalElement e : this.colorCache.keySet()) {
            Collection<PylonEntry> c = this.colorCache.get(e);
            for (PylonEntry loc : c) {
                NBTTagCompound tag = new NBTTagCompound();
                loc.location.writeToNBT("pos", tag);
                tag.func_74768_a("color", e.ordinal());
                tag.func_74757_a("turbo", loc.isTurboCharged);
                tag.func_74757_a("struct", loc.hasStructure);
                if (loc.playerLink != null) {
                    tag.func_74778_a("link", loc.playerLink.toString());
                }
                NBTTagList li2 = new NBTTagList();
                for (Coordinate c2 : loc.powerCrystals) {
                    li2.func_74742_a((NBTBase)c2.writeToTag());
                }
                tag.func_74782_a("crystals", (NBTBase)li2);
                li.func_74742_a((NBTBase)tag);
            }
        }
        NBT.func_74782_a(NBT_TAG, (NBTBase)li);
    }

    public void loadPylonLocations(NBTTagCompound NBT) {
        NBTTagList li = NBT.func_150295_c(NBT_TAG, ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        Iterator it = li.field_74747_a.iterator();
        while (it.hasNext()) {
            NBTTagCompound tag = (NBTTagCompound)it.next();
            WorldLocation loc = WorldLocation.readFromNBT((String)"pos", (NBTTagCompound)tag);
            CrystalElement e = CrystalElement.elements[tag.func_74762_e("color")];
            boolean turbo = tag.func_74767_n("turbo");
            String uids = tag.func_74764_b("link") ? tag.func_74779_i("link") : null;
            UUID uid = uids != null ? UUID.fromString(uids) : null;
            boolean struct = tag.func_74767_n("struct");
            NBTTagList crystals = tag.func_150295_c("crystals", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
            ArrayList<Coordinate> li2 = new ArrayList<Coordinate>();
            for (Object o : crystals.field_74747_a) {
                NBTTagCompound tag2 = (NBTTagCompound)o;
                Coordinate c = Coordinate.readTag((NBTTagCompound)tag2);
                li2.add(c);
            }
            if (this.validateCachedLocation(loc, e)) {
                this.addLocation(loc, e, li2, turbo, uid, struct);
                continue;
            }
            it.remove();
        }
        NBT.func_74782_a(NBT_TAG, (NBTBase)li);
    }

    private boolean validateCachedLocation(WorldLocation loc, CrystalElement e) {
        TileEntity te = loc.getTileEntity();
        return te instanceof TileEntityCrystalPylon && ((TileEntityCrystalPylon)te).getColor() == e;
    }

    public void sendDimensionCacheToPlayer(EntityPlayerMP ep, int dim) {
        for (CrystalElement e : this.colorCache.keySet()) {
            Collection<PylonEntry> c = this.colorCache.get(e);
            for (PylonEntry loc : c) {
                if (loc.location.dimensionID != dim) continue;
                ArrayList li = ReikaJavaLibrary.makeIntListFromArray((int[])new int[]{loc.location.xCoord, loc.location.yCoord, loc.location.zCoord, e.ordinal()});
                li.add(loc.isTurboCharged ? 1 : 0);
                li.add(loc.hasStructure ? 1 : 0);
                if (loc.playerLink != null) {
                    long l1 = loc.playerLink.getLeastSignificantBits();
                    long l2 = loc.playerLink.getMostSignificantBits();
                    int[] a1 = ReikaJavaLibrary.splitLong((long)l1);
                    int[] a2 = ReikaJavaLibrary.splitLong((long)l2);
                    li.add(a1[0]);
                    li.add(a1[1]);
                    li.add(a2[0]);
                    li.add(a2[1]);
                } else {
                    li.add(-1);
                    li.add(-1);
                    li.add(-1);
                    li.add(-1);
                }
                for (Coordinate c2 : loc.powerCrystals) {
                    li.add(c2.xCoord);
                    li.add(c2.yCoord);
                    li.add(c2.zCoord);
                }
                li.add(0, li.size());
                ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.PYLONCACHE.ordinal(), (EntityPlayerMP)ep, (List)li);
            }
        }
    }

    @SubscribeEvent
    public void clearOnUnload(WorldEvent.Unload evt) {
        if (!evt.world.field_72995_K) {
            this.clear(evt.world);
        }
    }

    @SubscribeEvent
    public void clearOnLogout(FMLNetworkEvent.ClientDisconnectionFromServerEvent evt) {
        ChromatiCraft.logger.debug((Object)("[" + FMLCommonHandler.instance().getEffectiveSide() + "] Logout clear"));
        this.colorCache.clear();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void clearOnLogout(ClientLogoutEvent evt) {
        ChromatiCraft.logger.debug((Object)("[" + FMLCommonHandler.instance().getEffectiveSide() + "] Logout clear"));
        this.colorCache.clear();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void clearOnLogout(SinglePlayerLogoutEvent evt) {
        ChromatiCraft.logger.debug((Object)("[" + FMLCommonHandler.instance().getEffectiveSide() + "] Logout clear"));
        this.colorCache.clear();
    }

    private void clear(World world) {
        this.clearDimension(world.field_73011_w.field_76574_g);
    }

    public void clearDimension(int dim) {
        this.chunkFilter.remove(dim);
    }

    private ShuffledGrid getGrid(World world) {
        int dim = world.field_73011_w.field_76574_g;
        ShuffledGrid arr = this.chunkFilter.get(dim);
        if (arr == null) {
            arr = new ShuffledGrid(256, 4, 10);
            this.populateWorldData(world, arr);
            this.chunkFilter.put(dim, arr);
        }
        return arr;
    }

    private void populateWorldData(World world, ShuffledGrid grid) {
        int id = world.field_73011_w.field_76574_g;
        this.rand.setSeed(world.func_72905_C() ^ (long)id);
        grid.calculate(this.rand);
    }

    public PylonEntry getNearestPylonSpawn(World world, double x, double y, double z, CrystalElement e) {
        Collection<PylonEntry> c = this.colorCache.get(e);
        if (c == null) {
            return null;
        }
        double dist = Double.POSITIVE_INFINITY;
        PylonEntry close = null;
        for (PylonEntry loc : c) {
            double d;
            if (loc.location.dimensionID != world.field_73011_w.field_76574_g || !((d = loc.location.getDistanceTo(x, y, z)) < dist)) continue;
            dist = d;
            close = loc;
        }
        return close;
    }

    public boolean isGennableChunk(World world, int chunkX, int chunkZ) {
        return this.getGrid(world).isValid(chunkX, chunkZ);
    }

    public void generate(Random r, int chunkX, int chunkZ, World world, IChunkProvider gen, IChunkProvider p) {
        if (this.canGenerateIn(world) && this.isGennableChunk(world, chunkX, chunkZ)) {
            this.tryForceGenerate(world, chunkX * 16, chunkZ * 16, r);
        }
    }

    private void tryForceGenerate(World world, int cx, int cz, Random r) {
        int maxtries = 24;
        for (int i = 0; i < maxtries; ++i) {
            int z;
            int y;
            int x = cx + r.nextInt(16);
            if (!this.canGenerateAt(world, x, y = world.func_72825_h(x, z = cz + r.nextInt(16)) - 1, z)) continue;
            ChromatiCraft.logger.debug((Object)("Generated pylon at " + x + ", " + z));
            this.generatePylon(r, world, x, y, z);
            break;
        }
    }

    public boolean canGenerateIn(World world) {
        if (world.field_73011_w.field_76574_g == 0) {
            return true;
        }
        if (Math.abs(world.field_73011_w.field_76574_g) == 1) {
            return false;
        }
        if (world.field_73011_w.field_76575_d || world.field_73011_w.field_76576_e) {
            return false;
        }
        if (world.field_73011_w.field_76574_g == ExtraUtilsHandler.getInstance().darkID) {
            return false;
        }
        if (world.field_73011_w.field_76574_g == TwilightForestHandler.getInstance().dimensionID) {
            return false;
        }
        if (ModList.MYSTCRAFT.isLoaded() && ReikaMystcraftHelper.isMystAge((World)world)) {
            return MystPages.Pages.PYLONS.existsInWorld(world);
        }
        if (world.func_72912_H().func_76067_t() == WorldType.field_77138_c && !ChromaOptions.FLATGEN.getState()) {
            return false;
        }
        return ChromaOptions.NONWORLDGEN.getState();
    }

    private boolean canGenerateAt(World world, int x, int y, int z) {
        BiomeGenBase biome = world.func_72807_a(x, z);
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
            return false;
        }
        if (world.func_147439_a(x, 0, z) == Blocks.field_150350_a || world.func_72937_j(x, 1, z)) {
            return false;
        }
        if (ReikaBlockHelper.isWood((IBlockAccess)world, (int)x, (int)y, (int)z) || ReikaBlockHelper.isLeaf((IBlockAccess)world, (int)x, (int)y, (int)z)) {
            return false;
        }
        StructuredBlockArray blocks = new StructuredBlockArray(world);
        for (int n = 0; n <= 9; ++n) {
            int dy = y + n;
            for (int i = 2; i < 6; ++i) {
                ForgeDirection dir = this.dirs[i];
                for (int k = 0; k <= 3; ++k) {
                    int dx = x + dir.offsetX * k;
                    int dz = z + dir.offsetZ * k;
                    blocks.addBlockCoordinate(dx, dy, dz);
                    if (dir.offsetX == 0) {
                        blocks.addBlockCoordinate(dx + dir.offsetZ, dy, dz);
                        blocks.addBlockCoordinate(dx - dir.offsetZ, dy, dz);
                        continue;
                    }
                    if (dir.offsetZ != 0) continue;
                    blocks.addBlockCoordinate(dx, dy, dz + dir.offsetX);
                    blocks.addBlockCoordinate(dx, dy, dz - dir.offsetX);
                }
            }
        }
        for (int i = 0; i < blocks.getSize(); ++i) {
            Coordinate c = blocks.getNthBlock(i);
            int dx = c.xCoord;
            int dy = c.yCoord;
            int dz = c.zCoord;
            Block b = world.func_147439_a(dx, dy, dz);
            if (b instanceof BlockLiquid || b instanceof BlockFluidBase) {
                return false;
            }
            if (ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)dx, (int)dy, (int)dz)) continue;
            int meta = world.func_72805_g(dx, dy, dz);
            if (!(dy == blocks.getMinY() ? !this.isFloorReplaceable(b, meta) : !this.isAirReplaceable(b, meta))) continue;
            return false;
        }
        return true;
    }

    private boolean isFloorReplaceable(Block b, int meta) {
        if (b == Blocks.field_150348_b) {
            return true;
        }
        if (b == Blocks.field_150346_d) {
            return true;
        }
        if (b == Blocks.field_150349_c) {
            return true;
        }
        if (b == Blocks.field_150351_n) {
            return true;
        }
        if (b == Blocks.field_150354_m) {
            return true;
        }
        if (b == Blocks.field_150405_ch) {
            return true;
        }
        if (b.func_149688_o() == Material.field_151578_c) {
            return true;
        }
        if (b == Blocks.field_150364_r || b == Blocks.field_150363_s || ModWoodList.isModWood((Block)b, (int)meta)) {
            return true;
        }
        if (b == Blocks.field_150362_t || b == Blocks.field_150361_u || ModWoodList.isModLeaf((Block)b, (int)meta)) {
            return true;
        }
        if (b == Blocks.field_150328_O || b == Blocks.field_150327_N || b instanceof BlockFlower) {
            return true;
        }
        if (b == Blocks.field_150337_Q || b == Blocks.field_150338_P) {
            return true;
        }
        if (b instanceof BlockBush) {
            return true;
        }
        if (b == Blocks.field_150436_aH) {
            return true;
        }
        return b == Blocks.field_150434_aF;
    }

    private boolean isAirReplaceable(Block b, int meta) {
        if (b == Blocks.field_150346_d) {
            return true;
        }
        if (b == Blocks.field_150349_c) {
            return true;
        }
        if (b == Blocks.field_150351_n) {
            return true;
        }
        if (b == Blocks.field_150364_r || b == Blocks.field_150363_s || ModWoodList.isModWood((Block)b, (int)meta)) {
            return true;
        }
        if (b == Blocks.field_150362_t || b == Blocks.field_150361_u || ModWoodList.isModLeaf((Block)b, (int)meta)) {
            return true;
        }
        if (b == Blocks.field_150328_O || b == Blocks.field_150327_N || b instanceof BlockFlower) {
            return true;
        }
        if (b == Blocks.field_150337_Q || b == Blocks.field_150338_P) {
            return true;
        }
        if (b instanceof BlockBush) {
            return true;
        }
        if (b == Blocks.field_150436_aH) {
            return true;
        }
        return b == Blocks.field_150434_aF;
    }

    private void generatePylon(Random rand, World world, int x, int y, int z) {
        boolean broken;
        Block b = ChromaBlocks.PYLONSTRUCT.getBlockInstance();
        ElementTagCompound tag = BaseAura.getBaseAura(world, x, y, z);
        if (rand.nextInt(25) > 0) {
            tag.clipToPrimaries();
        }
        CrystalElement e = CrystalElement.randomElement();
        FilledBlockArray array = ChromaStructures.PYLON.getArray(world, x, y + 9, z, e);
        boolean bl = broken = ChromaOptions.BROKENPYLON.getState() && rand.nextInt(2) == 0;
        if (broken) {
            this.breakPylon(array);
        }
        Coordinate offset = this.getTreeDodgeAttempt(array, world, x, y, z, 8, 16);
        array.offset(offset.xCoord, offset.yCoord, offset.zCoord);
        y -= array.sink(world, new Material[]{Material.field_151575_d, Material.field_151584_j});
        if (array.getMaxY() >= 255) {
            return;
        }
        for (int n = -4; n < 0; ++n) {
            int dy = y + n;
            for (int i = 2; i < 6; ++i) {
                ForgeDirection dir = this.dirs[i];
                for (int k = 0; k <= 3; ++k) {
                    int dx = x + dir.offsetX * k;
                    int dz = z + dir.offsetZ * k;
                    if (ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)dx, (int)dy, (int)dz)) {
                        array.setBlock(dx, dy, dz, b, 0);
                    }
                    if (dir.offsetX == 0) {
                        if (ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)(dx + dir.offsetZ), (int)dy, (int)dz)) {
                            array.setBlock(dx + dir.offsetZ, dy, dz, b, 0);
                        }
                        if (!ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)(dx - dir.offsetZ), (int)dy, (int)dz)) continue;
                        array.setBlock(dx - dir.offsetZ, dy, dz, b, 0);
                        continue;
                    }
                    if (dir.offsetZ != 0) continue;
                    if (ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)dx, (int)dy, (int)(dz + dir.offsetX))) {
                        array.setBlock(dx, dy, dz + dir.offsetX, b, 0);
                    }
                    if (!ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)dx, (int)dy, (int)(dz - dir.offsetX))) continue;
                    array.setBlock(dx, dy, dz - dir.offsetX, b, 0);
                }
            }
        }
        array.place();
        world.func_147465_d(x, y + 9, z, ChromaTiles.PYLON.getBlock(), ChromaTiles.PYLON.getBlockMetadata(), 3);
        TileEntityCrystalPylon te = (TileEntityCrystalPylon)world.func_147438_o(x, y + 9, z);
        te.generateColor(e);
        if (broken) {
            te.invalidateMultiblock();
        } else {
            te.validateMultiblock(array);
        }
        world.func_147451_t(x, y + 9, z);
        this.cachePylon(te);
        MinecraftForge.EVENT_BUS.post((Event)new PylonGenerationEvent(world, x, y + 9, z, rand, broken, e));
    }

    private Coordinate getTreeDodgeAttempt(FilledBlockArray array, World world, int x0, int y0, int z0, int tries, int range) {
        if (!this.isTreePylon(array, world, x0, y0, z0)) {
            return new Coordinate(0, 0, 0);
        }
        for (int i = 0; i < tries; ++i) {
            Coordinate c;
            int z;
            int y;
            int x = ReikaRandomHelper.getRandomPlusMinus((int)x0, (int)range);
            if (!this.isTreePylon(array, world, x, y = world.func_72825_h(x, z = ReikaRandomHelper.getRandomPlusMinus((int)z0, (int)range)) - 1, z)) {
                c = new Coordinate(x - x0, y - y0, z - z0);
                ChromatiCraft.logger.debug((Object)("Moved pylon @ " + x0 + "," + z0 + " to avoid in-tree generation: delta=" + c));
                return c;
            }
            if (!ChromatiCraft.logger.shouldDebug()) continue;
            c = new Coordinate(x - x0, y - y0, z - z0);
            ChromatiCraft.logger.debug((Object)("Pylon @ " + x0 + "," + z0 + " tree avoidance attempt " + i + ": delta " + c + " failed. Floor block = " + world.func_147439_a(array.getMidX(), array.getMinY(), array.getMidZ())));
        }
        ChromatiCraft.logger.debug((Object)("Tried moving pylon @ " + x0 + "," + z0 + " to avoid in-tree generation, but failed to find better spawn after " + tries + " attempts."));
        return new Coordinate(0, 0, 0);
    }

    private boolean isTreePylon(FilledBlockArray array, World world, int x, int y, int z) {
        int midx = array.getMidX();
        int miny = array.getMinY();
        int midz = array.getMidZ();
        if (ChromatiCraft.logger.shouldDebug()) {
            ChromatiCraft.logger.debug((Object)("Testing prospective pylon location " + x + ", " + y + ", " + z));
        }
        if (ReikaBlockHelper.isWood((IBlockAccess)world, (int)midx, (int)miny, (int)midz) || ReikaBlockHelper.isLeaf((IBlockAccess)world, (int)midx, (int)miny, (int)midz)) {
            return true;
        }
        if (ReikaBlockHelper.isWood((IBlockAccess)world, (int)midx, (int)(miny - 1), (int)midz) || ReikaBlockHelper.isLeaf((IBlockAccess)world, (int)midx, (int)(miny - 1), (int)midz)) {
            return true;
        }
        if (ChromatiCraft.logger.shouldDebug()) {
            ChromatiCraft.logger.debug((Object)"Pylon location passed tree test.");
        }
        return false;
    }

    public void removeCachedPylon(TileEntityCrystalPylon te) {
        PylonEntry loc = new PylonEntry(te);
        Collection<PylonEntry> c = this.colorCache.get(te.getColor());
        if (c != null) {
            c.remove(loc);
        }
    }

    public void cachePylon(TileEntityCrystalPylon te) {
        this.addToCache(new PylonEntry(te));
    }

    private void addToCache(PylonEntry e) {
        this.addLocation(e);
        ArrayList li = ReikaJavaLibrary.makeIntListFromArray((int[])new int[]{e.location.xCoord, e.location.yCoord, e.location.zCoord, e.color.ordinal()});
        li.add(e.isTurboCharged ? 1 : 0);
        li.add(e.hasStructure ? 1 : 0);
        if (e.playerLink != null) {
            long l1 = e.playerLink.getLeastSignificantBits();
            long l2 = e.playerLink.getMostSignificantBits();
            int[] a1 = ReikaJavaLibrary.splitLong((long)l1);
            int[] a2 = ReikaJavaLibrary.splitLong((long)l2);
            li.add(a1[0]);
            li.add(a1[1]);
            li.add(a2[0]);
            li.add(a2[1]);
        } else {
            li.add(-1);
            li.add(-1);
            li.add(-1);
            li.add(-1);
        }
        for (Coordinate c : e.powerCrystals) {
            li.add(c.xCoord);
            li.add(c.yCoord);
            li.add(c.zCoord);
        }
        li.add(0, li.size());
        ReikaPacketHelper.sendDataPacketToEntireServer((String)"ChromaData", (int)ChromaPackets.PYLONCACHE.ordinal(), (List)li);
    }

    @SideOnly(value=Side.CLIENT)
    public void cachePylonLocation(World world, int x, int y, int z, CrystalElement e, ArrayList<Coordinate> li, boolean turbo, UUID link, boolean struct) {
        this.addLocation(new WorldLocation(world, x, y, z), e, li, turbo, link, struct);
    }

    private void addLocation(WorldLocation loc, CrystalElement e, ArrayList<Coordinate> li, boolean turbo, UUID link, boolean struct) {
        this.addLocation(new PylonEntry(e, loc, li, turbo, link, struct));
    }

    private void addLocation(PylonEntry pe) {
        Collection<PylonEntry> c = this.colorCache.get(pe.color);
        if (c == null) {
            c = new HashSet<PylonEntry>();
            this.colorCache.put(pe.color, c);
        }
        c.remove(pe);
        c.add(pe);
    }

    private void breakPylon(FilledBlockArray array) {
        int n = 3 + this.rand.nextInt(4);
        int i = 0;
        Block b = ChromaBlocks.PYLONSTRUCT.getBlockInstance();
        while (i < n) {
            Coordinate c = array.getRandomBlock();
            int x = c.xCoord;
            int y = c.yCoord;
            int z = c.zCoord;
            if (!array.hasBlockAt(x, y, z, b, 0) && !array.hasBlockAt(x, y, z, b, 1) && !array.hasBlockAt(x, y, z, b, 2) && !array.hasBlockAt(x, y, z, b, 7) && !array.hasBlockAt(x, y, z, b, 8)) continue;
            ++i;
            array.setBlock(x, y, z, Blocks.field_150350_a);
        }
    }

    public boolean canGenerateAt(World world, int chunkX, int chunkZ) {
        return true;
    }

    public String getIDString() {
        return "ChromatiCraft Pylons";
    }

    public void printPylonCache(ICommandSender ics) {
        ReikaJavaLibrary.pConsole((Object)("[" + FMLCommonHandler.instance().getEffectiveSide() + "] Cache Debug: " + System.identityHashCode(this.colorCache) + "/" + System.identityHashCode(this) + "#" + this.colorCache));
    }

    public static class PylonEntry {
        public final CrystalElement color;
        public final WorldLocation location;
        private final ArrayList<Coordinate> powerCrystals = new ArrayList();
        public final boolean isTurboCharged;
        public final UUID playerLink;
        public final boolean hasStructure;

        private PylonEntry(TileEntityCrystalPylon te) {
            this(te.getColor(), new WorldLocation((TileEntity)te), te.getBoosterCrystals(te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e, false), te.isEnhanced(), te.getLinkTileUUID(), te.hasStructure());
        }

        public PylonEntry(CrystalElement e, WorldLocation loc, ArrayList li, boolean turbo, UUID link, boolean struct) {
            this.color = e;
            this.location = loc;
            for (Object o : li) {
                if (o instanceof Coordinate) {
                    this.powerCrystals.add((Coordinate)o);
                    continue;
                }
                if (!(o instanceof TileEntityChromaCrystal)) continue;
                this.powerCrystals.add(new Coordinate((TileEntity)o));
            }
            this.isTurboCharged = turbo;
            this.playerLink = link;
            this.hasStructure = struct;
        }

        public int hashCode() {
            return this.location.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof PylonEntry && ((PylonEntry)o).location.equals((Object)this.location);
        }

        public String toString() {
            return this.color.name() + " @ " + this.location.toString() + " [CRY = " + this.powerCrystals.size() + "x/TRB = " + this.isTurboCharged + "/LNK = " + this.playerLink + "/STR = " + this.hasStructure + "]";
        }

        public Collection<Coordinate> getCrystals() {
            return Collections.unmodifiableCollection(this.powerCrystals);
        }

        public int getLinkedPylons() {
            if (this.playerLink == null) {
                return 0;
            }
            return PylonLinkNetwork.instance.getLinkedPylons(this.location.getWorld(), this.playerLink, this.color).size() - 1;
        }
    }
}

