/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.IWG;

import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntitySkypeater;
import Reika.ChromatiCraft.World.BiomeGlowingCliffs;
import Reika.ChromatiCraft.World.GlowingCliffsColumnShaper;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Interfaces.RetroactiveGenerator;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.MinecraftForge;

public class SkypeaterGenerator
implements RetroactiveGenerator {
    public static final SkypeaterGenerator instance = new SkypeaterGenerator();
    private final ArrayList<Coordinate> attemptLocations = new ArrayList();

    private SkypeaterGenerator() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        for (int i = 0; i < 4; ++i) {
            for (int k = 0; k < 4; ++k) {
                this.attemptLocations.add(new Coordinate(i * 4 + 2, 0, k * 4 + 2));
            }
        }
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        chunkX *= 16;
        chunkZ *= 16;
        ArrayList<Coordinate> attempts = new ArrayList<Coordinate>(this.attemptLocations);
        while (!attempts.isEmpty()) {
            int y;
            GlowingCliffsColumnShaper terrain;
            GlowingCliffsColumnShaper.GlowCliffRegion region;
            Coordinate c = attempts.remove(rand.nextInt(attempts.size()));
            int dx = chunkX + c.xCoord;
            int dz = chunkZ + c.zCoord;
            BiomeGenBase b = world.func_72807_a(dx, dz);
            if (!BiomeGlowingCliffs.isGlowingCliffs(b) || !((region = (terrain = BiomeGlowingCliffs.getTerrain(world)).getRegion(world, dx, dz, b)) == GlowingCliffsColumnShaper.GlowCliffRegion.WATER ? this.generateAt(world, dx, y = 96 + rand.nextInt(8), dz, TileEntitySkypeater.NodeClass.WATER) : region == GlowingCliffsColumnShaper.GlowCliffRegion.SHORES && this.generateAt(world, dx, y = 108 + rand.nextInt(8), dz, TileEntitySkypeater.NodeClass.SHORE))) continue;
            break;
        }
    }

    private boolean generateAt(World world, int x, int y, int z, TileEntitySkypeater.NodeClass c) {
        if (world.func_147439_a(x, y, z).isAir((IBlockAccess)world, x, y, z) && world.func_72937_j(x, y, z) && world.func_147439_a(x, world.func_72825_h(x, z) + 1, z) == Blocks.field_150355_j) {
            if (CrystalNetworker.instance.getNearestTileOfType(world, x, y, z, TileEntitySkypeater.class, 32.0) != null) {
                return false;
            }
            world.func_147465_d(x, y, z, ChromaTiles.SKYPEATER.getBlock(), ChromaTiles.SKYPEATER.getBlockMetadata(), 3);
            TileEntitySkypeater te = (TileEntitySkypeater)world.func_147438_o(x, y, z);
            te.setNodeType(c);
            CrystalNetworker.instance.addTile(te);
            return true;
        }
        return false;
    }

    public boolean canGenerateAt(World world, int chunkX, int chunkZ) {
        return true;
    }

    public String getIDString() {
        return "ChromatiCraft Airpeaters";
    }
}

