/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.IWG;

import Reika.ChromatiCraft.Auxiliary.Interfaces.ChromaDecorator;
import Reika.ChromatiCraft.Block.Worldgen.BlockTieredOre;
import Reika.ChromatiCraft.Block.Worldgen.BlockTieredPlant;
import Reika.ChromatiCraft.ModInterface.MystPages;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ExtraChromaIDs;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Interfaces.RetroactiveGenerator;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaMystcraftHelper;
import Reika.DragonAPI.ModList;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;

public class TieredWorldGenerator
implements RetroactiveGenerator,
ChromaDecorator {
    public static final TieredWorldGenerator instance = new TieredWorldGenerator();
    public boolean skipPlants = false;
    public boolean skipOres = false;

    private TieredWorldGenerator() {
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int posZ;
        int posX;
        int k;
        int n;
        boolean flag;
        Enum p;
        int i;
        chunkX *= 16;
        chunkZ *= 16;
        if (!this.skipPlants && this.generateIn(world, false)) {
            for (i = 0; i < BlockTieredPlant.TieredPlants.list.length; ++i) {
                p = BlockTieredPlant.TieredPlants.list[i];
                if (!((BlockTieredPlant.TieredPlants)p).canGenerateIn(world)) continue;
                flag = false;
                if (random.nextInt(((BlockTieredPlant.TieredPlants)p).getGenerationChance(world)) != 0) continue;
                n = ((BlockTieredPlant.TieredPlants)p).getGenerationCount(world);
                for (k = 0; k < n; ++k) {
                    posX = chunkX + random.nextInt(16);
                    Coordinate c = ((BlockTieredPlant.TieredPlants)p).generate(world, posX, posZ = chunkZ + random.nextInt(16), random);
                    if (c == null) continue;
                    c.setBlock(world, ((BlockTieredPlant.TieredPlants)p).getBlock(), p.ordinal());
                }
            }
        }
        if (!this.skipOres && this.generateIn(world, true)) {
            for (i = 0; i < BlockTieredOre.TieredOres.list.length; ++i) {
                p = BlockTieredOre.TieredOres.list[i];
                flag = false;
                if (random.nextInt(((BlockTieredOre.TieredOres)p).genChance) != 0) continue;
                n = ((BlockTieredOre.TieredOres)p).veinCount;
                for (k = 0; k < n; ++k) {
                    posX = chunkX + random.nextInt(16);
                    posZ = chunkZ + random.nextInt(16);
                    flag |= ((BlockTieredOre.TieredOres)p).generate(world, posX, posZ, random);
                }
            }
        }
        this.skipOres = false;
        this.skipPlants = false;
    }

    private boolean generateIn(World world, boolean ore) {
        if (world.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue()) {
            return true;
        }
        if (world.func_72912_H().func_76067_t() == WorldType.field_77138_c && !ChromaOptions.FLATGEN.getState()) {
            return false;
        }
        if (Math.abs(world.field_73011_w.field_76574_g) <= 1) {
            return true;
        }
        if (ModList.MYSTCRAFT.isLoaded() && ReikaMystcraftHelper.isMystAge((World)world) && (ore ? !MystPages.Pages.ORES.existsInWorld(world) : !MystPages.Pages.PLANTS.existsInWorld(world))) {
            return false;
        }
        return !world.field_73011_w.field_76576_e;
    }

    public boolean canGenerateAt(World world, int chunkX, int chunkZ) {
        return true;
    }

    public String getIDString() {
        return "ChromatiCraft Tiered Materials";
    }

    @Override
    public String getCommandID() {
        return "tiered";
    }
}

