/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.IWG;

import Reika.ChromatiCraft.Magic.Lore.LoreManager;
import Reika.ChromatiCraft.Magic.Lore.Towers;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.DragonAPI.Interfaces.RetroactiveGenerator;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenOcean;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.util.ForgeDirection;

public class UnknownArtefactGenerator
implements RetroactiveGenerator {
    public static final UnknownArtefactGenerator instance = new UnknownArtefactGenerator();
    private static final int INNER_RADIUS = 384;
    private static final int OUTER_RADIUS = 512;
    private long cachedSeed;
    private final HashSet<ChunkCoordIntPair> UAChunks = new HashSet();

    private UnknownArtefactGenerator() {
    }

    private void calculateUAChunks(World world) {
        LoreManager.instance.initTowers(world);
        this.cachedSeed = world.func_72905_C();
        this.UAChunks.clear();
        for (int i = 0; i < Towers.towerList.length; ++i) {
            Towers t = Towers.towerList[i];
            ChunkCoordIntPair p = t.getRootPosition();
            int x = p.field_77276_a + 8;
            int z = p.field_77275_b + 8;
            for (double a = 0.0; a < 360.0; a += 2.0) {
                double cos = Math.cos(Math.toRadians(a));
                double sin = Math.sin(Math.toRadians(a));
                for (int r = 384; r <= 512; r += 8) {
                    int dx = MathHelper.func_76128_c((double)((double)x + (double)r * cos));
                    int dz = MathHelper.func_76128_c((double)((double)z + (double)r * sin));
                    ChunkCoordIntPair p2 = new ChunkCoordIntPair(dx >> 4 << 4, dz >> 4 << 4);
                    this.UAChunks.add(p2);
                }
            }
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (this.canGenerateIn(world)) {
            if (this.UAChunks.isEmpty() || this.cachedSeed != world.func_72905_C()) {
                this.calculateUAChunks(world);
            }
            if (!this.isGennableChunk(world, chunkX * 16, chunkZ * 16, random) || this.generate(world, chunkX * 16, chunkZ * 16, random)) {
                // empty if block
            }
        }
    }

    private boolean generate(World world, int cx, int cz, Random rand) {
        if (rand.nextInt(40) > 0) {
            return false;
        }
        if (!this.isUAChunk(world, cx, cz)) {
            return false;
        }
        int x = cx + rand.nextInt(16);
        int z = cz + rand.nextInt(16);
        int y = world.func_72825_h(x, z) - 1;
        if (!UnknownArtefactGenerator.canGenerateArtefactAt(world, x, y, z)) {
            return false;
        }
        world.func_147449_b(x, y - 1, z, ChromaBlocks.ARTEFACT.getBlockInstance());
        return true;
    }

    public boolean isUAChunk(World world, int cx, int cz) {
        if (this.UAChunks.isEmpty() || this.cachedSeed != world.func_72905_C()) {
            this.calculateUAChunks(world);
        }
        return this.canGenerateIn(world) && this.UAChunks.contains(new ChunkCoordIntPair(cx, cz));
    }

    public static boolean canGenerateArtefactAt(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        BiomeGenBase biome = world.func_72807_a(x, z);
        if (biome instanceof BiomeGenOcean || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER)) {
            return false;
        }
        if (b != biome.field_76752_A && b != biome.field_76753_B) {
            return false;
        }
        if (!UnknownArtefactGenerator.isValidSurfaceBlock(world, x, y + 1, z)) {
            return false;
        }
        if (world.func_147439_a(x, y - 1, z) != biome.field_76753_B) {
            return false;
        }
        if (ReikaWorldHelper.checkForAdjMaterial((World)world, (int)x, (int)(y - 1), (int)z, (Material)Material.field_151579_a) != null) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            if (dir == ForgeDirection.UP) continue;
            for (int d = 1; d <= 3; ++d) {
                int dx = x + dir.offsetX * d;
                int dy = y + dir.offsetY * d;
                int dz = z + dir.offsetZ * d;
                if (!world.func_147439_a(dx, dy, dz).isAir((IBlockAccess)world, dx, dy, dz)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isValidSurfaceBlock(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        if (b.isAir((IBlockAccess)world, x, y, z)) {
            return true;
        }
        if (b == Blocks.field_150431_aC) {
            return true;
        }
        if (b == ChromaBlocks.DECOFLOWER.getBlockInstance()) {
            return true;
        }
        if (ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)x, (int)y, (int)z)) {
            return true;
        }
        return b instanceof BlockBush;
    }

    private boolean isVoidWorld(World world, int x, int z) {
        return world.func_147439_a(x, 0, z) == Blocks.field_150350_a || world.func_72937_j(x, 1, z);
    }

    private boolean isGennableChunk(World world, int x, int z, Random r) {
        return !this.isVoidWorld(world, x, z);
    }

    public boolean canGenerateIn(World world) {
        if (world.field_73011_w.field_76574_g != 0) {
            return false;
        }
        if (world.func_72912_H().func_76067_t() == WorldType.field_77138_c && !ChromaOptions.FLATGEN.getState()) {
            return ReikaWorldHelper.getSuperflatHeight((World)world) > 15;
        }
        return true;
    }

    public boolean canGenerateAt(World world, int chunkX, int chunkZ) {
        return true;
    }

    public String getIDString() {
        return "ChromatiCraft Unknown Artefacts";
    }
}

