/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.IWG;

import Reika.ChromatiCraft.API.Event.NexusGenEvent;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.BiomeGlowingCliffs;
import Reika.DragonAPI.Instantiable.Data.ShuffledGrid;
import Reika.DragonAPI.Interfaces.RetroactiveGenerator;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModList;
import Reika.Satisforestry.API.SFAPI;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;

public class WarpNodeGenerator
implements RetroactiveGenerator {
    public static final WarpNodeGenerator instance = new WarpNodeGenerator();
    private final Random worldRand = new Random();
    private final int GRIDSIZE = 2048;
    private final HashMap<Integer, ShuffledGrid> chunkFilter = new HashMap();

    private WarpNodeGenerator() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void clearOnUnload(WorldEvent.Unload evt) {
        if (!evt.world.field_72995_K) {
            this.clear(evt.world);
        }
    }

    private void clear(World world) {
        this.clearDimension(world.field_73011_w.field_76574_g);
    }

    public void clearDimension(int dim) {
        this.chunkFilter.remove(dim);
    }

    private ShuffledGrid getGrid(World world) {
        int dim = world.field_73011_w.field_76574_g;
        ShuffledGrid arr = this.chunkFilter.get(dim);
        if (arr == null) {
            arr = new ShuffledGrid(2048, 20, 55);
            this.populateWorldData(world, arr);
            this.chunkFilter.put(dim, arr);
        }
        return arr;
    }

    private void populateWorldData(World world, ShuffledGrid grid) {
        int id = world.field_73011_w.field_76574_g;
        this.worldRand.setSeed(-((long)(id * 11) - world.func_72905_C() * 7L));
        grid.calculate(this.worldRand);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int posZ;
        int posX;
        BiomeGenBase b;
        if (this.isValidWorld(world) && this.isGennableChunk(world, chunkX, chunkZ) && ReikaRandomHelper.doWithChance((double)this.getBiomeSuccessChance(b = world.func_72807_a(posX = (chunkX *= 16) + random.nextInt(16), posZ = (chunkZ *= 16) + random.nextInt(16))), (Random)random)) {
            int maxy;
            int miny = this.getMinY(world, posX, posZ, b);
            if (miny >= (maxy = this.getMaxY(world, posX, posZ, b))) {
                ChromatiCraft.logger.logError((Object)("Failed to generate a warp node @ " + posX + ", " + posZ + " due to zero height range!"));
                return;
            }
            int posY = miny + random.nextInt(maxy - miny + 1);
            if (this.canGenerateAt(world, posX, posY, posZ)) {
                world.func_147449_b(posX, posY, posZ, ChromaBlocks.WARPNODE.getBlockInstance());
                MinecraftForge.EVENT_BUS.post((Event)new NexusGenEvent(world, posX, posY, posZ, random));
            }
        }
    }

    public boolean isValidWorld(World world) {
        return world.field_73011_w.field_76574_g == 0 && world.func_72912_H().func_76067_t() != WorldType.field_77138_c;
    }

    public boolean isGennableChunk(World world, int chunkX, int chunkZ) {
        return this.getGrid(world).isValid(chunkX, chunkZ);
    }

    private double getBiomeSuccessChance(BiomeGenBase b) {
        if (ChromatiCraft.isRainbowForest(b)) {
            return 0.8;
        }
        if (BiomeGlowingCliffs.isGlowingCliffs(b)) {
            return 0.667;
        }
        if (ChromatiCraft.isEnderForest(b)) {
            return 1.0;
        }
        if (ModList.SATISFORESTRY.isLoaded() && SFAPI.biomeHandler.isPinkForest(b)) {
            return 0.75;
        }
        return 0.333;
    }

    private int getMinY(World world, int x, int z, BiomeGenBase b) {
        int min = ReikaWorldHelper.getTopNonAirBlock((World)world, (int)x, (int)z, (boolean)true) + 48;
        if (BiomeGlowingCliffs.isGlowingCliffs(b)) {
            min = Math.max(min, 128);
        } else if (ModList.SATISFORESTRY.isLoaded() && SFAPI.biomeHandler.isPinkForest(b)) {
            min = SFAPI.biomeHandler.getTrueTopAt(world, x, z) + 40;
        }
        return min;
    }

    private int getMaxY(World world, int x, int z, BiomeGenBase b) {
        int max = Math.min(255, (int)(192.0f * Math.max(1.0f, b.field_76748_D)));
        if (BiomeGlowingCliffs.isGlowingCliffs(b) || ModList.SATISFORESTRY.isLoaded() && SFAPI.biomeHandler.isPinkForest(b)) {
            max = 255;
        }
        return Math.max(128, max);
    }

    private boolean canGenerateAt(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z).isAir((IBlockAccess)world, x, y, z) && world.func_72937_j(x, y, z);
    }

    public boolean canGenerateAt(World world, int chunkX, int chunkZ) {
        return true;
    }

    public String getIDString() {
        return "ChromatiCraft Warp Nodes";
    }
}

