/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Nether;

import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.Auxiliary.WorldGenInterceptionRegistry;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Maps.ThresholdMapping;
import Reika.DragonAPI.Instantiable.Event.BlockTickEvent;
import Reika.DragonAPI.Instantiable.Event.SetBlockEvent;
import Reika.DragonAPI.Instantiable.Math.Noise.SimplexNoiseGenerator;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import com.xcompwiz.mystcraft.api.world.logic.IPopulate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

@APIStripper.Strippable(value={"com.xcompwiz.mystcraft.api.world.logic.IPopulate"})
public class LavaRiverGenerator
implements IPopulate {
    private static final double RIVER_THRESH = 0.2;
    private static final double RIVER_CENTER_THRESH = 0.1;
    private static final double MIN_HEIGHT = 127.0;
    private static final double MAX_HEIGHT = 240.0;
    private static final ThresholdMapping<Block> blockTypes = new ThresholdMapping();
    public final long seed;
    private final BlockKey structBlock;
    private final BlockKey fluidBlock;
    private final SimplexNoiseGenerator placementNoise;
    private final SimplexNoiseGenerator heightNoise;
    private final SimplexNoiseGenerator blockNoise;

    public LavaRiverGenerator(long seed) {
        this(seed, null, null);
    }

    public LavaRiverGenerator(long seed, BlockKey struct, BlockKey fluid) {
        this.seed = seed;
        this.placementNoise = new SimplexNoiseGenerator(seed);
        this.heightNoise = new SimplexNoiseGenerator(-seed);
        this.blockNoise = new SimplexNoiseGenerator(seed ^ 0xFFFFFFFFFFFFFFFFL);
        this.structBlock = struct != null ? struct : new BlockKey(ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
        this.fluidBlock = fluid;
    }

    private static void addFluid(double weight, String s) {
        Fluid f = FluidRegistry.getFluid((String)s);
        if (f != null && f.canBePlacedInWorld()) {
            LavaRiverGenerator.addFluid(weight, f.getBlock());
        }
    }

    private static void addFluid(double weight, Block b) {
        blockTypes.addMapping(weight + blockTypes.lastValue(), (Object)b);
    }

    public void generate(World world, int chunkX, int chunkZ) {
        WorldGenInterceptionRegistry.skipLighting = true;
        SetBlockEvent.eventEnabledPre = false;
        SetBlockEvent.eventEnabledPost = false;
        BlockTickEvent.disallowAllUpdates = true;
        for (int i = 0; i < 16; ++i) {
            for (int k = 0; k < 16; ++k) {
                int dy;
                int j;
                int dx = chunkX * 16 + i;
                double rx = (double)dx / 32.0;
                int dz = chunkZ * 16 + k;
                double rz = (double)dz / 32.0;
                double val = Math.abs(this.placementNoise.getValue(rx, rz));
                if (!(val <= 0.2)) continue;
                double h = ReikaMathLibrary.normalizeToBounds((double)this.heightNoise.getValue(rx / 8.0, rz / 8.0), (double)127.0, (double)240.0);
                int y = (int)h;
                if (val < 0.1) {
                    for (j = 0; j < 1; ++j) {
                        dy = y + j;
                        world.func_147465_d(dx, dy, dz, this.structBlock.blockID, this.structBlock.metadata, 2);
                    }
                    for (j = 1; j <= 1; ++j) {
                        dy = y + j;
                        world.func_147465_d(dx, dy, dz, this.getLiquid(rx, rz), 0, 11);
                    }
                    continue;
                }
                for (j = 0; j < 3; ++j) {
                    dy = y + j;
                    world.func_147465_d(dx, dy, dz, this.structBlock.blockID, this.structBlock.metadata, 2);
                }
            }
        }
        BlockTickEvent.disallowAllUpdates = false;
        WorldGenInterceptionRegistry.skipLighting = false;
        SetBlockEvent.eventEnabledPre = true;
        SetBlockEvent.eventEnabledPost = true;
    }

    private Block getLiquid(double rx, double rz) {
        if (this.fluidBlock != null) {
            return this.fluidBlock.blockID;
        }
        double t = ReikaMathLibrary.normalizeToBounds((double)this.blockNoise.getValue(rx, rz), (double)0.0, (double)blockTypes.lastValue());
        return (Block)blockTypes.getForValue(t, true);
    }

    public boolean populate(World world, Random rand, int x, int z, boolean flag) {
        this.generate(world, x >> 4, z >> 4);
        return true;
    }

    static {
        LavaRiverGenerator.addFluid(20.0, "pyrotheum");
        LavaRiverGenerator.addFluid(80.0, (Block)Blocks.field_150356_k);
        LavaRiverGenerator.addFluid(40.0, "ic2pahoehoelava");
        LavaRiverGenerator.addFluid(5.0, "iron.molten");
        LavaRiverGenerator.addFluid(3.0, "gold.molten");
        LavaRiverGenerator.addFluid(2.0, "ardite.molten");
        LavaRiverGenerator.addFluid(2.0, "cobalt.molten");
        LavaRiverGenerator.addFluid(4.0, "obsidian.molten");
        LavaRiverGenerator.addFluid(10.0, "poison");
        LavaRiverGenerator.addFluid(1.0, "fluiddeath");
    }
}

