/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Nether;

import Reika.ChromatiCraft.Block.Worldgen.BlockNetherBypassGate;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.Nether.LavaRiverGenerator;
import Reika.ChromatiCraft.World.Nether.NetherStructures;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Interfaces.RetroactiveGenerator;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.util.ForgeDirection;

public class NetherStructureGenerator
implements RetroactiveGenerator {
    public static final NetherStructureGenerator instance = new NetherStructureGenerator();
    private LavaRiverGenerator lavaRiverGen;

    private NetherStructureGenerator() {
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (this.lavaRiverGen == null || this.lavaRiverGen.seed != world.func_72905_C()) {
            this.lavaRiverGen = new LavaRiverGenerator(world.func_72905_C());
        }
        if (world.field_73011_w.field_76574_g != -1) {
            return;
        }
        int n = 8;
        if (rand.nextInt(1) == 0 && Math.abs(chunkX % 4) == 0 && Math.abs(chunkZ % 4) == 2) {
            int x = chunkX * 16 + rand.nextInt(16);
            int z = chunkZ * 16 + rand.nextInt(16);
            this.tryGenerateBypass(world, x, z, rand);
        }
        this.runGroundDecorators(world, chunkX, chunkZ, rand);
        this.runAirDecorators(world, chunkX, chunkZ, rand, chunkGenerator, chunkProvider);
    }

    private void runGroundDecorators(World world, int chunkX, int chunkZ, Random rand) {
        if (rand.nextDouble() < 0.015625) {
            NetherStructures s = NetherStructures.getRandomStructure();
            int x = chunkX * 16 + rand.nextInt(16);
            int z = chunkZ * 16 + rand.nextInt(16);
            s.generate(world, x, z, rand);
        }
    }

    private void runAirDecorators(World world, int chunkX, int chunkZ, Random rand, IChunkProvider generator, IChunkProvider loader) {
        this.runGlowstoneGen(world, chunkX, chunkZ, rand);
        this.lavaRiverGen.generate(world, chunkX, chunkZ);
    }

    private void runGlowstoneGen(World world, int chunkX, int chunkZ, Random rand) {
        if (rand.nextInt(2) == 0) {
            int x = chunkX * 16 + rand.nextInt(16);
            int z = chunkZ * 16 + rand.nextInt(16);
            int y = 145 + rand.nextInt(100);
            int n = 12 + rand.nextInt(36);
            new WorldGenMinable(Blocks.field_150426_aN, n, Blocks.field_150350_a).func_76484_a(world, rand, x, y, z);
        }
    }

    private boolean tryGenerateBypass(World world, int x, int z, Random rand) {
        int c = 3;
        for (int i = -c; i <= c; ++i) {
            for (int k = -c; k <= c; ++k) {
                for (int y = 100; y >= 50; --y) {
                    if (world.func_147439_a(x + i, y, z + k).isAir((IBlockAccess)world, x + i, y, z + k)) continue;
                    return false;
                }
            }
        }
        return this.generateBedrockBypass(world, x, z, rand);
    }

    private boolean generateBedrockBypass(World world, int x, int z, Random rand) {
        int r = 3 + rand.nextInt(4);
        HashSet<Coordinate> edge = new HashSet<Coordinate>();
        for (int i = -r; i <= r; ++i) {
            for (int k = -r; k <= r; ++k) {
                int dx = x + i;
                int dz = z + k;
                if (ReikaMathLibrary.py3d((double)i, (double)0.0, (double)k) <= (double)r + 0.5) {
                    int dy = 127;
                    while (!this.isCountedAsAir(world, dx, dy, dz)) {
                        int dd = 127 - dy;
                        if (ReikaMathLibrary.py3d((double)i, (double)0.0, (double)k) < (double)r - 0.5) {
                            Block air = Blocks.field_150350_a;
                            int m = 0;
                            if (dd <= 16) {
                                air = ChromaBlocks.NETHERGATE.getBlockInstance();
                                if (dd == 0) {
                                    m = BlockNetherBypassGate.GateLevels.KILL.ordinal();
                                } else if (dd <= 2) {
                                    m = BlockNetherBypassGate.GateLevels.HURT2.ordinal();
                                } else if (dd <= 5) {
                                    m = BlockNetherBypassGate.GateLevels.HURT1.ordinal();
                                } else if (dd <= 8) {
                                    m = BlockNetherBypassGate.GateLevels.PUSH3.ordinal();
                                } else if (dd <= 12) {
                                    m = BlockNetherBypassGate.GateLevels.PUSH2.ordinal();
                                } else if (dd <= 16) {
                                    m = BlockNetherBypassGate.GateLevels.PUSH1.ordinal();
                                }
                            }
                            world.func_147465_d(dx, dy, dz, air, m, 3);
                        } else {
                            world.func_147465_d(dx, dy, dz, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata, 3);
                        }
                        --dy;
                    }
                    if (ReikaMathLibrary.py3d((double)i, (double)0.0, (double)k) >= (double)r - 0.5) {
                        edge.add(new Coordinate(dx, dy, dz));
                    }
                }
                if (!(ReikaMathLibrary.py3d((double)i, (double)0.0, (double)k) >= (double)r - 0.5) || !(ReikaMathLibrary.py3d((double)i, (double)0.0, (double)k) <= (double)r + 1.5)) continue;
                for (int d = 0; d < 6; ++d) {
                    ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[d];
                    if (!(ReikaMathLibrary.py3d((double)i, (double)0.0, (double)k) <= (double)r + 0.5) && dir.offsetY != 0) continue;
                    int ddx = dx + dir.offsetX;
                    int ddy = 128 + dir.offsetY;
                    int ddz = dz + dir.offsetZ;
                    world.func_147449_b(ddx, ddy, ddz, Blocks.field_150357_h);
                }
            }
        }
        for (Coordinate c : edge) {
            for (int d = 0; d < 6; ++d) {
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[d];
                c.offset(dir, 1).setBlock(world, Blocks.field_150385_bj);
            }
        }
        return true;
    }

    private boolean isCountedAsAir(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        return b.isAir((IBlockAccess)world, x, y, z) || b.func_149688_o() == Material.field_151585_k;
    }

    public boolean canGenerateAt(World world, int chunkX, int chunkZ) {
        return true;
    }

    public String getIDString() {
        return "Chroma_Nether";
    }
}

