/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Nether;

import Reika.ChromatiCraft.Block.Worldgen.BlockLootChest;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.Nether.NetherDiorama;
import Reika.ChromatiCraft.World.Nether.NetherMaze;
import Reika.ChromatiCraft.World.Nether.NetherSpiral;
import Reika.ChromatiCraft.World.Nether.NetherTemple;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public enum NetherStructures {
    HUT(200.0),
    TEMPLE(15.0),
    MAZE(30.0),
    SPIRAL(24.0),
    DIORAMA(8.0);

    static final double BASE_GEN_FACTOR = 0.015625;
    private static final WeightedRandom<NetherStructures> structureRand;
    private final double genChance;
    private static final NetherStructures[] list;

    private NetherStructures(double c) {
        this.genChance = c;
    }

    static NetherStructures getRandomStructure() {
        return (NetherStructures)((Object)structureRand.getRandomEntry());
    }

    public void generate(World world, int x, int z, Random rand) {
        int y = 128;
        switch (this) {
            case HUT: {
                int k;
                int i;
                for (i = -4; i <= 4; ++i) {
                    for (k = -4; k <= 4; ++k) {
                        int h = Math.abs(i) == 4 || Math.abs(k) == 4 ? 0 : 1;
                        for (int j = 0; j <= h; ++j) {
                            int dx = x + i;
                            int dz = z + k;
                            int dy = y + j;
                            world.func_147449_b(dx, dy, dz, Blocks.field_150357_h);
                        }
                    }
                }
                for (i = -2; i <= 2; ++i) {
                    world.func_147449_b(x + i, y, z + 2, Blocks.field_150335_W);
                    world.func_147449_b(x + i, y, z - 2, Blocks.field_150335_W);
                    world.func_147449_b(x + 2, y, z + i, Blocks.field_150335_W);
                    world.func_147449_b(x - 2, y, z + i, Blocks.field_150335_W);
                }
                for (i = -2; i <= 2; ++i) {
                    for (k = -2; k <= 2; ++k) {
                        int dx = x + i;
                        int dz = z + k;
                        world.func_147449_b(dx, y + 1, dz, Blocks.field_150385_bj);
                        if (Math.abs(i) == 2 && Math.abs(k) == 2) continue;
                        world.func_147449_b(dx, y + 5, dz, Blocks.field_150385_bj);
                    }
                }
                for (int j = 2; j <= 4; ++j) {
                    world.func_147449_b(x - 2, y + j, z - 2, Blocks.field_150385_bj);
                    world.func_147449_b(x + 2, y + j, z - 2, Blocks.field_150385_bj);
                    world.func_147449_b(x - 2, y + j, z + 2, Blocks.field_150385_bj);
                    world.func_147449_b(x + 2, y + j, z + 2, Blocks.field_150385_bj);
                }
                world.func_147449_b(x + 1, y, z, Blocks.field_150335_W);
                world.func_147449_b(x - 1, y, z, Blocks.field_150335_W);
                world.func_147449_b(x, y, z + 1, Blocks.field_150335_W);
                world.func_147449_b(x, y, z - 1, Blocks.field_150335_W);
                world.func_147449_b(x, y, z, ChromaBlocks.LOOTCHEST.getBlockInstance());
                BlockLootChest.TileEntityLootChest te = (BlockLootChest.TileEntityLootChest)world.func_147438_o(x, y, z);
                te.populateChest("dungeonChest", null, 0, rand, false);
                world.func_147449_b(x, y + 1, z, Blocks.field_150353_l);
                break;
            }
            case TEMPLE: {
                NetherTemple.generateAt(world, x, y, z, rand);
                break;
            }
            case MAZE: {
                NetherMaze.generateAt(world, x, y, z, rand);
                break;
            }
            case DIORAMA: {
                NetherDiorama.generateAt(world, x, y, z, rand);
                break;
            }
            case SPIRAL: {
                NetherSpiral.generateAt(world, x, y, z, rand);
            }
        }
    }

    static {
        structureRand = new WeightedRandom();
        list = NetherStructures.values();
        for (int i = 0; i < list.length; ++i) {
            structureRand.addEntry((Object)list[i], NetherStructures.list[i].genChance);
        }
    }
}

