/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World;

import Reika.ChromatiCraft.Block.Dye.BlockDyeSapling;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.World.IWG.ColorTreeGenerator;
import Reika.ChromatiCraft.World.RainbowTreeGenerator;
import Reika.ChromatiCraft.World.TreeShaper;
import Reika.DragonAPI.Instantiable.Math.Noise.NoiseGeneratorBase;
import Reika.DragonAPI.Instantiable.Math.Noise.Simplex3DGenerator;
import Reika.DragonAPI.Instantiable.Math.Noise.VoronoiNoiseGenerator;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaDyeHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.ThaumItemHelper;
import Reika.DragonAPI.ModList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class RainbowForestGenerator
extends WorldGenerator {
    private static final boolean GENERATE_SMALL_RAINBOW_TREES = true;
    private static final float FERTILE_VINE_CHANCE_FACTOR = 0.12f;
    private static final long root = 34897534781342377L;
    private static final NoiseGeneratorBase extraX = new Simplex3DGenerator(34897534781346626L).setFrequency(0.125);
    private static final NoiseGeneratorBase extraY = new Simplex3DGenerator(-34897534781344832L).setFrequency(0.125);
    private static final NoiseGeneratorBase extraZ = new Simplex3DGenerator(34897534780527380L).setFrequency(0.125);
    private static final VoronoiNoiseGenerator colorNoise = (VoronoiNoiseGenerator)new VoronoiNoiseGenerator(34897534781261192L).setFrequency(0.05).setDisplacement(extraX, extraY, extraZ, 6.0);

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        if (ColorTreeGenerator.canGenerateTree(world, x, z) && BlockDyeSapling.canGrowAt(world, x, y, z, true)) {
            ReikaDyeHelper color = RainbowForestGenerator.getColor(x, y, z);
            if (random.nextInt(10) == 0) {
                boolean generated = false;
                if (RainbowTreeGenerator.getInstance().checkRainbowTreeSpace(world, x, y, z)) {
                    RainbowTreeGenerator.getInstance().generateLargeRainbowTree(world, x, y, z, random);
                    generated = true;
                    if (ModList.THAUMCRAFT.isLoaded() && ChromaOptions.ETHEREAL.getState()) {
                        for (int i = 0; i < 8; ++i) {
                            int dx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)6);
                            int dz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)6);
                            while (!world.func_72904_c(dx, 0, dz, dx, world.field_73011_w.getActualHeight(), dz)) {
                                dx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)6);
                                dz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)6);
                            }
                            int dy = world.func_72825_h(dx, dz);
                            if (!ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)dx, (int)dy, (int)dz)) continue;
                            Block id = ThaumItemHelper.BlockEntry.ETHEREAL.getBlock();
                            int meta = ThaumItemHelper.BlockEntry.ETHEREAL.metadata;
                            world.func_147465_d(dx, dy, dz, id, meta, 3);
                            world.func_147451_t(dx, dy, dz);
                            world.func_147479_m(dx, dy, dz);
                        }
                    }
                } else if (random.nextInt(5) == 0) {
                    generated = RainbowTreeGenerator.getInstance().tryGenerateSmallRainbowTree(world, x, y, z, random);
                }
                if (!generated) {
                    TreeShaper.getInstance().generateRandomWeightedTree(world, x, y, z, random, color, false, this.getVineChance(random), 0.12f);
                }
            } else {
                TreeShaper.getInstance().generateRandomWeightedTree(world, x, y, z, random, color, false, this.getVineChance(random), 0.12f);
            }
            return true;
        }
        return false;
    }

    private float getVineChance(Random rand) {
        return rand.nextInt(5) <= 1 ? 0.6f + rand.nextFloat() * 0.4f : 0.0f;
    }

    public static ReikaDyeHelper getColor(int x, int y, int z) {
        RainbowForestGenerator.colorNoise.randomFactor = 0.45;
        return ReikaDyeHelper.dyes[(colorNoise.getClosestRoot((double)x, (double)y, (double)z).hashCode() % 16 + 16) % 16];
    }
}

