/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World;

import Reika.ChromatiCraft.API.Event.RainbowTreeEvent;
import Reika.ChromatiCraft.Auxiliary.Structure.RainbowTreeBlueprint;
import Reika.ChromatiCraft.Block.Dye.BlockRainbowLeaf;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Interfaces.Registry.TreeType;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaTreeHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.ForestryHandler;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class RainbowTreeGenerator {
    private static final RainbowTreeGenerator instance = new RainbowTreeGenerator();
    private final ArrayList<TreeType> validLogs = new ArrayList();

    private RainbowTreeGenerator() {
        ReikaTreeHelper tree;
        int i;
        for (i = 0; i < ReikaTreeHelper.treeList.length; ++i) {
            tree = ReikaTreeHelper.treeList[i];
            if (!ChromatiCraft.config.shouldGenerateLogType(tree)) continue;
            this.validLogs.add((TreeType)tree);
        }
        for (i = 0; i < ModWoodList.woodList.length; ++i) {
            tree = ModWoodList.woodList[i];
            if (!tree.exists() || !this.isLogTypeEverAllowed((ModWoodList)tree) || !ChromatiCraft.config.shouldGenerateLogType((ModWoodList)tree)) continue;
            this.validLogs.add((TreeType)tree);
        }
    }

    public boolean isLogTypeEverAllowed(ModWoodList wood) {
        if (!wood.canBePlacedSideways()) {
            return false;
        }
        switch (wood) {
            case GLOW: 
            case BLOODWOOD: 
            case NATURADARKWOOD: 
            case FUSEWOOD: 
            case BXLREDWOOD: 
            case BAMBOO: 
            case IC2RUBBER: 
            case MFRRUBBER: 
            case MINEWOOD: 
            case SEQUOIA: 
            case SORTING: 
            case TIMEWOOD: 
            case TRANSFORMATION: 
            case TWILIGHTOAK: 
            case TAINTED: {
                return false;
            }
        }
        return true;
    }

    public static final RainbowTreeGenerator getInstance() {
        return instance;
    }

    public boolean checkRainbowTreeSpace(World world, int x, int y, int z) {
        FilledBlockArray blocks = RainbowTreeBlueprint.getBlueprint(world, x -= 5, y -= 2, z -= 5, (TreeType)ReikaTreeHelper.OAK);
        for (int i = 0; i < blocks.getSize(); ++i) {
            Block id;
            Coordinate c = blocks.getNthBlock(i);
            int dx = c.xCoord;
            int dy = c.yCoord;
            int dz = c.zCoord;
            if (dy < y + 2 || (id = world.func_147439_a(dx, dy, dz)) == Blocks.field_150362_t || id == Blocks.field_150361_u || id == Blocks.field_150321_G || id == ChromaBlocks.RAINBOWSAPLING.getBlockInstance() || id == ChromaBlocks.RAINBOWLEAF.getBlockInstance() || id == ForestryHandler.BlockEntry.SAPLING.getBlock() || ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)dx, (int)dy, (int)dz)) continue;
            return false;
        }
        return true;
    }

    public void generateLargeRainbowTree(World world, int x, int y, int z, Random rand) {
        int dz;
        int dx;
        ChromatiCraft.logger.debug((Object)("Generating Rainbow Tree @ " + (x -= 5) + ", " + (y -= 2) + ", " + (z -= 5)));
        MinecraftForge.EVENT_BUS.post((Event)new RainbowTreeEvent(world, x, y, z, rand));
        for (dx = x + 4; dx <= x + 6; ++dx) {
            for (dz = z + 4; dz <= z + 6; ++dz) {
                Block block = world.func_147439_a(dx, y + 2, dz);
                if (block != ChromaBlocks.RAINBOWSAPLING.getBlockInstance()) continue;
                world.func_147468_f(dx, y + 2, dz);
            }
        }
        for (dx = x + 2; dx <= x + 7; ++dx) {
            for (dz = z + 2; dz <= z + 7; ++dz) {
                for (int dy = y + 1; dy > y - 3; --dy) {
                    if (!ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)dx, (int)dy, (int)dz)) continue;
                    world.func_147449_b(dx, dy, dz, (Block)(dy == y + 1 ? Blocks.field_150349_c : Blocks.field_150346_d));
                }
            }
        }
        RainbowTreeBlueprint.getBlueprint(world, x, y, z, this.getLogType(rand)).place();
    }

    public boolean tryGenerateSmallRainbowTree(World world, int x, int y, int z, Random rand) {
        return this.tryGenerateSmallRainbowTree(world, x, y, z, rand, 1.0f);
    }

    public boolean tryGenerateSmallRainbowTree(World world, int x, int y, int z, Random rand, float hf) {
        Block id = ChromaBlocks.RAINBOWLEAF.getBlockInstance();
        TreeType wood = this.getLogType(rand);
        int h0 = 2 + rand.nextInt(3);
        int h = h0 + MathHelper.func_76123_f((float)(hf * (float)(5 + rand.nextInt(7))));
        for (int i = 1; i <= h; ++i) {
            if (world.func_147439_a(x, y + i, z) == Blocks.field_150350_a) continue;
            h = i;
            break;
        }
        while (h > 2 && world.func_147439_a(x, y + h + 4, z) != Blocks.field_150350_a) {
            --h;
        }
        if (h <= 3) {
            return false;
        }
        h0 = Math.min(h0, h / 2);
        int w = 0;
        for (int j = 0; j < h; ++j) {
            boolean up;
            int dy = y + j;
            world.func_147465_d(x, dy, z, wood.getLogID(), ((Integer)wood.getLogMetadatas().get(0)).intValue(), 3);
            if (j < h0) continue;
            boolean canUp = w < 5 && h - j - 1 > w;
            boolean canDown = w > 1;
            boolean bl = up = rand.nextBoolean() && canUp || !canDown;
            if (!up) {
                --w;
            }
            int r = ++w;
            for (int i = -r; i <= r; ++i) {
                for (int k = -r; k <= r; ++k) {
                    int dz;
                    int dx;
                    if (i == 0 && k == 0 || Math.abs(i) + Math.abs(k) > w + 1 || !world.func_147439_a(dx = x + i, dy, dz = z + k).canBeReplacedByLeaves((IBlockAccess)world, dx, dy, dz)) continue;
                    world.func_147465_d(dx, dy, dz, id, BlockRainbowLeaf.LeafMetas.SMALL.ordinal(), 3);
                }
            }
        }
        for (int i = -1; i <= 1; ++i) {
            for (int k = -1; k <= 1; ++k) {
                int dz;
                int dx;
                if (i != 0 && k != 0 || !world.func_147439_a(dx = x + i, y + h, dz = z + k).canBeReplacedByLeaves((IBlockAccess)world, dx, y + h, dz)) continue;
                world.func_147465_d(dx, y + h, dz, id, BlockRainbowLeaf.LeafMetas.SMALL.ordinal(), 3);
            }
        }
        if (world.func_147439_a(x, y + h + 1, z).canBeReplacedByLeaves((IBlockAccess)world, x, y + h + 1, z)) {
            world.func_147465_d(x, y + h + 1, z, id, BlockRainbowLeaf.LeafMetas.SMALL.ordinal(), 3);
        }
        return true;
    }

    private TreeType getLogType(Random rand) {
        return (TreeType)ReikaJavaLibrary.getRandomListEntry((Random)rand, this.validLogs);
    }
}

