/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.IWG.ColorTreeGenerator;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.InstallationException;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaDyeHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaTreeHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TreeShaper {
    private static final Block leafID = ChromaBlocks.DECAY.getBlockInstance();
    private static final float BASE_VINE_CHANCE = 0.2f;
    private static final float BASE_FERTILE_CHANCE = 0.6f;
    private static final TreeShaper instance = new TreeShaper();
    private final ArrayList<BlockKey> validLogs = new ArrayList();
    private final WeightedRandom<TreeShape> treeRand = new WeightedRandom();

    public boolean isLogTypeEverAllowed(ModWoodList wood) {
        return wood != ModWoodList.BAMBOO && wood != ModWoodList.LIGHTED && wood != ModWoodList.SLIME && wood != ModWoodList.TAINTED;
    }

    private TreeShaper() {
        for (int i = 0; i < ReikaTreeHelper.treeList.length; ++i) {
            ReikaTreeHelper tree = ReikaTreeHelper.treeList[i];
            if (ChromatiCraft.config.shouldGenerateLogType(tree)) {
                this.validLogs.add(tree.getLog());
                ChromatiCraft.logger.log((Object)("Dye Tree Generation with Log Type " + tree.getName() + " logs: Enabled"));
                continue;
            }
            ChromatiCraft.logger.log((Object)("Dye Tree Generation with Log Type " + tree.getName() + " logs: Disabled"));
        }
        for (TreeShape shape : TreeShape.values()) {
            this.treeRand.addEntry((Object)shape, (double)shape.spawnWeight);
        }
        for (int i = 0; i < ModWoodList.woodList.length; ++i) {
            ModWoodList tree = ModWoodList.woodList[i];
            if (this.isLogTypeEverAllowed(tree)) {
                if (tree.exists()) {
                    if (ChromatiCraft.config.shouldGenerateLogType(tree)) {
                        this.validLogs.add(tree.getItem());
                        ChromatiCraft.logger.log((Object)("Dye Tree Generation with Log Type " + tree.getBasicInfo() + ": Enabled"));
                        continue;
                    }
                    ChromatiCraft.logger.log((Object)("Dye Tree Generation with Log Type " + tree.getBasicInfo() + ": Disabled (Config Option)"));
                    continue;
                }
                ChromatiCraft.logger.log((Object)("Dye Tree Generation with Log Type " + tree.getBasicInfo() + ": Disabled (Not Loaded)"));
                continue;
            }
            ChromatiCraft.logger.log((Object)("Dye Tree Generation with Log Type " + tree.getBasicInfo() + ": Disabled (Disallowed)"));
        }
        if (this.validLogs.isEmpty()) {
            throw new InstallationException((DragonAPIMod)ChromatiCraft.instance, "You must enable at least one log type!");
        }
    }

    public static TreeShaper getInstance() {
        return instance;
    }

    public void generateRandomWeightedTree(World world, int x, int y, int z, Random rand, ReikaDyeHelper color, boolean forceGen, float vineChance, float vineFertilityFactor) {
        this.treeRand.setRNG(rand);
        TreeShape shape = (TreeShape)((Object)this.treeRand.getRandomEntry());
        int top = -1;
        switch (shape) {
            case BASIC: {
                top = this.generateNormalTree(world, x, y, z, rand, color, forceGen, vineChance, vineFertilityFactor);
                break;
            }
            case TALL: {
                top = this.generateTallTree(world, x, y, z, rand, color, forceGen, vineChance, vineFertilityFactor);
                break;
            }
            case LUMPY: {
                top = this.generateLumpyTree(world, x, y, z, rand, color, forceGen, vineChance, vineFertilityFactor);
            }
        }
    }

    public BlockKey getLogType(Random rand) {
        return this.validLogs.get(rand.nextInt(this.validLogs.size()));
    }

    private void generateVine(float fertileFactor, World world, int x, int y, int z, int meta, Random rand) {
        boolean below = world.func_147439_a(x, y - 1, z).isAir((IBlockAccess)world, x, y - 1, z);
        int max = ReikaRandomHelper.getRandomBetween((int)1, (int)3, (Random)rand);
        for (int n = 0; n < max && below; ++n) {
            int y0 = y--;
            below = world.func_147439_a(x, y - 1, z).isAir((IBlockAccess)world, x, y - 1, z);
            Block b = fertileFactor > 0.0f && !below && ReikaRandomHelper.doWithChance((double)(0.6f * fertileFactor)) ? ChromaBlocks.FERTILEDYEVINE.getBlockInstance() : ChromaBlocks.DYEVINE.getBlockInstance();
            world.func_147465_d(x, y0, z, b, meta, 2);
        }
    }

    public int generateNormalTree(World world, int x, int y, int z, Random rand, ReikaDyeHelper color, boolean force, float vineChance, float vineFertility) {
        if (force || ColorTreeGenerator.canGenerateTree(world, x, z)) {
            int j;
            int i;
            int meta = color.ordinal();
            BlockKey log = this.getLogType(rand);
            int w = 2;
            int h = 5 + rand.nextInt(3);
            for (i = 0; i < h; ++i) {
                log.place(world, x, y + i, z);
            }
            for (i = -w; i <= w; ++i) {
                for (j = -w; j <= w; ++j) {
                    if (!TreeShaper.canGenerateLeavesAt(world, x + i, y + h - 3, z + j)) continue;
                    world.func_147465_d(x + i, y + h - 3, z + j, leafID, meta, 3);
                    if (!(vineChance > 0.0f) || !ReikaRandomHelper.doWithChance((double)(0.2f * vineChance), (Random)rand)) continue;
                    this.generateVine(vineFertility, world, x + i, y + h - 4, z + j, meta, rand);
                }
            }
            for (i = -w; i <= w; ++i) {
                for (j = -w; j <= w; ++j) {
                    if (!TreeShaper.canGenerateLeavesAt(world, x + i, y + h - 2, z + j)) continue;
                    world.func_147465_d(x + i, y + h - 2, z + j, leafID, meta, 3);
                }
            }
            for (i = -1; i <= 1; ++i) {
                for (j = -1; j <= 1; ++j) {
                    if (!TreeShaper.canGenerateLeavesAt(world, x + i, y + h - 1, z + j)) continue;
                    world.func_147465_d(x + i, y + h - 1, z + j, leafID, meta, 3);
                }
            }
            for (i = -1; i <= 1; ++i) {
                for (j = -1; j <= 1; ++j) {
                    if (i * j != 0) continue;
                    if (!TreeShaper.canGenerateLeavesAt(world, x + i, y + h, z + j)) continue;
                    world.func_147465_d(x + i, y + h, z + j, leafID, meta, 3);
                }
            }
            return y + h - 4;
        }
        return -1;
    }

    public int generateTallTree(World world, int x, int y, int z, Random rand, ReikaDyeHelper color, boolean force, float vineChance, float vineFertility) {
        if (force || ColorTreeGenerator.canGenerateTree(world, x, z)) {
            int j;
            int i;
            int h = 10 + rand.nextInt(3);
            BlockKey log = this.getLogType(rand);
            int meta = color.ordinal();
            int w = 2;
            for (i = 0; i < h; ++i) {
                log.place(world, x, y + i, z);
            }
            for (i = -1; i <= 1; ++i) {
                for (j = -1; j <= 1; ++j) {
                    if (i * j != 0) continue;
                    if (!TreeShaper.canGenerateLeavesAt(world, x + i, y + h - 8, z + j)) continue;
                    world.func_147465_d(x + i, y + h - 8, z + j, leafID, meta, 3);
                    if (!(vineChance > 0.0f) || !ReikaRandomHelper.doWithChance((double)(0.2f * vineChance), (Random)rand)) continue;
                    this.generateVine(vineFertility, world, x + i, y + h - 9, z + j, meta, rand);
                }
            }
            for (i = -1; i <= 1; ++i) {
                for (j = -1; j <= 1; ++j) {
                    if (!TreeShaper.canGenerateLeavesAt(world, x + i, y + h - 7, z + j)) continue;
                    world.func_147465_d(x + i, y + h - 7, z + j, leafID, meta, 3);
                    if (!(vineChance > 0.0f) || !ReikaRandomHelper.doWithChance((double)(0.2f * vineChance), (Random)rand)) continue;
                    this.generateVine(vineFertility, world, x + i, y + h - 8, z + j, meta, rand);
                }
            }
            for (i = -w; i <= w; ++i) {
                for (j = -w; j <= w; ++j) {
                    if (i * j == w * w || i * j == -w * w) continue;
                    if (!TreeShaper.canGenerateLeavesAt(world, x + i, y + h - 6, z + j)) continue;
                    world.func_147465_d(x + i, y + h - 6, z + j, leafID, meta, 3);
                    if (!(vineChance > 0.0f) || !ReikaRandomHelper.doWithChance((double)(0.2f * vineChance), (Random)rand)) continue;
                    this.generateVine(vineFertility, world, x + i, y + h - 7, z + j, meta, rand);
                }
            }
            for (i = -w; i <= w; ++i) {
                for (j = -w; j <= w; ++j) {
                    if (i * j == w * w || i * j == -w * w) continue;
                    if (!TreeShaper.canGenerateLeavesAt(world, x + i, y + h - 5, z + j)) continue;
                    world.func_147465_d(x + i, y + h - 5, z + j, leafID, meta, 3);
                }
            }
            for (i = -1; i <= 1; ++i) {
                for (j = -1; j <= 1; ++j) {
                    if (!TreeShaper.canGenerateLeavesAt(world, x + i, y + h - 4, z + j)) continue;
                    world.func_147465_d(x + i, y + h - 4, z + j, leafID, meta, 3);
                }
            }
            for (i = -w; i <= w; ++i) {
                for (j = -w; j <= w; ++j) {
                    if (i * j == w * w || i * j == -w * w) continue;
                    if (!TreeShaper.canGenerateLeavesAt(world, x + i, y + h - 3, z + j)) continue;
                    world.func_147465_d(x + i, y + h - 3, z + j, leafID, meta, 3);
                }
            }
            for (i = -w; i <= w; ++i) {
                for (j = -w; j <= w; ++j) {
                    if (i * j == w * w || i * j == -w * w) continue;
                    if (!TreeShaper.canGenerateLeavesAt(world, x + i, y + h - 2, z + j)) continue;
                    world.func_147465_d(x + i, y + h - 2, z + j, leafID, meta, 3);
                }
            }
            for (i = -1; i <= 1; ++i) {
                for (j = -1; j <= 1; ++j) {
                    if (!TreeShaper.canGenerateLeavesAt(world, x + i, y + h - 1, z + j)) continue;
                    world.func_147465_d(x + i, y + h - 1, z + j, leafID, meta, 3);
                }
            }
            for (i = -1; i <= 1; ++i) {
                for (j = -1; j <= 1; ++j) {
                    if (i * j != 0) continue;
                    if (!TreeShaper.canGenerateLeavesAt(world, x + i, y + h, z + j)) continue;
                    world.func_147465_d(x + i, y + h, z + j, leafID, meta, 3);
                }
            }
            return y + h - 9;
        }
        return -1;
    }

    public int generateLumpyTree(World world, int x, int y, int z, Random rand, ReikaDyeHelper color, boolean force, float vineChance, float vineFertility) {
        if (force || ColorTreeGenerator.canGenerateTree(world, x, z)) {
            int i;
            int h = 8 + rand.nextInt(4);
            BlockKey log = this.getLogType(rand);
            int meta = color.ordinal();
            for (i = 0; i < h; ++i) {
                log.place(world, x, y + i, z);
            }
            for (i = 1; i < 2; ++i) {
                int m;
                int k;
                int j;
                int dx = x + i;
                int dy = y + h - 2;
                int dz = z;
                log.place(world, dx, dy, dz);
                for (j = -1; j <= 1; ++j) {
                    for (k = -1; k <= 1; ++k) {
                        for (m = -1; m <= 1; ++m) {
                            if (j * k * m != 0) continue;
                            if (!TreeShaper.canGenerateLeavesAt(world, dx + j, dy + k, dz + m)) continue;
                            world.func_147465_d(dx + j, dy + k, dz + m, leafID, meta, 3);
                        }
                    }
                }
                dx = x - i;
                dz = z;
                log.place(world, dx, dy, dz);
                for (j = -1; j <= 1; ++j) {
                    for (k = -1; k <= 1; ++k) {
                        for (m = -1; m <= 1; ++m) {
                            if (j * k * m != 0) continue;
                            if (!TreeShaper.canGenerateLeavesAt(world, dx + j, dy + k, dz + m)) continue;
                            world.func_147465_d(dx + j, dy + k, dz + m, leafID, meta, 3);
                        }
                    }
                }
                dx = x;
                dz = z - i;
                log.place(world, dx, dy, dz);
                for (j = -1; j <= 1; ++j) {
                    for (k = -1; k <= 1; ++k) {
                        for (m = -1; m <= 1; ++m) {
                            if (j * k * m != 0) continue;
                            if (!TreeShaper.canGenerateLeavesAt(world, dx + j, dy + k, dz + m)) continue;
                            world.func_147465_d(dx + j, dy + k, dz + m, leafID, meta, 3);
                        }
                    }
                }
                dx = x;
                dz = z + i;
                log.place(world, dx, dy, dz);
                for (j = -1; j <= 1; ++j) {
                    for (k = -1; k <= 1; ++k) {
                        for (m = -1; m <= 1; ++m) {
                            if (j * k * m != 0) continue;
                            if (!TreeShaper.canGenerateLeavesAt(world, dx + j, dy + k, dz + m)) continue;
                            world.func_147465_d(dx + j, dy + k, dz + m, leafID, meta, 3);
                        }
                    }
                }
                dx = x + i;
                dy = y + h - 6;
                dz = z;
                log.place(world, dx, dy, dz);
                for (j = -1; j <= 1; ++j) {
                    for (k = -1; k <= 1; ++k) {
                        for (m = -1; m <= 1; ++m) {
                            if (j * k * m != 0) continue;
                            if (!TreeShaper.canGenerateLeavesAt(world, dx + j, dy + k, dz + m)) continue;
                            world.func_147465_d(dx + j, dy + k, dz + m, leafID, meta, 3);
                            if (!(vineChance > 0.0f) || !ReikaRandomHelper.doWithChance((double)(0.2f * vineChance), (Random)rand)) continue;
                            this.generateVine(vineFertility, world, dx + j, dy + k - 1, dz + m, meta, rand);
                        }
                    }
                }
                dx = x - i;
                dz = z;
                log.place(world, dx, dy, dz);
                for (j = -1; j <= 1; ++j) {
                    for (k = -1; k <= 1; ++k) {
                        for (m = -1; m <= 1; ++m) {
                            if (j * k * m != 0) continue;
                            if (!TreeShaper.canGenerateLeavesAt(world, dx + j, dy + k, dz + m)) continue;
                            world.func_147465_d(dx + j, dy + k, dz + m, leafID, meta, 3);
                            if (!(vineChance > 0.0f) || !ReikaRandomHelper.doWithChance((double)(0.2f * vineChance), (Random)rand)) continue;
                            this.generateVine(vineFertility, world, dx + j, dy + k - 1, dz + m, meta, rand);
                        }
                    }
                }
                dx = x;
                dz = z - i;
                log.place(world, dx, dy, dz);
                for (j = -1; j <= 1; ++j) {
                    for (k = -1; k <= 1; ++k) {
                        for (m = -1; m <= 1; ++m) {
                            if (j * k * m != 0) continue;
                            if (!TreeShaper.canGenerateLeavesAt(world, dx + j, dy + k, dz + m)) continue;
                            world.func_147465_d(dx + j, dy + k, dz + m, leafID, meta, 3);
                            if (!(vineChance > 0.0f) || !ReikaRandomHelper.doWithChance((double)(0.2f * vineChance), (Random)rand)) continue;
                            this.generateVine(vineFertility, world, dx + j, dy + k - 1, dz + m, meta, rand);
                        }
                    }
                }
                dx = x;
                dz = z + i;
                log.place(world, dx, dy, dz);
                for (j = -1; j <= 1; ++j) {
                    for (k = -1; k <= 1; ++k) {
                        for (m = -1; m <= 1; ++m) {
                            if (j * k * m != 0) continue;
                            if (!TreeShaper.canGenerateLeavesAt(world, dx + j, dy + k, dz + m)) continue;
                            world.func_147465_d(dx + j, dy + k, dz + m, leafID, meta, 3);
                            if (!(vineChance > 0.0f) || !ReikaRandomHelper.doWithChance((double)(0.2f * vineChance), (Random)rand)) continue;
                            this.generateVine(vineFertility, world, dx + j, dy + k - 1, dz + m, meta, rand);
                        }
                    }
                }
            }
            int dy = y + h - 4;
            for (int i2 = 1; i2 < 2; ++i2) {
                if (TreeShaper.canGenerateLeavesAt(world, x + i2, dy, z)) {
                    world.func_147465_d(x + i2, dy, z, leafID, meta, 3);
                }
                if (TreeShaper.canGenerateLeavesAt(world, x - i2, dy, z)) {
                    world.func_147465_d(x - i2, dy, z, leafID, meta, 3);
                }
                if (TreeShaper.canGenerateLeavesAt(world, x, dy, z + i2)) {
                    world.func_147465_d(x, dy, z + i2, leafID, meta, 3);
                }
                if (!TreeShaper.canGenerateLeavesAt(world, x, dy, z - i2)) continue;
                world.func_147465_d(x, dy, z - i2, leafID, meta, 3);
            }
            dy = y + h;
            for (int k = -1; k <= 1; ++k) {
                for (int m = -1; m <= 1; ++m) {
                    if (k * m != 0) continue;
                    if (!TreeShaper.canGenerateLeavesAt(world, x + k, dy, z + m)) continue;
                    world.func_147465_d(x + k, dy, z + m, leafID, meta, 3);
                }
            }
            return y + h - 8;
        }
        return -1;
    }

    public static boolean canGenerateLeavesAt(World world, int x, int y, int z) {
        boolean soft = ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)x, (int)y, (int)z);
        boolean leaves = world.func_147439_a(x, y, z) == Blocks.field_150362_t || world.func_147439_a(x, y, z) == Blocks.field_150361_u;
        return soft || leaves;
    }

    private static enum TreeShape {
        BASIC(60),
        TALL(30),
        LUMPY(10);

        private final int spawnWeight;

        private TreeShape(int weight) {
            this.spawnWeight = weight;
        }
    }
}

