/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.item;

import appeng.api.config.AccessRestriction;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItemManager;
import java.util.ArrayList;
import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.electricity.ElectricConversions;
import net.machinemuse.api.electricity.IMuseElectricItem;
import net.machinemuse.numina.general.MuseMathUtils;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.powersuits.item.IModularItemBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseCommonStrings;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.MuseStringUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.api.energy.IEnergyContainerItem", modid="CoFHAPI|energy", striprefs=true), @Optional.Interface(iface="ic2.api.item.IElectricItemManager", modid="IC2", striprefs=true), @Optional.Interface(iface="ic2.api.item.ISpecialElectricItem", modid="IC2", striprefs=true), @Optional.Interface(iface="appeng.api.implementations.items.IAEItemPowerStorage", modid="appliedenergistics2", striprefs=true)})
public abstract class ItemElectricArmor
extends ItemArmor
implements IModularItemBase,
IMuseElectricItem {
    public ItemElectricArmor(ItemArmor.ArmorMaterial material, int index1, int index2) {
        super(material, index1, index2);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack itemStack, int par2) {
        return this.getColorFromItemStack(itemStack).getInt();
    }

    @Override
    public Colour getGlowFromItemStack(ItemStack itemStack) {
        if (!ModuleManager.itemHasActiveModule(itemStack, "Glow Module")) {
            return Colour.LIGHTBLUE;
        }
        double computedred = ModuleManager.computeModularProperty(itemStack, "Red Glow");
        double computedgreen = ModuleManager.computeModularProperty(itemStack, "Green Glow");
        double computedblue = ModuleManager.computeModularProperty(itemStack, "Blue Glow");
        return new Colour(MuseMathUtils.clampDouble((double)computedred, (double)0.0, (double)1.0), MuseMathUtils.clampDouble((double)computedgreen, (double)0.0, (double)1.0), MuseMathUtils.clampDouble((double)computedblue, (double)0.0, (double)1.0), 0.8);
    }

    @Override
    public Colour getColorFromItemStack(ItemStack itemStack) {
        if (!ModuleManager.itemHasActiveModule(itemStack, "Custom Colour Module")) {
            return Colour.WHITE;
        }
        double computedred = ModuleManager.computeModularProperty(itemStack, "Red Tint");
        double computedgreen = ModuleManager.computeModularProperty(itemStack, "Green Tint");
        double computedblue = ModuleManager.computeModularProperty(itemStack, "Blue Tint");
        return new Colour(MuseMathUtils.clampDouble((double)computedred, (double)0.0, (double)1.0), MuseMathUtils.clampDouble((double)computedgreen, (double)0.0, (double)1.0), MuseMathUtils.clampDouble((double)computedblue, (double)0.0, (double)1.0), 1.0);
    }

    public boolean func_77623_v() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List currentTipList, boolean advancedToolTips) {
        MuseCommonStrings.addInformation(itemStack, player, currentTipList, advancedToolTips);
    }

    @Override
    public String formatInfo(String string, double value) {
        return string + '\t' + MuseStringUtils.formatNumberShort(value);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<String> getLongInfo(EntityPlayer player, ItemStack itemStack) {
        ArrayList<String> info = new ArrayList<String>();
        info.add("Detailed Summary");
        info.add(this.formatInfo("Armor", this.getArmorDouble(player, itemStack)));
        info.add(this.formatInfo("Energy Storage", this.getCurrentEnergy(itemStack)) + 'J');
        info.add(this.formatInfo("Weight", MuseCommonStrings.getTotalWeight(itemStack)) + 'g');
        return info;
    }

    @Override
    public double getArmorDouble(EntityPlayer player, ItemStack itemStack) {
        return 0.0;
    }

    @Override
    public double getPlayerEnergy(EntityPlayer player) {
        return ElectricItemUtils.getPlayerEnergy(player);
    }

    @Override
    public void drainPlayerEnergy(EntityPlayer player, double drainEnergy) {
        ElectricItemUtils.drainPlayerEnergy(player, drainEnergy);
    }

    @Override
    public void givePlayerEnergy(EntityPlayer player, double joulesToGive) {
        ElectricItemUtils.givePlayerEnergy(player, joulesToGive);
    }

    @Override
    public int getMaxDamage(ItemStack itemStack) {
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getToolTip(ItemStack itemStack) {
        return null;
    }

    @Override
    public double getCurrentEnergy(ItemStack stack) {
        return MuseItemUtils.getDoubleOrZero(stack, "Current Energy");
    }

    @Override
    public double getMaxEnergy(ItemStack stack) {
        return ModuleManager.computeModularProperty(stack, "Maximum Energy");
    }

    @Override
    public void setCurrentEnergy(ItemStack stack, double energy) {
        MuseItemUtils.setDoubleOrRemove(stack, "Current Energy", Math.min(energy, this.getMaxEnergy(stack)));
    }

    @Override
    public double drainEnergyFrom(ItemStack stack, double requested) {
        double available = this.getCurrentEnergy(stack);
        if (available > requested) {
            this.setCurrentEnergy(stack, available - requested);
            return requested;
        }
        this.setCurrentEnergy(stack, 0.0);
        return available;
    }

    @Override
    public double giveEnergyTo(ItemStack stack, double provided) {
        double max;
        double available = this.getCurrentEnergy(stack);
        if (available + provided < (max = this.getMaxEnergy(stack))) {
            this.setCurrentEnergy(stack, available + provided);
            return provided;
        }
        this.setCurrentEnergy(stack, max);
        return max - available;
    }

    @Override
    @Optional.Method(modid="IC2")
    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    @Override
    @Optional.Method(modid="IC2")
    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    @Override
    @Optional.Method(modid="IC2")
    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    @Override
    @Optional.Method(modid="IC2")
    public double getMaxCharge(ItemStack itemStack) {
        return ElectricConversions.museEnergyToEU(this.getMaxEnergy(itemStack));
    }

    @Override
    @Optional.Method(modid="IC2")
    public int getTier(ItemStack itemStack) {
        return ElectricConversions.getTier(itemStack);
    }

    @Override
    @Optional.Method(modid="IC2")
    public double getTransferLimit(ItemStack itemStack) {
        return ElectricConversions.museEnergyToEU(Math.sqrt(this.getMaxEnergy(itemStack)));
    }

    @Override
    @Optional.Method(modid="IC2")
    public double charge(ItemStack itemStack, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        double current = this.getCurrentEnergy(itemStack);
        double transfer = ignoreTransferLimit || amount < this.getTransferLimit(itemStack) ? ElectricConversions.museEnergyFromEU(amount) : this.getTransferLimit(itemStack);
        double given = this.giveEnergyTo(itemStack, transfer);
        if (simulate) {
            this.setCurrentEnergy(itemStack, current);
        }
        return ElectricConversions.museEnergyToEU(given);
    }

    @Override
    @Optional.Method(modid="IC2")
    public double discharge(ItemStack itemStack, double amount, int tier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        double current = this.getCurrentEnergy(itemStack);
        double transfer = ignoreTransferLimit || amount < this.getTransferLimit(itemStack) ? ElectricConversions.museEnergyFromEU(amount) : this.getTransferLimit(itemStack);
        double taken = this.drainEnergyFrom(itemStack, transfer);
        if (simulate) {
            this.setCurrentEnergy(itemStack, current);
        }
        return ElectricConversions.museEnergyToEU(taken);
    }

    @Override
    @Optional.Method(modid="IC2")
    public double getCharge(ItemStack itemStack) {
        return ElectricConversions.museEnergyToEU(this.getCurrentEnergy(itemStack));
    }

    @Override
    @Optional.Method(modid="IC2")
    public boolean canUse(ItemStack itemStack, double amount) {
        return ElectricConversions.museEnergyFromEU(amount) < this.getCurrentEnergy(itemStack);
    }

    @Override
    @Optional.Method(modid="IC2")
    public boolean use(ItemStack itemStack, double amount, EntityLivingBase entity) {
        return ElectricItem.rawManager.use(itemStack, ElectricConversions.museEnergyToEU(amount), entity);
    }

    @Override
    @Optional.Method(modid="IC2")
    public void chargeFromArmor(ItemStack itemStack, EntityLivingBase entity) {
        ElectricItem.rawManager.chargeFromArmor(itemStack, entity);
    }

    @Override
    @Optional.Method(modid="IC2")
    public IElectricItemManager getManager(ItemStack itemStack) {
        return this;
    }

    @Override
    public int receiveEnergy(ItemStack itemStack, int energy, boolean simulate) {
        double current = this.getCurrentEnergy(itemStack);
        double receivedME = ElectricConversions.museEnergyFromRF(energy);
        double eatenME = this.giveEnergyTo(itemStack, receivedME);
        if (simulate) {
            this.setCurrentEnergy(itemStack, current);
        }
        return ElectricConversions.museEnergyToRF(eatenME);
    }

    @Override
    public int extractEnergy(ItemStack itemStack, int energy, boolean simulate) {
        double current = this.getCurrentEnergy(itemStack);
        double requesteddME = ElectricConversions.museEnergyFromRF(energy);
        double takenME = this.drainEnergyFrom(itemStack, requesteddME);
        if (simulate) {
            this.setCurrentEnergy(itemStack, current);
        }
        return ElectricConversions.museEnergyToRF(takenME);
    }

    @Override
    public int getEnergyStored(ItemStack itemStack) {
        return ElectricConversions.museEnergyToRF(this.getCurrentEnergy(itemStack));
    }

    @Override
    public int getMaxEnergyStored(ItemStack itemStack) {
        return ElectricConversions.museEnergyToRF(this.getMaxEnergy(itemStack));
    }

    @Override
    public double injectAEPower(ItemStack itemStack, double ae) {
        double current = this.getCurrentEnergy(itemStack);
        double recieved = ElectricConversions.museEnergyFromAE(ae);
        this.setCurrentEnergy(itemStack, current);
        return ElectricConversions.museEnergyToAE(recieved);
    }

    @Override
    public double extractAEPower(ItemStack itemStack, double ae) {
        double current = this.getCurrentEnergy(itemStack);
        double taken = ElectricConversions.museEnergyFromAE(ae);
        this.setCurrentEnergy(itemStack, current);
        return ElectricConversions.museEnergyToAE(taken);
    }

    @Override
    public double getAEMaxPower(ItemStack itemStack) {
        return ElectricConversions.museEnergyToAE(this.getCurrentEnergy(itemStack));
    }

    @Override
    public double getAECurrentPower(ItemStack itemStack) {
        return ElectricConversions.museEnergyToAE(this.getCurrentEnergy(itemStack));
    }

    @Override
    public AccessRestriction getPowerFlow(ItemStack itemStack) {
        return AccessRestriction.READ_WRITE;
    }
}

