/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.energy;

import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class CoalGenerator
extends PowerModuleBase
implements IPlayerTickModule,
IToggleableModule {
    public static final String MODULE_COAL_GEN = "Coal Generator";
    public static final String COAL_ENERGY_GEN = "Energy per coal";
    public static final String COAL_HEAT_GEN = "Heat Generation";
    public static final String MAX_COAL_STORAGE = "Maximum storage amount";

    public CoalGenerator(List<IModularItem> validItems) {
        super(validItems);
        this.addBaseProperty(MAX_COAL_STORAGE, 128.0);
        this.addBaseProperty(COAL_HEAT_GEN, 2.5);
        this.addBaseProperty("Weight", 500.0);
        this.addBaseProperty(COAL_ENERGY_GEN, 300.0);
        this.addInstallCost(new ItemStack(Blocks.field_150460_al));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.controlCircuit, 1));
    }

    @Override
    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        InventoryPlayer inv = player.field_71071_by;
        int coalNeeded = (int)ModuleManager.computeModularProperty(item, MAX_COAL_STORAGE) - MuseItemUtils.getCoalLevel(item);
        if (coalNeeded > 0) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack == null || stack.func_77973_b() != Items.field_151044_h) continue;
                int loopTimes = coalNeeded < stack.field_77994_a ? coalNeeded : stack.field_77994_a;
                for (int i2 = 0; i2 < loopTimes; ++i2) {
                    MuseItemUtils.setCoalLevel(item, MuseItemUtils.getCoalLevel(item) + 1);
                    player.field_71071_by.func_70298_a(i, 1);
                    if (stack.field_77994_a != 0) continue;
                    player.field_71071_by.func_70299_a(i, null);
                }
                if (!(ModuleManager.computeModularProperty(item, MAX_COAL_STORAGE) - (double)MuseItemUtils.getCoalLevel(item) < 1.0)) continue;
                i = inv.func_70302_i_() + 1;
            }
        }
    }

    @Override
    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
    }

    @Override
    public String getTextureFile() {
        return "coalgen";
    }

    @Override
    public String getCategory() {
        return "Energy";
    }

    @Override
    public String getDataName() {
        return MODULE_COAL_GEN;
    }

    @Override
    public String getUnlocalizedName() {
        return "coalGenerator";
    }

    @Override
    public String getDescription() {
        return "Generate power with solid fuels";
    }
}

