/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.item;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import openblocks.client.renderer.block.BlockTankRenderer;
import openblocks.client.renderer.tileentity.TileEntityTankRenderer;
import openblocks.client.renderer.tileentity.tank.ITankRenderFluidData;
import openblocks.common.tileentity.TileEntityTank;
import openmods.utils.Diagonal;
import org.lwjgl.opengl.GL11;

public class ItemRendererTank
implements IItemRenderer {
    private FluidTank tank = new FluidTank(TileEntityTank.getTankCapacity());

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        FluidStack stack;
        GL11.glPushMatrix();
        if (type == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
        } else if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glTranslated((double)0.0, (double)-0.1, (double)0.0);
        }
        BlockTankRenderer.EMPTY_FRAME.render();
        NBTTagCompound tag = item.func_77978_p();
        if (tag != null && tag.func_74764_b("tank") && (stack = this.readFluid(tag)) != null) {
            final float height = (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity();
            TileEntityTankRenderer.renderFluid(new ITankRenderFluidData(){

                @Override
                public boolean shouldRenderFluidWall(ForgeDirection side) {
                    return true;
                }

                @Override
                public boolean hasFluid() {
                    return true;
                }

                @Override
                public FluidStack getFluid() {
                    return stack;
                }

                @Override
                public float getCornerFluidLevel(Diagonal diagonal, float time) {
                    return height;
                }

                @Override
                public float getCenterFluidLevel(float time) {
                    return height;
                }
            }, 0.0f);
        }
        GL11.glPopMatrix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FluidStack readFluid(NBTTagCompound tag) {
        FluidTank fluidTank = this.tank;
        synchronized (fluidTank) {
            this.tank.setFluid(null);
            this.tank.readFromNBT(tag.func_74775_l("tank"));
            return this.tank.getFluid();
        }
    }
}

