/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.modhelpers.vanilla;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.FertilizerType;
import powercrystals.minefactoryreloaded.api.HarvestType;
import powercrystals.minefactoryreloaded.api.MobDrop;
import powercrystals.minefactoryreloaded.farmables.drinkhandlers.DrinkHandlerLava;
import powercrystals.minefactoryreloaded.farmables.drinkhandlers.DrinkHandlerWater;
import powercrystals.minefactoryreloaded.farmables.egghandlers.VanillaEggHandler;
import powercrystals.minefactoryreloaded.farmables.fertilizables.FertilizableCocoa;
import powercrystals.minefactoryreloaded.farmables.fertilizables.FertilizableCropPlant;
import powercrystals.minefactoryreloaded.farmables.fertilizables.FertilizableGrass;
import powercrystals.minefactoryreloaded.farmables.fertilizables.FertilizableNetherWart;
import powercrystals.minefactoryreloaded.farmables.fertilizables.FertilizableStandard;
import powercrystals.minefactoryreloaded.farmables.fertilizables.FertilizableStemPlants;
import powercrystals.minefactoryreloaded.farmables.fertilizables.FertilizerStandard;
import powercrystals.minefactoryreloaded.farmables.fruits.FruitCocoa;
import powercrystals.minefactoryreloaded.farmables.grindables.GrindableEnderman;
import powercrystals.minefactoryreloaded.farmables.grindables.GrindableSlime;
import powercrystals.minefactoryreloaded.farmables.grindables.GrindableStandard;
import powercrystals.minefactoryreloaded.farmables.grindables.GrindableZombiePigman;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableCocoa;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableCropPlant;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableGourd;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableMushroom;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableShrub;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableStandard;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableStemPlant;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableTreeLeaves;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableVine;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableWood;
import powercrystals.minefactoryreloaded.farmables.plantables.PlantableCocoa;
import powercrystals.minefactoryreloaded.farmables.plantables.PlantableCropPlant;
import powercrystals.minefactoryreloaded.farmables.plantables.PlantableNetherWart;
import powercrystals.minefactoryreloaded.farmables.plantables.PlantableSapling;
import powercrystals.minefactoryreloaded.farmables.plantables.PlantableStandard;
import powercrystals.minefactoryreloaded.farmables.ranchables.RanchableChicken;
import powercrystals.minefactoryreloaded.farmables.ranchables.RanchableCow;
import powercrystals.minefactoryreloaded.farmables.ranchables.RanchableMooshroom;
import powercrystals.minefactoryreloaded.farmables.ranchables.RanchableSheep;
import powercrystals.minefactoryreloaded.farmables.ranchables.RanchableSquid;
import powercrystals.minefactoryreloaded.farmables.spawnhandlers.SpawnableEnderman;
import powercrystals.minefactoryreloaded.farmables.spawnhandlers.SpawnableHorse;
import powercrystals.minefactoryreloaded.modhelpers.vanilla.VanillaMobProvider;
import powercrystals.minefactoryreloaded.setup.MFRConfig;

@Mod(modid="MineFactoryReloaded|CompatVanilla", name="MFR Compat: Vanilla", version="1.7.10R2.8.1", dependencies="after:MineFactoryReloaded", customProperties={@Mod.CustomProperty(k="cofhversion", v="true")})
public class Vanilla {
    private static final int black = 15;
    private static final int red = 14;
    private static final int green = 13;
    private static final int brown = 12;
    private static final int blue = 11;
    private static final int purple = 10;
    private static final int cyan = 9;
    private static final int silver = 8;
    private static final int gray = 7;
    private static final int pink = 6;
    private static final int lime = 5;
    private static final int yellow = 4;
    private static final int lightBlue = 3;
    private static final int magenta = 2;
    private static final int orange = 1;
    private static final int white = 0;

    @Mod.EventHandler
    public void load(FMLInitializationEvent fMLInitializationEvent) {
        MFRRegistry.registerPlantable(new PlantableSapling(Blocks.field_150345_g));
        MFRRegistry.registerPlantable(new PlantableStandard((Block)Blocks.field_150338_P));
        MFRRegistry.registerPlantable(new PlantableStandard((Block)Blocks.field_150337_Q));
        MFRRegistry.registerPlantable(new PlantableCropPlant(Items.field_151080_bb, Blocks.field_150393_bb));
        MFRRegistry.registerPlantable(new PlantableCropPlant(Items.field_151081_bc, Blocks.field_150394_bc));
        MFRRegistry.registerPlantable(new PlantableCropPlant(Items.field_151014_N, Blocks.field_150464_aj));
        MFRRegistry.registerPlantable(new PlantableCropPlant(Items.field_151172_bF, Blocks.field_150459_bM));
        MFRRegistry.registerPlantable(new PlantableCropPlant(Items.field_151174_bG, Blocks.field_150469_bN));
        MFRRegistry.registerPlantable(new PlantableNetherWart());
        MFRRegistry.registerPlantable(new PlantableCocoa(Items.field_151100_aR, Blocks.field_150375_by, 3));
        MFRRegistry.registerHarvestable(new HarvestableWood(Blocks.field_150364_r));
        MFRRegistry.registerHarvestable(new HarvestableWood(Blocks.field_150363_s));
        MFRRegistry.registerHarvestable(new HarvestableTreeLeaves((Block)Blocks.field_150362_t));
        MFRRegistry.registerHarvestable(new HarvestableTreeLeaves((Block)Blocks.field_150361_u));
        MFRRegistry.registerHarvestable(new HarvestableStandard(Blocks.field_150436_aH, HarvestType.LeaveBottom));
        MFRRegistry.registerHarvestable(new HarvestableStandard(Blocks.field_150434_aF, HarvestType.LeaveBottom));
        MFRRegistry.registerHarvestable(new HarvestableStandard((Block)Blocks.field_150328_O, HarvestType.Normal));
        MFRRegistry.registerHarvestable(new HarvestableStandard((Block)Blocks.field_150327_N, HarvestType.Normal));
        MFRRegistry.registerHarvestable(new HarvestableShrub((Block)Blocks.field_150329_H));
        MFRRegistry.registerHarvestable(new HarvestableShrub((Block)Blocks.field_150330_I));
        MFRRegistry.registerHarvestable(new HarvestableShrub((Block)Blocks.field_150398_cm));
        MFRRegistry.registerHarvestable(new HarvestableStandard(Blocks.field_150420_aW, HarvestType.Tree));
        MFRRegistry.registerHarvestable(new HarvestableStandard(Blocks.field_150419_aX, HarvestType.Tree));
        MFRRegistry.registerHarvestable(new HarvestableMushroom((Block)Blocks.field_150338_P));
        MFRRegistry.registerHarvestable(new HarvestableMushroom((Block)Blocks.field_150337_Q));
        MFRRegistry.registerHarvestable(new HarvestableStemPlant(Blocks.field_150393_bb, Blocks.field_150423_aK));
        MFRRegistry.registerHarvestable(new HarvestableStemPlant(Blocks.field_150394_bc, Blocks.field_150440_ba));
        MFRRegistry.registerHarvestable(new HarvestableGourd(Blocks.field_150423_aK));
        MFRRegistry.registerHarvestable(new HarvestableGourd(Blocks.field_150440_ba));
        MFRRegistry.registerHarvestable(new HarvestableCropPlant(Blocks.field_150464_aj, 7));
        MFRRegistry.registerHarvestable(new HarvestableCropPlant(Blocks.field_150459_bM, 7));
        MFRRegistry.registerHarvestable(new HarvestableCropPlant(Blocks.field_150469_bN, 7));
        MFRRegistry.registerHarvestable(new HarvestableCropPlant(Blocks.field_150388_bm, 3));
        MFRRegistry.registerHarvestable(new HarvestableVine(Blocks.field_150395_bd));
        MFRRegistry.registerHarvestable(new HarvestableCocoa(Blocks.field_150375_by));
        MFRRegistry.registerFertilizable(new FertilizableStandard((IGrowable)Blocks.field_150345_g));
        MFRRegistry.registerFertilizable(new FertilizableCropPlant((IGrowable)Blocks.field_150464_aj, 7));
        MFRRegistry.registerFertilizable(new FertilizableCropPlant((IGrowable)Blocks.field_150459_bM, 7));
        MFRRegistry.registerFertilizable(new FertilizableCropPlant((IGrowable)Blocks.field_150469_bN, 7));
        MFRRegistry.registerFertilizable(new FertilizableStandard((IGrowable)Blocks.field_150338_P));
        MFRRegistry.registerFertilizable(new FertilizableStandard((IGrowable)Blocks.field_150337_Q));
        MFRRegistry.registerFertilizable(new FertilizableStemPlants((IGrowable)Blocks.field_150393_bb));
        MFRRegistry.registerFertilizable(new FertilizableStemPlants((IGrowable)Blocks.field_150394_bc));
        MFRRegistry.registerFertilizable(new FertilizableNetherWart());
        MFRRegistry.registerFertilizable(new FertilizableCocoa(Blocks.field_150375_by));
        MFRRegistry.registerFertilizable(new FertilizableGrass());
        if (MFRConfig.enableBonemealFertilizing.getBoolean(false)) {
            MFRRegistry.registerFertilizer(new FertilizerStandard(Items.field_151100_aR, 15));
        } else {
            MFRRegistry.registerFertilizer(new FertilizerStandard(Items.field_151100_aR, 15, FertilizerType.Grass));
        }
        MFRRegistry.registerRanchable(new RanchableCow());
        MFRRegistry.registerRanchable(new RanchableMooshroom());
        MFRRegistry.registerRanchable(new RanchableSheep());
        MFRRegistry.registerRanchable(new RanchableSquid());
        MFRRegistry.registerRanchable(new RanchableChicken());
        MFRRegistry.registerGrinderBlacklist(EntityDragon.class);
        MFRRegistry.registerGrinderBlacklist(EntityWither.class);
        MFRRegistry.registerGrinderBlacklist(EntityVillager.class);
        MFRRegistry.registerGrindable(new GrindableStandard(EntityChicken.class, new MobDrop[]{new MobDrop(30, null), new MobDrop(10, new ItemStack(Items.field_151110_aK))}, false));
        MFRRegistry.registerGrindable(new GrindableStandard(EntityOcelot.class, new MobDrop[]{new MobDrop(10, new ItemStack(Items.field_151115_aP)), new MobDrop(10, new ItemStack(Items.field_151007_F))}));
        MFRRegistry.registerGrindable(new GrindableStandard(EntityWolf.class, new ItemStack(Items.field_151103_aS)));
        MFRRegistry.registerGrindable(new GrindableZombiePigman());
        MFRRegistry.registerGrindable(new GrindableEnderman());
        MFRRegistry.registerGrindable(new GrindableSlime(EntitySlime.class, new ItemStack(Items.field_151123_aH), 1));
        MFRRegistry.registerGrindable(new GrindableSlime(EntityMagmaCube.class, new ItemStack(Items.field_151064_bs), 1){

            @Override
            protected boolean shouldDrop(EntitySlime entitySlime) {
                return entitySlime.func_70809_q() <= this.dropSize;
            }
        });
        MFRRegistry.registerSludgeDrop(50, new ItemStack((Block)Blocks.field_150354_m));
        MFRRegistry.registerSludgeDrop(30, new ItemStack(Blocks.field_150435_aG));
        MFRRegistry.registerSludgeDrop(30, new ItemStack(Blocks.field_150346_d, 1, 1));
        MFRRegistry.registerSludgeDrop(10, new ItemStack(Blocks.field_150346_d));
        MFRRegistry.registerSludgeDrop(10, new ItemStack(Blocks.field_150351_n));
        MFRRegistry.registerSludgeDrop(5, new ItemStack((Block)Blocks.field_150354_m, 1, 1));
        MFRRegistry.registerSludgeDrop(5, new ItemStack(Blocks.field_150425_aM));
        MFRRegistry.registerSludgeDrop(3, new ItemStack((Block)Blocks.field_150391_bh));
        MFRRegistry.registerSludgeDrop(2, new ItemStack(Blocks.field_150346_d, 1, 2));
        MFRRegistry.registerSludgeDrop(1, new ItemStack(Blocks.field_150424_aL));
        MFRRegistry.registerMobEggHandler(new VanillaEggHandler());
        MFRRegistry.registerRubberTreeBiome("Swampland");
        MFRRegistry.registerRubberTreeBiome("Swampland M");
        MFRRegistry.registerRubberTreeBiome("Forest");
        MFRRegistry.registerRubberTreeBiome("Flower Forest");
        MFRRegistry.registerRubberTreeBiome("ForestHills");
        MFRRegistry.registerRubberTreeBiome("ForestHills M");
        MFRRegistry.registerRubberTreeBiome("Roofed Forest");
        MFRRegistry.registerRubberTreeBiome("Roofed Forest M");
        MFRRegistry.registerRubberTreeBiome("Taiga");
        MFRRegistry.registerRubberTreeBiome("Taiga M");
        MFRRegistry.registerRubberTreeBiome("TaigaHills");
        MFRRegistry.registerRubberTreeBiome("TaigaHills M");
        MFRRegistry.registerRubberTreeBiome("Cold Taiga");
        MFRRegistry.registerRubberTreeBiome("Cold Taiga M");
        MFRRegistry.registerRubberTreeBiome("Cold Taiga Hills");
        MFRRegistry.registerRubberTreeBiome("Cold Taiga Hills M");
        MFRRegistry.registerRubberTreeBiome("Mega Taiga");
        MFRRegistry.registerRubberTreeBiome("Mega Spruce Taiga");
        MFRRegistry.registerRubberTreeBiome("Mega Taiga Hills");
        MFRRegistry.registerRubberTreeBiome("Mega Spruce Taiga Hills");
        MFRRegistry.registerRubberTreeBiome("Jungle");
        MFRRegistry.registerRubberTreeBiome("Jungle M");
        MFRRegistry.registerRubberTreeBiome("JungleHills");
        MFRRegistry.registerRubberTreeBiome("JungleHills M");
        MFRRegistry.registerRubberTreeBiome("JungleEdge");
        MFRRegistry.registerRubberTreeBiome("JungleEdge M");
        MFRRegistry.registerSafariNetBlacklist(EntityDragon.class);
        MFRRegistry.registerSafariNetBlacklist(EntityWither.class);
        MFRRegistry.registerRandomMobProvider(new VanillaMobProvider());
        MFRRegistry.registerLiquidDrinkHandler("water", new DrinkHandlerWater());
        MFRRegistry.registerLiquidDrinkHandler("lava", new DrinkHandlerLava());
        MFRRegistry.registerFruitLogBlock(Blocks.field_150364_r);
        MFRRegistry.registerFruit(new FruitCocoa(Blocks.field_150375_by));
        MFRRegistry.registerSpawnHandler(new SpawnableHorse());
        MFRRegistry.registerSpawnHandler(new SpawnableEnderman());
    }

    @Mod.EventHandler
    public void postLoad(FMLPostInitializationEvent fMLPostInitializationEvent) {
        this.registerOreDictLaserOre(175, "Coal", 15, false);
        this.registerOreDictLaserOre(150, "Iron", 12, false);
        this.registerOreDictLaserOre(100, "Redstone", 14, false);
        this.registerOreDictLaserOre(100, "Nikolite", 3, false);
        this.registerOreDictLaserOre(100, "oreSalt", 0, "oreNetherSalt");
        this.registerOreDictLaserOre(90, "Copper", 1, false);
        this.registerOreDictLaserOre(85, "Tin", 8, false);
        this.registerOreDictLaserOre(85, "oreCheese", 4, null);
        this.registerOreDictLaserOre(85, "Force", 4, true);
        this.registerOreDictLaserOre(80, "glowstone", 4, null);
        this.registerOreDictLaserOre(80, "Lapis", 11, true);
        this.registerOreDictLaserOre(70, "Gold", 4, false);
        this.registerOreDictLaserOre(70, "oreQuartz", 0, null);
        this.registerOreDictLaserOre(60, "Lead", 10, false);
        this.registerOreDictLaserOre(60, "oreZinc", 0, "oreSphalerite", 1);
        this.registerOreDictLaserOre(60, "NaturalAluminum", 0, false);
        this.registerOreDictLaserOre(60, "Aluminium", 0, false);
        this.registerOreDictLaserOre(60, "Aluminum", 0, false);
        this.registerOreDictLaserOre(60, "oreDark", 15, true);
        this.registerOreDictLaserOre(60, "oreSodalite", 11, null);
        this.registerOreDictLaserOre(55, "Mithril", 11, false);
        this.registerOreDictLaserOre(55, "Steel", 7, false);
        this.registerOreDictLaserOre(55, "oreCassiterite", 15, null);
        this.registerOreDictLaserOre(55, "Diamond", 3, true);
        this.registerOreDictLaserOre(55, "oreDesh", 7, null);
        this.registerOreDictLaserOre(50, "CertusQuartz", 9, true);
        this.registerOreDictLaserOre(50, "Osmium", 3, false);
        this.registerOreDictLaserOre(50, "oreBauxite", 12, null);
        this.registerOreDictLaserOre(45, "Rutile", 15, false);
        this.registerOreDictLaserOre(45, "Titanium", 15, false);
        this.registerOreDictLaserOre(45, "Tungsten", 15, false);
        this.registerOreDictLaserOre(45, "oreTungstate", 15, "oreNetherTungsten");
        this.registerOreDictLaserOre(45, "orePyrite", 1, null);
        this.registerOreDictLaserOre(45, "FzDarkIron", 10, false);
        this.registerOreDictLaserOre(40, "Tennantite", 5, false);
        this.registerOreDictLaserOre(40, "Nickel", 8, false);
        this.registerOreDictLaserOre(40, "Sulfur", 4, false);
        this.registerOreDictLaserOre(40, "Saltpeter", 0, false);
        this.registerOreDictLaserOre(35, "Emerald", 5, true);
        this.registerOreDictLaserOre(35, "Ruby", 14, true);
        this.registerOreDictLaserOre(35, "Sapphire", 11, true);
        this.registerOreDictLaserOre(35, "GreenSapphire", 13, true);
        this.registerOreDictLaserOre(35, "Peridot", 13, true);
        this.registerOreDictLaserOre(35, "Topaz", 12, true);
        this.registerOreDictLaserOre(35, "Tanzanite", 10, true);
        this.registerOreDictLaserOre(35, "Malachite", 9, true);
        this.registerOreDictLaserOre(35, "Amber", 1, true);
        this.registerOreDictLaserOre(30, "Adamantium", 13, false);
        this.registerOreDictLaserOre(30, "Silver", 7, false);
        this.registerOreDictLaserOre(30, "Galena", 10, false);
        this.registerOreDictLaserOre(30, "Apatite", 11, true);
        this.registerOreDictLaserOre(30, "Silicon", 15, false);
        this.registerOreDictLaserOre(25, "Magnesium", 8, false);
        this.registerOreDictLaserOre(25, "Amethyst", 2, true);
        this.registerOreDictLaserOre(20, "Uranium", 5, false);
        this.registerOreDictLaserOre(20, "orePitchblende", 15, "oreNetherUranium", 5);
        this.registerOreDictLaserOre(20, "oreFirestone", 14, null);
        this.registerOreDictLaserOre(20, "MonazitOre", 13, null);
        this.registerOreDictLaserOre(15, "Cinnabar", 14, true);
        this.registerOreDictLaserOre(15, "Platinum", 3, false);
        this.registerOreDictLaserOre(15, "oreCooperite", 4, "oreNetherPlatinum", 3);
        this.registerOreDictLaserOre(10, "oreArdite", 1, null);
        this.registerOreDictLaserOre(10, "oreCobalt", 11, null);
        this.registerOreDictLaserOre(10, "Yellorite", 4, false);
        this.registerOreDictLaserOre(5, "Iridium", 0, false);
        this.registerOreDictLaserOre(20, "oreTetrahedrite", 1, null);
        this.registerOreDictLaserOre(20, "oreCadmium", 3, null);
        this.registerOreDictLaserOre(20, "oreIndium", 8, null);
        this.registerOreDictLaserOre(20, "oreAmmonium", 0, null);
        this.registerOreDictLaserOre(20, "oreCalcite", 1, null);
        this.registerOreDictLaserOre(20, "oreFluorite", 8, null);
        this.registerOreDictLaserOre(20, "oreMagnetite", 15, null);
        this.registerOreDictLaserOre(20, "oreManganese", 6, null);
        this.registerOreDictLaserOre(20, "oreMeutoite", 6, null);
        this.registerOreDictLaserOre(20, "oreEximite", 6, null);
        this.registerOreDictLaserOre(20, "oreAtlarus", 6, null);
        this.registerOreDictLaserOre(20, "oreOrichalcum", 6, null);
        this.registerOreDictLaserOre(20, "oreRubracium", 6, null);
        this.registerOreDictLaserOre(20, "oreCarmot", 6, null);
        this.registerOreDictLaserOre(20, "oreAstralSilver", 6, null);
        this.registerOreDictLaserOre(20, "oreOureclase", 6, null);
        this.registerOreDictLaserOre(20, "oreInfuscolium", 6, null);
        this.registerOreDictLaserOre(20, "oreDeepIron", 6, null);
        this.registerOreDictLaserOre(20, "orePrometheum", 6, null);
        this.registerOreDictLaserOre(20, "oreSanguinite", 6, null);
        this.registerOreDictLaserOre(20, "oreVulcanite", 6, null);
        this.registerOreDictLaserOre(20, "oreKalendrite", 6, null);
        this.registerOreDictLaserOre(20, "oreAlduorite", 6, null);
        this.registerOreDictLaserOre(20, "oreCeruclase", 6, null);
        this.registerOreDictLaserOre(20, "oreVyroxeres", 6, null);
        this.registerOreDictLaserOre(20, "oreMidasium", 6, null);
        this.registerOreDictLaserOre(20, "oreLemurite", 6, null);
        this.registerOreDictLaserOre(20, "oreShadowIron", 6, null);
        this.registerOreDictLaserOre(20, "oreIgnatius", 6, null);
        this.registerOreDictLaserOre(20, "orePotash", 6, null);
        this.registerOreDictLaserOre(20, "oreBitumen", 6, null);
        this.registerOreDictLaserOre(20, "orePhosphorite", 6, null);
    }

    private void registerOreDictLaserOre(int n, String string, int n2, boolean bl) {
        this.registerOreDictLaserOre(n, "ore" + string, n2, "oreNether" + string, n2);
    }

    private void registerOreDictLaserOre(int n, String string, int n2, String string2) {
        this.registerOreDictLaserOre(n, string, n2, string2, n2);
    }

    private void registerOreDictLaserOre(int n, String string, int n2, String string2, int n3) {
        for (ItemStack itemStack : OreDictionary.getOres((String)string)) {
            if (itemStack == null) continue;
            itemStack = itemStack.func_77946_l();
            itemStack.field_77994_a = 1;
            MFRRegistry.registerLaserOre(n, itemStack);
            if (n2 >= 0) {
                MFRRegistry.addLaserPreferredOre(n2, itemStack);
            }
            if (string2 != null) {
                this.registerOreDictLaserOre(n / 2, string2, n3, null);
            }
            return;
        }
        if (string2 != null) {
            for (ItemStack itemStack : OreDictionary.getOres((String)string2)) {
                if (itemStack == null) continue;
                this.registerOreDictLaserOre(n / 2, string2, n3, null);
                return;
            }
        }
    }
}

