/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ASM;

import Reika.DragonAPI.Exception.ASMException;
import Reika.DragonAPI.Libraries.Java.ReikaASMHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.classloading.FMLForgePlugin;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InnerClassNode;

public class ClassReparenter
implements IClassTransformer {
    private static final boolean DEBUG = true;

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (!FMLForgePlugin.RUNTIME_DEOBF) {
            return bytes;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        String s = this.parseClass(classNode);
        if (s != null) {
            ReikaJavaLibrary.pConsole(String.format("DRAGONAPI ASM: Redirecting parent of class %s from %s to %s due to missing dependencies.", classNode.name, s, classNode.superName));
        }
        for (InnerClassNode innerClassNode : classNode.innerClasses) {
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        classNode.check(classNode.version);
        return writer.toByteArray();
    }

    private String parseClass(ClassNode cn) {
        if (cn.visibleAnnotations == null) {
            return null;
        }
        for (AnnotationNode ann : cn.visibleAnnotations) {
            if (!ann.desc.equals("LReika/DragonAPI/ASM/ClassReparenter$Reparent;") || ann.values == null) continue;
            for (int x = 0; x < ann.values.size() - 1; x += 2) {
                Object key = ann.values.get(x);
                Object values = ann.values.get(x + 1);
                if (!(key instanceof String) || !key.equals("value") || !(values instanceof ArrayList)) continue;
                String[] parts = ((ArrayList)values).toArray(new String[((ArrayList)values).size()]);
                if (parts.length != 2) {
                    throw new InvalidReparentAnnotationException(cn, ann, "Wrong number of arguments!");
                }
                return this.handleReparent(cn, parts) ? parts[0] : null;
            }
        }
        return null;
    }

    private boolean handleReparent(ClassNode cn, String[] parts) {
        if (!ReikaASMHelper.checkForClass(parts[0])) {
            parts[1] = parts[1].replace('.', '/');
            cn.superName = parts[1];
            return true;
        }
        return false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Reparent {
        public String[] value();
    }

    private static class InvalidReparentAnnotationException
    extends ASMException {
        private final AnnotationNode annotation;
        private final String message;

        public InvalidReparentAnnotationException(ClassNode cn, AnnotationNode ann, String msg) {
            super(cn);
            this.annotation = ann;
            this.message = msg;
        }

        @Override
        public final String getMessage() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.getMessage());
            sb.append("Annotation type " + this.annotation.desc + " is not valid reparent annotation: ");
            sb.append("!");
            sb.append(this.message);
            return sb.toString();
        }
    }
}

