/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ASM;

import Reika.DragonAPI.ASM.Patchers.Patcher;
import Reika.DragonAPI.Auxiliary.CoreModDetection;
import Reika.DragonAPI.Auxiliary.WorldGenInterceptionRegistry;
import Reika.DragonAPI.Exception.ASMException;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Libraries.Java.ReikaASMHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJVMParser;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import java.util.Collection;
import net.minecraft.item.Item;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public class DragonAPIClassTransformer
implements IClassTransformer {
    private static final MultiMap<String, Patcher> classes = new MultiMap(MultiMap.CollectionType.HASHSET).setNullEmpty();
    private static int bukkitFlags;
    private static boolean nullItemPrintout;
    private static boolean nullItemCrash;
    private static boolean init;

    public static boolean doLightUpdate(World world, int x, int y, int z) {
        if (WorldGenInterceptionRegistry.skipLighting) {
            return false;
        }
        boolean flag = false;
        if (!world.field_73011_w.field_76576_e) {
            flag |= world.func_147463_c(EnumSkyBlock.Sky, x, y, z);
        }
        return flag |= world.func_147463_c(EnumSkyBlock.Block, x, y, z);
    }

    public static boolean updateSetBlockLighting(int x, int y, int z, World world, int flags) {
        if ((flags & 8) == 0) {
            return world.func_147451_t(x, y, z);
        }
        return false;
    }

    public static void validateItemStack(Item i) {
        if (i == null && (nullItemCrash || nullItemPrintout)) {
            String s = "A mod created an ItemStack of a null item.\n";
            s = s + "Though somewhat common, this is a very bad practice as such ItemStacks crash almost immediately upon even basic use.\n";
            s = s + "Check the Stacktrace for the mod code coming before ItemStack.func_150996_a or ItemStack.<init>.\n";
            s = s + "Notify the developer of that mod.\n";
            s = s + "Though it is possible that in this case, the mod was not going to do anything with the item, such stacks are commonly\n";
            s = s + "registered the OreDictionary, dropped as entities, or added to dungeon loot tables, resulting in crashes in other mods.\n";
            s = s + "As a result, and the fact that a null-item stack is never necessary, it should be avoided in all cases.\n";
            if (nullItemCrash) {
                s = s + "You can turn this crash off in the DragonAPI configs, but you would likely crash anyways, usually soon afterward.";
                throw new IllegalStateException(s);
            }
            s = s + "You can disable this printout with a JVM argument, but doing so is not recommended.";
            ReikaASMHelper.logError(s);
            Thread.dumpStack();
        }
    }

    public byte[] transform(String className, String className2, byte[] opcodes) {
        Collection<Patcher> c;
        if (!classes.isEmpty() && (c = classes.get(className)) != null) {
            if (!init) {
                ReikaJavaLibrary.initClass(CoreModDetection.class);
                init = true;
            }
            ReikaASMHelper.activeMod = "DragonAPI";
            for (Patcher p : c) {
                ReikaASMHelper.log("Running patcher " + p);
                try {
                    opcodes = p.apply(opcodes);
                }
                catch (ASMException e) {
                    if (p.isExceptionThrowing()) {
                        throw e;
                    }
                    ReikaASMHelper.logError("ASM ERROR IN " + p + ":");
                    e.printStackTrace();
                }
            }
            classes.remove(className);
            ReikaASMHelper.activeMod = null;
        }
        return opcodes;
    }

    public static int getBukkitFlags() {
        return bukkitFlags;
    }

    static {
        nullItemPrintout = false;
        nullItemCrash = false;
        init = false;
        MultiMap<String, Patcher> map = ReikaASMHelper.getPatchers("DragonAPI", "Reika.DragonAPI.ASM.Patchers");
        classes.putAll(map);
        bukkitFlags = BukkitBitflags.calculateFlags();
        nullItemPrintout = !ReikaJVMParser.isArgumentPresent("-DragonAPI_noNullItemPrint");
    }

    public static enum BukkitBitflags {
        CAULDRON("kcauldron.KCauldron"),
        THERMOS("thermos.Thermos");

        private final String className;
        public final int flag;
        private static final BukkitBitflags[] list;

        private BukkitBitflags(String s) {
            this.className = s;
            this.flag = 1 << this.ordinal();
        }

        private boolean test() {
            try {
                return Class.forName(this.className) != null;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }

        private static int calculateFlags() {
            int flags = 0;
            for (int i = 0; i < list.length; ++i) {
                BukkitBitflags b = list[i];
                if (!b.test()) continue;
                flags |= b.flag;
            }
            return flags;
        }

        static {
            list = BukkitBitflags.values();
        }
    }
}

