/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ASM.Profiling;

import Reika.DragonAPI.ASM.Patchers.Hooks.Event.World.ChunkRequestEvent;
import Reika.DragonAPI.Exception.ASMException;
import Reika.DragonAPI.Interfaces.Subgenerator;
import Reika.DragonAPI.Libraries.Java.ReikaASMHelper;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class WorldGeneratorProfilingHooks
implements IClassTransformer {
    private final HashSet<String> superClasses = new HashSet();

    public WorldGeneratorProfilingHooks() {
        this.superClasses.add("net/minecraft/world/gen/feature/WorldGenerator");
        this.superClasses.add("net/minecraft/world/gen/feature/WorldGenAbstractTree");
        this.superClasses.add("net/minecraft/world/gen/feature/WorldGenHugeTrees");
        this.superClasses.add("biomesoplenty/common/world/generation/WorldGeneratorBOP");
        this.superClasses.add("Reika/ChromatiCraft/Base/ChromaWorldGenerator");
        this.superClasses.add("twilightforest/world/TFTreeGenerator");
        this.superClasses.add("twilightforest/world/TFGenerator");
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (!ChunkRequestEvent.patch.isEnabled()) {
            return bytes;
        }
        ClassNode cn = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)cn, 0);
        if (this.superClasses.contains(cn.superName) && !cn.interfaces.contains(Subgenerator.class.getName().replace(".", "/"))) {
            ReikaASMHelper.activeMod = "DragonAPI";
            boolean flag = true;
            try {
                MethodNode m = ReikaASMHelper.getMethodByName(cn, "func_76484_a", "generate", "(Lnet/minecraft/world/World;Ljava/util/Random;III)Z");
                if ((m.access & 0x400) != 0) {
                    flag = false;
                } else {
                    ArrayList<AbstractInsnNode> c = new ArrayList<AbstractInsnNode>();
                    for (int i = 0; i < m.instructions.size(); ++i) {
                        AbstractInsnNode ain = m.instructions.get(i);
                        if (ain.getOpcode() != 172) continue;
                        c.add(ain);
                    }
                    this.inject(cn, m, m.instructions.getFirst(), true);
                    for (AbstractInsnNode ain : c) {
                        this.inject(cn, m, ain, false);
                    }
                    ReikaASMHelper.log("Injected " + (c.size() + 1) + " profiling hooks into " + cn.name);
                    ReikaASMHelper.addField(cn, "cachedX", "I", 4, 0);
                    ReikaASMHelper.addField(cn, "cachedZ", "I", 4, 0);
                }
            }
            catch (ASMException.NoSuchASMMethodException e) {
                flag = false;
            }
            if (!flag) {
                ReikaASMHelper.log("Skipping profiling hooks on " + cn.name + "; does not contain generate method");
                if (!this.superClasses.contains(cn.name)) {
                    ReikaASMHelper.log("This class should be added to the superClass generator parent list!");
                }
            }
        } else {
            return bytes;
        }
        ReikaASMHelper.activeMod = null;
        ClassWriter writer = new ClassWriter(1);
        cn.accept((ClassVisitor)writer);
        cn.check(cn.version);
        return writer.toByteArray();
    }

    private void inject(ClassNode cn, MethodNode m, AbstractInsnNode ain, boolean isPre) {
        InsnList li = new InsnList();
        if (isPre) {
            li.add((AbstractInsnNode)new VarInsnNode(25, 0));
            li.add((AbstractInsnNode)new VarInsnNode(21, 3));
            li.add((AbstractInsnNode)new FieldInsnNode(181, cn.name, "cachedX", "I"));
            li.add((AbstractInsnNode)new VarInsnNode(25, 0));
            li.add((AbstractInsnNode)new VarInsnNode(21, 5));
            li.add((AbstractInsnNode)new FieldInsnNode(181, cn.name, "cachedZ", "I"));
        }
        li.add((AbstractInsnNode)new VarInsnNode(25, 1));
        li.add((AbstractInsnNode)new VarInsnNode(25, 0));
        li.add((AbstractInsnNode)new VarInsnNode(25, 0));
        li.add((AbstractInsnNode)new FieldInsnNode(180, cn.name, "cachedX", "I"));
        li.add((AbstractInsnNode)new VarInsnNode(25, 0));
        li.add((AbstractInsnNode)new FieldInsnNode(180, cn.name, "cachedZ", "I"));
        li.add((AbstractInsnNode)new MethodInsnNode(184, "Reika/DragonAPI/Auxiliary/Trackers/WorldgenProfiler", isPre ? "startGenerator" : "onRunGenerator", "(Lnet/minecraft/world/World;Lnet/minecraft/world/gen/feature/WorldGenerator;II)V", false));
        m.instructions.insertBefore(ain, li);
    }
}

