/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Instantiable.IO.ControlledConfig;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.util.EnumChatFormatting;
import org.apache.commons.codec.Charsets;

public class PackModificationTracker {
    public static final PackModificationTracker instance = new PackModificationTracker();
    private final HashMap<DragonAPIMod, ArrayList<PackModification>> data = new HashMap();
    private final HashMap<DragonAPIMod, File> filepaths = new HashMap();
    private static final Comparator modComparator = new ModComparator();

    private PackModificationTracker() {
    }

    public List<PackModification> getModifications(DragonAPIMod mod) {
        ArrayList<PackModification> li = this.data.get(mod);
        return li != null ? Collections.unmodifiableList(li) : null;
    }

    public boolean modificationsExist(DragonAPIMod mod) {
        return this.data.get(mod) != null && !this.data.get(mod).isEmpty();
    }

    public void addMod(DragonAPIMod mod, ControlledConfig cfg) {
        this.addMod(mod, this.getConfigFolderBasedPath(mod, cfg));
    }

    public void addMod(DragonAPIMod mod, File path) {
        if (!this.filepaths.containsKey(mod)) {
            this.filepaths.put(mod, path);
        }
    }

    public void loadAll() {
        for (DragonAPIMod mod : this.filepaths.keySet()) {
            this.load(mod);
        }
    }

    private void load(DragonAPIMod mod) {
        mod.getModLogger().log("Loading pack modification log file.");
        try {
            File f = this.filepaths.get(mod);
            if (!f.exists()) {
                this.createDataFile(f, mod);
            }
            try (BufferedReader p = ReikaFileReader.getReader(f, Charsets.UTF_8);){
                String line = "";
                while (line != null) {
                    line = p.readLine();
                    if (line == null || line.isEmpty() || line.startsWith("//")) continue;
                    PackModification entry = this.parseString(line);
                    if (entry != null) {
                        this.addEntry(mod, entry);
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid modification entry formatting: '" + line + "'");
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid pack modification file: " + e.getLocalizedMessage(), e);
        }
    }

    private void addEntry(DragonAPIMod mod, PackModification entry) {
        ArrayList<PackModification> li = this.data.get(mod);
        if (li == null) {
            li = new ArrayList();
            this.data.put(mod, li);
        }
        li.add(entry);
        Collections.sort(li, modComparator);
    }

    public final String getBasicSaveFileName(DragonAPIMod mod) {
        return ReikaStringParser.stripSpaces(mod.getTechnicalName()) + "_PackModifications.cfg";
    }

    private final File getConfigFolderBasedPath(DragonAPIMod mod, ControlledConfig cfg) {
        return new File(cfg.getConfigFolder(), this.getBasicSaveFileName(mod));
    }

    private void createDataFile(File f, DragonAPIMod mod) throws Exception {
        f.createNewFile();
        PrintWriter p = new PrintWriter(f);
        PackModificationTracker.writeCommentLine(p, "-------------------------------");
        PackModificationTracker.writeCommentLine(p, " " + mod.getDisplayName() + " Pack Modification Log File ");
        PackModificationTracker.writeCommentLine(p, "-------------------------------");
        PackModificationTracker.writeCommentLine(p, "");
        PackModificationTracker.writeCommentLine(p, "Use this file to specify any changes you are making to " + mod.getDisplayName() + " for your modpack.");
        PackModificationTracker.writeCommentLine(p, "Specify one per line, and format them in one of the following ways:");
        PackModificationTracker.writeCommentLine(p, "Description OR Description:Reason");
        PackModificationTracker.writeCommentLine(p, "");
        PackModificationTracker.writeCommentLine(p, "Sample Lines:");
        PackModificationTracker.writeCommentLine(p, "\tChanged compressor recipe to use GT steel");
        PackModificationTracker.writeCommentLine(p, "\tReplaced gold ingot in ignition unit recipe with signalum:Small balance tweak");
        PackModificationTracker.writeCommentLine(p, "");
        PackModificationTracker.writeCommentLine(p, "Entries missing a description, or with more than one colon separator, are incorrect.");
        PackModificationTracker.writeCommentLine(p, "Incorrectly formatted lines will throw an exception.");
        PackModificationTracker.writeCommentLine(p, "Lines beginning with '//' are comments and will be ignored, as will empty lines.");
        PackModificationTracker.writeCommentLine(p, "");
        PackModificationTracker.writeCommentLine(p, "NOTE WELL: Any changes you make to the pack MUST be specified here to avoid confusing users.");
        PackModificationTracker.writeCommentLine(p, "\tAny changes not explained here will be assumed to be intentionally hidden, and");
        PackModificationTracker.writeCommentLine(p, "\tyou will lose permission to make the changes.");
        PackModificationTracker.writeCommentLine(p, "====================================================================================");
        p.append("\n");
        p.close();
    }

    private static void writeCommentLine(PrintWriter p, String line) {
        p.append("// " + line + "\n");
    }

    private PackModification parseString(String s) throws Exception {
        s = s.replace("\n", "").replace("\r", "").replace("\t", "");
        String[] parts = s.split(":");
        int n = parts.length - 1;
        switch (n) {
            case 0: {
                return new PackModification(s);
            }
            case 1: {
                return new PackModification(parts[0], parts[1]);
            }
        }
        throw new IllegalArgumentException("Invalid line formatting: '" + s + "' has too many (" + n + ") separators!");
    }

    private static class ModComparator
    implements Comparator<PackModification> {
        private ModComparator() {
        }

        @Override
        public int compare(PackModification o1, PackModification o2) {
            return 0;
        }
    }

    public static class PackModification {
        private final String desc;
        private final String reason;

        private PackModification(String s) {
            this(s, (String)null);
        }

        private PackModification(String s, String r) {
            this.desc = s;
            this.reason = r;
        }

        public String toString() {
            return EnumChatFormatting.RED + "# " + EnumChatFormatting.WHITE + (this.reason != null && !this.reason.isEmpty() ? this.desc + "; " + this.reason : this.desc);
        }
    }
}

