/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Instantiable.Math.Noise.SimplexNoiseGenerator;
import Reika.DragonAPI.Interfaces.WinterBiomeStrengthControl;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.ModInteract.DeepInteract.PlanetDimensionHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Calendar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class SpecialDayTracker {
    public static final SpecialDayTracker instance = new SpecialDayTracker();
    private final Calendar calendar;
    private final SimplexNoiseGenerator weatherNoise = new SimplexNoiseGenerator(System.currentTimeMillis());

    private SpecialDayTracker() {
        this.calendar = Calendar.getInstance();
    }

    public boolean loadAprilTextures() {
        if (!DragonOptions.APRIL.getState()) {
            return false;
        }
        return this.calendar.get(2) == 3 && this.calendar.get(5) <= 2;
    }

    public boolean loadXmasTextures() {
        return this.calendar.get(2) == 11 && this.calendar.get(5) >= 17 || this.calendar.get(2) == 0 && this.calendar.get(5) <= 6;
    }

    @SideOnly(value=Side.CLIENT)
    public float getXmasWeatherStrength(World world) {
        if (!this.isWinterEnabled()) {
            return 0.0f;
        }
        if (world.field_73011_w.field_76576_e || PlanetDimensionHandler.isOtherWorld(world)) {
            return 0.0f;
        }
        double val = this.weatherNoise.getValue((double)world.func_82737_E() / 6000.0, world.field_73011_w.field_76574_g * 200);
        float norm = (float)Math.sqrt(ReikaMathLibrary.normalizeToBounds(val, 0.0, 1.0));
        EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
        BiomeGenBase biome = world.func_72807_a(MathHelper.func_76128_c((double)ep.field_70165_t), MathHelper.func_76128_c((double)ep.field_70161_v));
        if (biome instanceof WinterBiomeStrengthControl) {
            norm *= ((WinterBiomeStrengthControl)biome).getWinterSkyStrength(world, (EntityPlayer)ep);
        }
        return MathHelper.func_76131_a((float)(norm * 1.1f), (float)0.0f, (float)1.0f);
    }

    public boolean isWinterEnabled() {
        return this.loadXmasTextures();
    }

    public boolean isHalloween() {
        return this.calendar.get(2) == 9 && this.calendar.get(5) >= 30;
    }
}

