/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Command;

import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.Command.DragonCommandBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.IO.MapOutput;
import Reika.DragonAPI.Interfaces.CustomBiomeDistributionWorld;
import Reika.DragonAPI.Interfaces.CustomMapColorBiome;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.World.ReikaBiomeHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenMesa;
import net.minecraft.world.biome.BiomeGenMushroomIsland;
import net.minecraft.world.biome.BiomeGenMutated;
import net.minecraft.world.biome.BiomeGenRiver;
import net.minecraft.world.biome.WorldChunkManager;

public class BiomeMapCommand
extends DragonCommandBase {
    public static final int PACKET_COMPILE = 2048;
    private static BiomeMapCommand instance;
    private static final Random rand;
    private static final HashMap<Integer, BiomeMap> activeMaps;

    public BiomeMapCommand() {
        instance = this;
    }

    public void func_71515_b(ICommandSender ics, String[] args) {
        Object[] ret = this.getPlayer(ics, args);
        ArrayList<BiomeProvider> set = new ArrayList<BiomeProvider>();
        if (args.length < 2) {
            BiomeMapCommand.sendChatToSender(ics, EnumChatFormatting.RED.toString() + "Illegal arguments. Use [seed=<seed>] [range] [resolution] <grid> <fullGrid>.");
            return;
        }
        if (args[0].toLowerCase(Locale.ENGLISH).startsWith("seed=")) {
            String[] parts;
            args[0] = args[0].substring(5);
            if (args[0].contains(",")) {
                for (String s : parts = args[0].split(",")) {
                    set.add(new SeedBiomes(Long.parseLong(s)));
                }
            } else if (args[0].charAt(0) != '-' && args[0].contains("-")) {
                parts = args[0].split("\\-");
                long s1 = Long.parseLong(parts[0]);
                long s2 = Long.parseLong(parts[1]);
                for (long seed = s1; seed <= s2; ++seed) {
                    set.add(new SeedBiomes(seed));
                }
            } else {
                set.add(new SeedBiomes(Long.parseLong(args[0])));
            }
            String[] nargs = new String[args.length - 1];
            System.arraycopy(args, 1, nargs, 0, nargs.length);
            args = nargs;
        }
        EntityPlayerMP ep = (EntityPlayerMP)ret[0];
        if (((Boolean)ret[1]).booleanValue()) {
            String[] nargs = new String[args.length - 1];
            System.arraycopy(args, 1, nargs, 0, nargs.length);
            args = nargs;
        }
        int range = Integer.parseInt(args[0]);
        int res = Integer.parseInt(args[1]);
        int grid = args.length >= 3 ? Integer.parseInt(args[2]) : -1;
        boolean fullGrid = grid > 0 && args.length >= 4 && Boolean.parseBoolean(args[3]);
        int x = MathHelper.func_76128_c((double)ep.field_70165_t);
        int z = MathHelper.func_76128_c((double)ep.field_70161_v);
        long start = System.currentTimeMillis();
        if (set.isEmpty()) {
            set.add(new WorldBiomes(ep.field_70170_p));
        }
        for (BiomeProvider bp : set) {
            this.generateMap(bp, ep, start, x, z, range, res, grid, fullGrid, null);
        }
    }

    public static void triggerBiomeMap(EntityPlayerMP ep, int x, int z, int range, int res, int grid, MapCompleteCallback call) {
        instance.generateMap(new WorldBiomes(ep.field_70170_p), ep, System.currentTimeMillis(), x, z, range, res, grid, false, call);
    }

    public static void triggerBiomeMap(EntityPlayerMP ep, int range, int res, int grid) {
        instance.func_71515_b((ICommandSender)ep, new String[]{String.valueOf(range), String.valueOf(res), String.valueOf(grid)});
    }

    private void generateMap(BiomeProvider bp, EntityPlayerMP ep, long start, int x, int z, int range, int res, int grid, boolean fullGrid, MapCompleteCallback callback) {
        int dim;
        int hash = rand.nextInt();
        int n = dim = bp instanceof WorldBiomes ? 0 : ep.field_70170_p.field_73011_w.field_76574_g;
        if (DragonAPICore.isSinglePlayer()) {
            BiomeMapCommand.startCollecting(hash, bp.getName(), dim, x, z, range, res, grid, fullGrid);
        } else {
            ReikaPacketHelper.sendStringIntPacket("DragonAPIData", APIPacketHandler.PacketIDs.BIOMEPNGSTART.ordinal(), ep, bp.getName(), hash, dim, x, z, range, res, grid, fullGrid ? 1 : 0);
        }
        ArrayList<Integer> dat = new ArrayList<Integer>();
        dat.add(hash);
        int n2 = 0;
        for (int dx = x - range; dx <= x + range; dx += res) {
            for (int dz = z - range; dz <= z + range; dz += res) {
                int biome = bp.getBiome(dx, dz);
                ++n2;
                if (DragonAPICore.isSinglePlayer()) {
                    BiomeMapCommand.addBiomePoint(hash, dx, dz, biome);
                } else {
                    dat.add(dx);
                    dat.add(dz);
                    dat.add(biome);
                }
                if (n2 < 2048 || DragonAPICore.isSinglePlayer()) continue;
                ReikaPacketHelper.sendDataPacket("DragonAPIData", APIPacketHandler.PacketIDs.BIOMEPNGDAT.ordinal(), ep, dat);
                n2 = 0;
                dat.clear();
                dat.add(hash);
            }
        }
        if (dat.size() > 1) {
            int m = (dat.size() - 1) / 3;
            int biome = bp.getBiome(x, z);
            if (DragonAPICore.isSinglePlayer()) {
                BiomeMapCommand.addBiomePoint(hash, x, z, biome);
            } else {
                for (int i = m; i < 2048; ++i) {
                    dat.add(x);
                    dat.add(z);
                    dat.add(biome);
                }
                ReikaPacketHelper.sendDataPacket("DragonAPIData", APIPacketHandler.PacketIDs.BIOMEPNGDAT.ordinal(), ep, dat);
                n2 = 0;
                dat.clear();
                dat.add(hash);
            }
        }
        if (callback != null) {
            callback.onComplete();
            callback = null;
        }
        if (DragonAPICore.isSinglePlayer()) {
            BiomeMapCommand.finishCollectingAndMakeImage(hash);
        } else {
            ReikaPacketHelper.sendDataPacket("DragonAPIData", APIPacketHandler.PacketIDs.BIOMEPNGEND.ordinal(), ep, hash);
        }
    }

    private Object[] getPlayer(ICommandSender ics, String[] args) {
        try {
            Object[] objectArray = new Object[2];
            objectArray[0] = BiomeMapCommand.func_71521_c((ICommandSender)ics);
            objectArray[1] = false;
            return objectArray;
        }
        catch (Exception e) {
            EntityPlayerMP ep = ReikaPlayerAPI.getPlayerByNameAnyWorld(args[0]);
            if (ep == null) {
                BiomeMapCommand.sendChatToSender(ics, "If you specify a player, they must exist.");
                throw new IllegalArgumentException(e);
            }
            return new Object[]{ep, true};
        }
    }

    @Override
    public String getCommandString() {
        return "biomepng";
    }

    @Override
    protected boolean isAdminOnly() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static void startCollecting(int hash, String world, int dim, int x, int z, int range, int res, int grid, boolean fullGrid) {
        BiomeMap map = new BiomeMap(world, dim, x, z, range, res, grid, fullGrid);
        activeMaps.put(hash, map);
    }

    @SideOnly(value=Side.CLIENT)
    public static void addBiomePoint(int hash, int x, int z, int biomeID) {
        BiomeMap map = activeMaps.get(hash);
        if (map != null) {
            map.addPoint(x, z, biomeID);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void finishCollectingAndMakeImage(int hash) {
        BiomeMap map = activeMaps.remove(hash);
        if (map != null) {
            try {
                map.addGrid();
                String path = map.createImage();
                long dur = System.currentTimeMillis() - map.startTime;
                ReikaChatHelper.sendChatToPlayer((EntityPlayer)Minecraft.func_71410_x().field_71439_g, EnumChatFormatting.GREEN + "File created in " + dur + " ms: " + path);
            }
            catch (IOException e) {
                ReikaChatHelper.sendChatToPlayer((EntityPlayer)Minecraft.func_71410_x().field_71439_g, EnumChatFormatting.RED + "Failed to create file: " + e.toString());
                e.printStackTrace();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static int getBiomeColor(int x, int z, BiomeGenBase b) {
        if (b == null) {
            return 0;
        }
        if (b instanceof CustomMapColorBiome) {
            return ((CustomMapColorBiome)b).getMapColor((World)Minecraft.func_71410_x().field_71441_e, x, z);
        }
        boolean mutate = b instanceof BiomeGenMutated;
        if (mutate) {
            b = ((BiomeGenMutated)b).field_150611_aD;
        }
        if (b == BiomeGenBase.field_76778_j) {
            return 12658179;
        }
        if (b == BiomeGenBase.field_76779_k) {
            return 16771491;
        }
        if (b == BiomeGenBase.field_76776_l) {
            return 65535;
        }
        if (b.field_76756_M == BiomeGenBase.field_76774_n.field_76756_M + 128) {
            return 0x7FFFFF;
        }
        if (b == BiomeGenBase.field_76775_o) {
            return 0xD0D0D0;
        }
        if (b.field_76791_y.equalsIgnoreCase("Shield")) {
            return 3702605;
        }
        if (b.field_76791_y.equalsIgnoreCase("Tropics")) {
            return 65280;
        }
        if (b.field_76791_y.equalsIgnoreCase("Lush Swamp")) {
            return 36864;
        }
        if (b.field_76791_y.equalsIgnoreCase("Bayou")) {
            return 8093519;
        }
        if (ReikaBiomeHelper.isOcean(b)) {
            if (b == BiomeGenBase.field_150575_M) {
                return 176;
            }
            return 255;
        }
        if (b instanceof BiomeGenRiver) {
            return 0x22AAFF;
        }
        if (b instanceof BiomeGenMesa) {
            return mutate ? 13529938 : 12866603;
        }
        if (b instanceof BiomeGenMushroomIsland) {
            return 9852017;
        }
        if (b == BiomeGenBase.field_150578_U || b == BiomeGenBase.field_150581_V) {
            return 10184761;
        }
        if (b.field_76752_A == Blocks.field_150354_m) {
            return 14862741;
        }
        if (b.field_76752_A == Blocks.field_150348_b) {
            return 0x808080;
        }
        if (b.field_76791_y.equalsIgnoreCase("Coniferous Forest")) {
            return 32578;
        }
        if (b.field_76791_y.equalsIgnoreCase("Maple Forest")) {
            return 3833682;
        }
        int c = b.func_150558_b(x, 64, z);
        if (ReikaBiomeHelper.isSnowBiome(b)) {
            c = 0xFFFFFF;
        }
        if (b == BiomeGenBase.field_150584_S) {
            c = 11403211;
        }
        if (mutate) {
            c = ReikaColorAPI.getColorWithBrightnessMultiplier(c, 0.875f);
        } else if (ReikaBiomeHelper.isChildBiome(b)) {
            c = c == 0xFFFFFF ? 0xD0D0D0 : ReikaColorAPI.getColorWithBrightnessMultiplier(c, 1.125f);
        }
        return c;
    }

    static {
        rand = new Random();
        activeMaps = new HashMap();
    }

    public static interface MapCompleteCallback {
        public void onComplete();
    }

    private static class BiomeMap
    extends MapOutput<Integer> {
        private BiomeMap(String name, int dim, int x, int z, int r, int res, int grid, boolean fgrid) {
            super(name, dim, x, z, r, res, grid, fgrid);
        }

        @Override
        protected void onImageCreate(File f) throws IOException {
            this.createLegend(f);
        }

        @Override
        protected int getColor(int x, int z, Integer data) {
            return BiomeMapCommand.getBiomeColor(x, z, BiomeGenBase.field_76773_a[data]);
        }

        private void createLegend(File f) throws IOException {
            File f2 = new File(f.getParentFile(), "!legend.png");
            if (f2.exists() && !ReikaObfuscationHelper.isDeObfEnvironment()) {
                return;
            }
            f2.createNewFile();
            MultiMap<Integer, Integer> li = ReikaBiomeHelper.getBiomeHierearchy();
            int heightPerBiome = 18;
            int height = (4 + heightPerBiome) * (1 + li.totalSize() + li.keySet().size());
            BufferedImage img = new BufferedImage(256, height, 2);
            Graphics graphics = img.getGraphics();
            Font ft = graphics.getFont();
            graphics.setFont(new Font(ft.getName(), ft.getStyle(), ft.getSize() * 1));
            graphics.setColor(new Color(-16777216));
            int y = 2;
            for (Integer b : li.keySet()) {
                this.createLegendEntry(b, 2, y, graphics, img, heightPerBiome);
                y += heightPerBiome + 4;
                for (Integer b2 : li.get(b)) {
                    this.createLegendEntry(b2, 24, y, graphics, img, heightPerBiome);
                    y += heightPerBiome + 4;
                }
            }
            graphics.dispose();
            ImageIO.write((RenderedImage)img, "png", f2);
        }

        private void createLegendEntry(int b, int x, int y, Graphics g, BufferedImage img, int hpb) {
            BiomeGenBase biome = BiomeGenBase.field_76773_a[b];
            g.drawString(biome.field_76791_y + " [" + biome.field_76756_M + "]", x + hpb + 4, y + hpb / 2 + 4);
            for (int i = -1; i <= hpb; ++i) {
                for (int k = -1; k <= hpb; ++k) {
                    int clr = i == -1 || k == -1 || i == hpb || k == hpb ? -16777216 : 0xFF000000 | BiomeMapCommand.getBiomeColor(i * 12, k * 12, biome);
                    img.setRGB(x + i, y + k, clr);
                }
            }
        }
    }

    private static class SeedBiomes
    implements BiomeProvider {
        private final long seed;
        private final WorldChunkManager world;

        private SeedBiomes(long seed) {
            this.seed = seed;
            this.world = new WorldChunkManager(seed, WorldType.field_77137_b);
        }

        @Override
        public int getBiome(int x, int z) {
            return this.world.func_76935_a((int)x, (int)z).field_76756_M;
        }

        @Override
        public String getName() {
            return "SEED=" + this.seed;
        }
    }

    private static class WorldBiomes
    implements BiomeProvider {
        private final World world;

        private WorldBiomes(World world) {
            this.world = world;
        }

        @Override
        public int getBiome(int x, int z) {
            if (this.world.field_73011_w instanceof CustomBiomeDistributionWorld) {
                return ((CustomBiomeDistributionWorld)this.world.field_73011_w).getBiomeID(this.world, x, z);
            }
            return this.world.func_72959_q().func_76935_a((int)x, (int)z).field_76756_M;
        }

        @Override
        public String getName() {
            return this.world.func_72912_H().func_76065_j() + "/[" + this.world.func_72860_G().func_75760_g() + "]";
        }
    }

    private static interface BiomeProvider {
        public int getBiome(int var1, int var2);

        public String getName();
    }
}

