/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Command;

import Reika.DragonAPI.Command.DragonCommandBase;
import Reika.DragonAPI.Libraries.Java.ReikaASMHelper;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaReflectionHelper;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaCropHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaOreHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaPlantHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaTreeHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.World.ReikaBiomeHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModCropList;
import Reika.DragonAPI.ModRegistry.ModOreList;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.classloading.FMLForgePlugin;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public abstract class ReflectiveBasedCommand
extends DragonCommandBase {
    private static final HashMap<Class, HashMap<String, String>> SRGMap = new HashMap();
    private static final HashMap<String, String> packageShortcuts = new HashMap();
    private static final HashMap<String, Class> classShortcuts = new HashMap();
    private static final UUID consoleUUID = UUID.randomUUID();

    protected static boolean addClassShortcut(Class c) {
        if (!classShortcuts.containsKey(c)) {
            classShortcuts.put(c.getSimpleName(), c);
            return true;
        }
        return false;
    }

    public static Map<String, Class> getClassShortcuts() {
        return Collections.unmodifiableMap(classShortcuts);
    }

    protected final Class findClass(String name) throws ClassNotFoundException {
        Class<?> c = name.startsWith("#") ? classShortcuts.get(name.substring(1)) : null;
        name = name.replaceAll("/", ".");
        if (c == null) {
            c = Class.forName(name);
        }
        return c;
    }

    protected final UUID getUID(ICommandSender ics) {
        return ics instanceof EntityPlayer ? ((EntityPlayer)ics).func_110124_au() : consoleUUID;
    }

    private static void addSRGMapping(Class c, String deobf, String obf) {
        HashMap<String, String> map = SRGMap.get(c);
        if (map == null) {
            map = new HashMap();
            SRGMap.put(c, map);
        }
        map.put(deobf, obf);
    }

    protected final String toReadableString(Object o) {
        try {
            if (o != null && o.getClass().isArray()) {
                if (o instanceof int[]) {
                    return Arrays.toString((int[])o);
                }
                if (o instanceof boolean[]) {
                    return Arrays.toString((boolean[])o);
                }
                if (o instanceof float[]) {
                    return Arrays.toString((float[])o);
                }
                if (o instanceof double[]) {
                    return Arrays.toString((double[])o);
                }
                if (o instanceof short[]) {
                    return Arrays.toString((short[])o);
                }
                if (o instanceof long[]) {
                    return Arrays.toString((long[])o);
                }
                if (o instanceof byte[]) {
                    return Arrays.toString((byte[])o);
                }
                if (o instanceof char[]) {
                    return Arrays.toString((char[])o);
                }
                return Arrays.deepToString((Object[])o);
            }
            return String.valueOf(o);
        }
        catch (Exception e) {
            return "Object " + o.getClass().getName() + " threw exception on toString(): " + e.toString();
        }
    }

    @Override
    protected boolean isAdminOnly() {
        return true;
    }

    protected final Class[] parseTypes(String arg) throws ClassNotFoundException {
        if (arg.charAt(0) == '(') {
            return this.parseASMTypes(arg);
        }
        String[] parts = arg.split(";");
        Class[] types = new Class[parts.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.parseType(parts[i]);
        }
        return types;
    }

    private Class[] parseASMTypes(String arg) throws ClassNotFoundException {
        ArrayList<String> li = ReikaASMHelper.parseMethodSignature(arg);
        li.remove(li.size() - 1);
        Class[] types = new Class[li.size()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.parseASMType(li.get(i));
        }
        return types;
    }

    private Class parseASMType(String s) throws ClassNotFoundException {
        Class ret;
        if (s.startsWith("L#") && (ret = this.findClass(s.substring(1, s.length() - 1))) != null) {
            return ret;
        }
        return ReikaASMHelper.parseClass(s);
    }

    protected final Class parseType(String s) throws ClassNotFoundException {
        switch (s) {
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "void": {
                return Void.TYPE;
            }
            case "array": 
            case "Object[]": {
                return Object[].class;
            }
            case "int[]": {
                return int[].class;
            }
            case "double[]": {
                return double[].class;
            }
            case "float[]": {
                return float[].class;
            }
            case "short[]": {
                return short[].class;
            }
            case "byte[]": {
                return byte[].class;
            }
            case "long[]": {
                return long[].class;
            }
        }
        return this.findClass(s);
    }

    protected final Class parseType(Object o) {
        Class<Object> ret = o.getClass();
        if (ret == Integer.class) {
            ret = Integer.TYPE;
        } else if (ret == Long.class) {
            ret = Long.TYPE;
        } else if (ret == Float.class) {
            ret = Float.TYPE;
        } else if (ret == Double.class) {
            ret = Double.TYPE;
        } else if (ret == Byte.class) {
            ret = Byte.TYPE;
        } else if (ret == Short.class) {
            ret = Short.TYPE;
        }
        return ret;
    }

    protected final Object parseObject(String s) {
        if (s.equalsIgnoreCase("null") || s.equalsIgnoreCase("nil")) {
            return null;
        }
        if (s.equalsIgnoreCase("true")) {
            return true;
        }
        if (s.equalsIgnoreCase("false")) {
            return false;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Float.valueOf(Float.parseFloat(s));
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    return Double.parseDouble(s);
                }
                catch (NumberFormatException numberFormatException3) {
                    return s.replaceAll("__sp__", " ");
                }
            }
        }
    }

    protected void error(ICommandSender ics, String s) {
        ReflectiveBasedCommand.sendChatToSender(ics, EnumChatFormatting.RED + "Error: " + s);
    }

    protected final String deSRG(Class c, String s) {
        if (!FMLForgePlugin.RUNTIME_DEOBF) {
            return s;
        }
        HashMap<String, String> map = SRGMap.get(c);
        if (map == null) {
            return s;
        }
        String ret = map.get(s);
        return ret != null ? ret : s;
    }

    static {
        ReflectiveBasedCommand.addSRGMapping(World.class, "getBlock", "func_147439_a");
        ReflectiveBasedCommand.addSRGMapping(World.class, "getBlockMetadata", "func_72805_g");
        ReflectiveBasedCommand.addSRGMapping(World.class, "getTileEntity", "func_147438_o");
        ReflectiveBasedCommand.addSRGMapping(World.class, "getPlayerEntityByName", "func_72924_a");
        ReflectiveBasedCommand.addSRGMapping(World.class, "getPlayerEntityByUUID", "func_152378_a");
        ReflectiveBasedCommand.addSRGMapping(World.class, "provider", "field_73011_w");
        ReflectiveBasedCommand.addSRGMapping(EntityLivingBase.class, "getHealth", "func_110143_aJ");
        ReflectiveBasedCommand.addSRGMapping(EntityPlayer.class, "getCurrentEquippedItem", "func_71045_bC");
        ReflectiveBasedCommand.addSRGMapping(ItemStack.class, "getItem", "func_77973_b");
        ReflectiveBasedCommand.addSRGMapping(ItemStack.class, "getItemDamage", "func_77960_j");
        ReflectiveBasedCommand.addSRGMapping(ItemStack.class, "stackSize", "field_77994_a");
        ReflectiveBasedCommand.addSRGMapping(TileEntity.class, "worldObj", "field_145850_b");
        ReflectiveBasedCommand.addSRGMapping(TileEntity.class, "xCoord", "field_145851_c");
        ReflectiveBasedCommand.addSRGMapping(TileEntity.class, "yCoord", "field_145848_d");
        ReflectiveBasedCommand.addSRGMapping(TileEntity.class, "zCoord", "field_145849_e");
        ReflectiveBasedCommand.addSRGMapping(Entity.class, "worldObj", "field_70170_p");
        ReflectiveBasedCommand.addSRGMapping(Entity.class, "posX", "field_70165_t");
        ReflectiveBasedCommand.addSRGMapping(Entity.class, "posY", "field_70163_u");
        ReflectiveBasedCommand.addSRGMapping(Entity.class, "posZ", "field_70161_v");
        packageShortcuts.put("mcforge", "net.minecraftforge");
        packageShortcuts.put("mcworld", "net.minecraft.world");
        classShortcuts.put("String", String.class);
        classShortcuts.put("Object", Object.class);
        classShortcuts.put("Enum", Enum.class);
        classShortcuts.put("ArrayList", ArrayList.class);
        classShortcuts.put("HashMap", HashMap.class);
        classShortcuts.put("Class", Class.class);
        classShortcuts.put("Field", Field.class);
        classShortcuts.put("Method", Method.class);
        classShortcuts.put("Array", Array.class);
        classShortcuts.put("Arrays", Arrays.class);
        classShortcuts.put("Math", Math.class);
        classShortcuts.put("World", World.class);
        classShortcuts.put("Entity", Entity.class);
        classShortcuts.put("EntityLivingBase", EntityLivingBase.class);
        classShortcuts.put("EntityPlayer", EntityPlayer.class);
        classShortcuts.put("EntityPlayerMP", EntityPlayerMP.class);
        classShortcuts.put("TileEntity", TileEntity.class);
        classShortcuts.put("Block", Block.class);
        classShortcuts.put("Item", Item.class);
        classShortcuts.put("Blocks", Blocks.class);
        classShortcuts.put("Items", Items.class);
        classShortcuts.put("ItemStack", ItemStack.class);
        classShortcuts.put("Biome", BiomeGenBase.class);
        classShortcuts.put("BiomeGenBase", BiomeGenBase.class);
        classShortcuts.put("Server", MinecraftServer.class);
        classShortcuts.put("MinecraftServer", MinecraftServer.class);
        classShortcuts.put("ChunkProviderServer", ChunkProviderServer.class);
        classShortcuts.put("ChunkProviderGenerate", ChunkProviderGenerate.class);
        classShortcuts.put("DimensionManager", DimensionManager.class);
        classShortcuts.put("FML", FMLCommonHandler.class);
        classShortcuts.put("Forge", MinecraftForge.class);
        classShortcuts.put("ForgeDirection", ForgeDirection.class);
        classShortcuts.put("Loader", Loader.class);
        classShortcuts.put("Fluid", Fluid.class);
        classShortcuts.put("FluidStack", FluidStack.class);
        classShortcuts.put("FluidRegistry", FluidRegistry.class);
        classShortcuts.put("GameRegistry", GameRegistry.class);
        classShortcuts.put("OreDictionary", OreDictionary.class);
        classShortcuts.put("ASMHelper", ReikaASMHelper.class);
        classShortcuts.put("ReflectionHelper", ReikaReflectionHelper.class);
        classShortcuts.put("JavaLibrary", ReikaJavaLibrary.class);
        classShortcuts.put("StringParser", ReikaStringParser.class);
        classShortcuts.put("ArrayHelper", ReikaArrayHelper.class);
        classShortcuts.put("MathLibrary", ReikaMathLibrary.class);
        classShortcuts.put("PhysicsHelper", ReikaPhysicsHelper.class);
        classShortcuts.put("WorldHelper", ReikaWorldHelper.class);
        classShortcuts.put("BiomeHelper", ReikaBiomeHelper.class);
        classShortcuts.put("BlockHelper", ReikaBlockHelper.class);
        classShortcuts.put("ItemHelper", ReikaItemHelper.class);
        classShortcuts.put("InventoryHelper", ReikaInventoryHelper.class);
        classShortcuts.put("PlayerAPI", ReikaPlayerAPI.class);
        classShortcuts.put("PlantHelper", ReikaPlantHelper.class);
        classShortcuts.put("CropHelper", ReikaCropHelper.class);
        classShortcuts.put("OreHelper", ReikaOreHelper.class);
        classShortcuts.put("TreeHelper", ReikaTreeHelper.class);
        classShortcuts.put("ModList", ModList.class);
        classShortcuts.put("ModOreList", ModOreList.class);
        classShortcuts.put("ModWoodList", ModWoodList.class);
        classShortcuts.put("ModCropList", ModCropList.class);
    }
}

