/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Exception;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.DragonAPIException;
import java.lang.reflect.Method;
import java.util.Arrays;
import net.minecraft.block.Block;

public class VanillaIntegrityException
extends DragonAPIException {
    public VanillaIntegrityException(DragonAPIMod mod, String missing) {
        this.message.append(missing + " was deleted by another mod!\n");
        this.message.append(mod.getDisplayName() + " relies on this " + missing + ", and thus you must fix that other mod or remove it.\n");
        this.crash();
    }

    public VanillaIntegrityException(Class<? extends Block> cl, int id, boolean isBlock) {
        String sg = isBlock ? "block" : "item";
        this.message.append("A " + sg + " was deleted from vanilla minecraft!\n");
        this.message.append("ID " + id + " (normally " + cl.getSimpleName() + ") was deleted by another mod!\n");
        this.message.append("One or more of the DragonAPI mods rely on this " + sg + ", and thus you must fix that other mod or remove it.\n");
        this.crash();
    }

    public VanillaIntegrityException(Method m) {
        this.message.append("The function " + m + " was deleted from forge/vanilla!\n");
        this.message.append("If you are using MCPC/Cauldron, try to replicate the crash in SSP!\n");
        this.message.append("If the crash does not occur there, you must fix your copy of MCPC/Cauldron.\n");
        this.message.append("One or more of the DragonAPI mods rely on this function.\n");
        this.crash();
    }

    public VanillaIntegrityException(String methodName, Class src, Class ... argTypes) {
        this.message.append("A function was deleted from forge/vanilla!\n");
        this.message.append("Could not find " + methodName + "(" + Arrays.toString(argTypes) + " in class " + src.getCanonicalName() + "\n");
        this.message.append("If you are using MCPC/Cauldron, try to replicate the crash in SSP!\n");
        this.message.append("If the crash does not occur there, you must fix your copy of MCPC/Cauldron.\n");
        this.message.append("One or more of the DragonAPI mods rely on this function.\n");
        this.crash();
    }
}

