/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Extras;

import Reika.DragonAPI.Auxiliary.CoreModDetection;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Instantiable.IO.ControlledConfig;
import Reika.DragonAPI.Libraries.Java.ReikaJVMParser;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.crash.CrashReport;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraft.profiler.PlayerUsageSnooper;
import net.minecraftforge.common.ForgeVersion;

@SideOnly(value=Side.CLIENT)
public class EnvironmentPackager {
    public static final EnvironmentPackager instance = new EnvironmentPackager();
    private static final String HASH_SALT = "U1OWuY9wlD8qvqqJm4kWJGnaCBspo1yVSGkA9sKPBlbmWccOyJ1ouvE2A6ozLVvdJggwX4os45WKdGxxvEy1uoPSr2Vndn4uKhG76gEt9bEOUeu3EntibQuczoGXxITiC7CyI2obH3MtiAZHI86RPHv7UBoUbtjgQ3QwNRQGSOXSsdZmag1ZthajTjICYTqc5ke2x77o";

    private EnvironmentPackager() {
    }

    private File getFile() {
        return new File(new File(DragonAPICore.getMinecraftDirectory(), "DragonAPI"), "gameenv.export");
    }

    private File getSettingsFile() {
        return new File(DragonAPICore.getMinecraftDirectory(), "options.txt");
    }

    public File export() {
        try {
            File f = this.getFile();
            f.delete();
            f.getParentFile().mkdirs();
            f.createNewFile();
            ArrayList<DataSection> data = new ArrayList<DataSection>();
            DataSection sec = new DataSection(DataSections.INFO);
            sec.add("Game Version: 1.7.10");
            sec.add("Forge Version: " + ForgeVersion.getVersion());
            sec.add("Java Version: " + ReikaJVMParser.getFullJavaInfo());
            sec.add("Current Time: " + new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z").format(Calendar.getInstance().getTime()));
            sec.add("Is Dev Env: " + ReikaObfuscationHelper.isDeObfEnvironment());
            sec.add("Server Mode: " + (DragonAPICore.isSinglePlayerFromClient() ? "Singleplayer" : "Server"));
            sec.add("JVM Args: " + ReikaJVMParser.getAllArguments());
            sec.add("Launcher: " + ReikaJVMParser.getLauncher());
            sec.add("Root Classloader: " + LaunchClassLoader.class.getClassLoader());
            sec.add("Game Classloader: " + LaunchClassLoader.getSystemClassLoader());
            sec.add("Engine Overhauls: " + CoreModDetection.getStatus());
            data.add(sec);
            sec = new DataSection(DataSections.CRASHREP);
            CrashReport report = CrashReport.func_85055_a((Throwable)new Throwable(){

                @Override
                public String getMessage() {
                    return "Generating game environment data...";
                }

                @Override
                public void printStackTrace(PrintWriter s) {
                }

                @Override
                public void printStackTrace(PrintStream s) {
                }
            }, (String)"Environment Dump");
            String[] split = report.func_71502_e().split("\\\\n");
            sec.addAll(ReikaJavaLibrary.makeListFromArray(split));
            data.add(sec);
            sec = new DataSection(DataSections.OPTIONS);
            sec.addAll(ReikaFileReader.getFileAsLines(this.getSettingsFile(), true));
            data.add(sec);
            sec = new DataSection(DataSections.MODS);
            for (ModContainer mc : Loader.instance().getActiveModList()) {
                sec.add(mc.getModId() + " # " + mc.getVersion());
            }
            data.add(sec);
            for (ControlledConfig cfg : ControlledConfig.getConfigs()) {
                sec = new ConfigDataSection(cfg);
                data.add(sec);
                sec.addAll(cfg.getSettingsAsLines());
            }
            sec = new DataSection(DataSections.JVM);
            PlayerUsageSnooper snooper = Minecraft.func_71410_x().func_71378_E();
            Map map = snooper.func_76465_c();
            for (Map.Entry e : map.entrySet()) {
                sec.add((String)e.getKey() + " = " + (String)e.getValue());
            }
            data.add(sec);
            Collections.sort(data);
            ArrayList<String> li = new ArrayList<String>();
            for (DataSection s : data) {
                li.add(this.getDivider());
                li.add(s.title());
                li.add(this.getDivider());
                li.addAll(s.data);
                li.add("");
                li.add("");
            }
            li.add("Checksum:");
            li.add(this.computeHash(li));
            ReikaFileReader.writeLinesToFile(f, li, true);
            return f;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getDivider() {
        return ReikaStringParser.getNOf("-", 20);
    }

    private String computeHash(ArrayList<String> li) {
        int maxlen = -1;
        for (String s : li) {
            maxlen = Math.max(maxlen, s.length());
        }
        long[] hashes = new long[maxlen];
        Random rand = new Random(HASH_SALT.hashCode());
        rand.nextBoolean();
        rand.nextBoolean();
        for (int i = 0; i < hashes.length; ++i) {
            hashes[i] = rand.nextLong();
        }
        int rotate = 0;
        for (String s : li) {
            int i = 0;
            while (i < Math.min(s.length(), hashes.length)) {
                int c = s.charAt(i) & 0x7F;
                c = Integer.rotateLeft(c, rotate);
                rotate += 3;
                int high = i % 4 * 8;
                int val = c << high;
                int n = i++;
                hashes[n] = hashes[n] ^ (long)val;
            }
        }
        ByteBuffer buf = ByteBuffer.allocate(hashes.length * 8);
        for (long val : hashes) {
            buf.putLong(val);
        }
        return ReikaFileReader.HashType.SHA256.hash(buf.array());
    }

    private static enum DataSections {
        INFO("General Info"),
        CRASHREP("System Report"),
        OPTIONS("Game Settings"),
        MODS("Mods"),
        CONFIGS("Config - "),
        JVM("JVM/OS Parameters");

        public final String title;

        private DataSections(String s) {
            this.title = s;
        }

        public boolean isSorted() {
            switch (this) {
                case OPTIONS: 
                case MODS: 
                case CONFIGS: {
                    return true;
                }
            }
            return false;
        }
    }

    private static class DataSection
    implements Comparable<DataSection> {
        private final DataSections type;
        private final ArrayList<String> data = new ArrayList();

        protected DataSection(DataSections s) {
            this.type = s;
        }

        protected final void add(String s) {
            this.data.add(s);
            if (this.type.isSorted()) {
                Collections.sort(this.data);
            }
        }

        protected final void addAll(Collection<String> c) {
            this.data.addAll(c);
            if (this.type.isSorted()) {
                Collections.sort(this.data);
            }
        }

        @Override
        public int compareTo(DataSection o) {
            return this.type.compareTo(o.type);
        }

        public String title() {
            return this.type.title;
        }
    }

    private static class ConfigDataSection
    extends DataSection {
        private final DragonAPIMod modname;

        protected ConfigDataSection(ControlledConfig cfg) {
            super(DataSections.CONFIGS);
            this.modname = cfg.configMod;
        }

        @Override
        public String title() {
            return super.title() + this.modname.getDisplayName();
        }

        @Override
        public int compareTo(DataSection o) {
            if (o instanceof ConfigDataSection) {
                return this.compareMods(this.modname, ((ConfigDataSection)o).modname);
            }
            return super.compareTo(o);
        }

        private int compareMods(DragonAPIMod mod1, DragonAPIMod mod2) {
            String id2;
            String id1 = mod1.getModContainer().getModId().toLowerCase(Locale.ENGLISH);
            if (id1.equals(id2 = mod2.getModContainer().getModId().toLowerCase(Locale.ENGLISH))) {
                return 0;
            }
            if (id1.equals("dragonapi")) {
                return -1;
            }
            if (id2.equals("dragonapi")) {
                return 1;
            }
            return id1.compareToIgnoreCase(id2);
        }
    }
}

