/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.BlockStruct;

import Reika.DragonAPI.Instantiable.Data.Immutable.BlockBox;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class AbstractSearch {
    protected final HashSet<Coordinate> searchedCoords = new HashSet();
    public final Coordinate root;
    public BlockBox limit = BlockBox.infinity();
    public int depthLimit = Integer.MAX_VALUE;
    private LinkedList<Coordinate> result = new LinkedList();

    public AbstractSearch(int x, int y, int z) {
        this.root = new Coordinate(x, y, z);
        this.searchedCoords.add(this.root);
    }

    public abstract boolean tick(World var1, PropagationCondition var2, TerminationCondition var3);

    public abstract boolean isDone();

    public abstract void clear();

    public final LinkedList<Coordinate> getResult() {
        return this.result;
    }

    public final Set<Coordinate> getTotalSearchedCoords() {
        return Collections.unmodifiableSet(this.searchedCoords);
    }

    public void complete(World world, PropagationCondition propagation, TerminationCondition terminate) {
        while (!this.tick(world, propagation, terminate)) {
        }
    }

    protected final boolean isValidLocation(World world, int x, int y, int z, Coordinate from, PropagationCondition p, TerminationCondition c) {
        return p.isValidLocation(world, x, y, z, from) || c.isValidTerminus(world, x, y, z);
    }

    protected ArrayList<Coordinate> getNextSearchCoordsFor(World world, Coordinate c) {
        return (ArrayList)c.getAdjacentCoordinates();
    }

    public static final class PassablePropagation
    implements PropagationCondition {
        public static final PassablePropagation instance = new PassablePropagation();

        private PassablePropagation() {
        }

        @Override
        public boolean isValidLocation(World world, int x, int y, int z, Coordinate from) {
            return !ReikaBlockHelper.isCollideable(world, x, y, z);
        }
    }

    public static final class WalkablePropagation
    implements PropagationCondition {
        public static final WalkablePropagation instance = new WalkablePropagation();

        private WalkablePropagation() {
        }

        @Override
        public boolean isValidLocation(World world, int x, int y, int z, Coordinate from) {
            return PassablePropagation.instance.isValidLocation(world, x, y, z, from) && (!PassablePropagation.instance.isValidLocation(world, x, y - 1, z, from) || !PassablePropagation.instance.isValidLocation(world, x, y - 2, z, from));
        }
    }

    public static final class DirectionalPropagation
    implements PropagationCondition {
        public final Coordinate location;
        public final boolean requireCloser;

        public DirectionalPropagation(Coordinate c, boolean cl) {
            this.location = c;
            this.requireCloser = cl;
        }

        @Override
        public boolean isValidLocation(World world, int x, int y, int z, Coordinate from) {
            int d0 = from.getTaxicabDistanceTo(this.location);
            int d1 = new Coordinate(x, y, z).getTaxicabDistanceTo(this.location);
            return this.requireCloser ? d1 < d0 : d0 < d1;
        }
    }

    public static final class AirPropagation
    implements PropagationCondition {
        public static final AirPropagation instance = new AirPropagation();

        private AirPropagation() {
        }

        @Override
        public boolean isValidLocation(World world, int x, int y, int z, Coordinate from) {
            return world.func_147439_a(x, y, z).isAir((IBlockAccess)world, x, y, z);
        }
    }

    public static final class CompoundPropagationCondition
    implements PropagationCondition {
        private final ArrayList<PropagationCondition> conditions = new ArrayList();

        public CompoundPropagationCondition addCondition(PropagationCondition pc) {
            this.conditions.add(pc);
            return this;
        }

        @Override
        public boolean isValidLocation(World world, int x, int y, int z, Coordinate from) {
            for (PropagationCondition pc : this.conditions) {
                if (pc.isValidLocation(world, x, y, z, from)) continue;
                return false;
            }
            return true;
        }
    }

    public static interface PropagationCondition {
        public boolean isValidLocation(World var1, int var2, int var3, int var4, Coordinate var5);
    }

    public static final class LocationTerminus
    implements TerminationCondition,
    FixedPositionTarget {
        public final Coordinate target;

        public LocationTerminus(Coordinate c) {
            this.target = c;
        }

        @Override
        public boolean isValidTerminus(World world, int x, int y, int z) {
            return this.target.equals(x, y, z);
        }

        @Override
        public Coordinate getTarget() {
            return this.target;
        }
    }

    public static interface FixedPositionTarget {
        public Coordinate getTarget();
    }

    public static interface TerminationCondition {
        public boolean isValidTerminus(World var1, int var2, int var3, int var4);
    }
}

