/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.BlockStruct;

import Reika.DragonAPI.Instantiable.Data.BlockStruct.AbstractSearch;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.OpenPathFinder;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockBox;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class BreadthFirstSearch
extends AbstractSearch {
    private final Collection<SearchHead> activeSearches = new ArrayList<SearchHead>();
    private final Collection<SearchHead> exhaustedSearches = new ArrayList<SearchHead>();
    private final ArrayList<SearchHead> currentlyCalculating = new ArrayList();
    public int perCycleCalcLimit = Integer.MAX_VALUE;

    public BreadthFirstSearch(int x, int y, int z) {
        super(x, y, z);
        this.activeSearches.add(new SearchHead(this.root));
    }

    private boolean calculateCurrentQueue(World world, AbstractSearch.PropagationCondition propagation, AbstractSearch.TerminationCondition terminate) {
        for (int cycles = 0; !this.currentlyCalculating.isEmpty() && cycles < this.perCycleCalcLimit; ++cycles) {
            SearchHead s = this.currentlyCalculating.remove(0);
            s.isExhausted = true;
            ArrayList<Coordinate> li = this.getNextSearchCoordsFor(world, s.headLocation);
            ArrayList li2 = new ArrayList();
            for (Coordinate c : li) {
                if (c.yCoord < 0 || c.yCoord >= 256 || this.searchedCoords.contains(c) || !this.isValidLocation(world, c.xCoord, c.yCoord, c.zCoord, s.headLocation, propagation, terminate) || s.length() >= this.depthLimit || !this.limit.isBlockInside(c.xCoord, c.yCoord, c.zCoord)) continue;
                s.isExhausted = false;
                if (terminate != null && terminate.isValidTerminus(world, c.xCoord, c.yCoord, c.zCoord)) {
                    this.activeSearches.clear();
                    this.getResult().addAll(s.path);
                    this.getResult().add(c);
                    return true;
                }
                this.searchedCoords.add(c);
                this.activeSearches.add(s.extendTo(c));
            }
            if (!s.isExhausted) continue;
            this.exhaustedSearches.add(s);
        }
        return false;
    }

    @Override
    public boolean tick(World world, AbstractSearch.PropagationCondition propagation, AbstractSearch.TerminationCondition terminate) {
        if (this.currentlyCalculating.isEmpty()) {
            this.currentlyCalculating.addAll(this.activeSearches);
            this.activeSearches.clear();
        }
        if (this.calculateCurrentQueue(world, propagation, terminate)) {
            return true;
        }
        return this.isDone();
    }

    @Override
    public boolean isDone() {
        return this.activeSearches.isEmpty();
    }

    @Override
    public void clear() {
        this.searchedCoords.clear();
        this.activeSearches.clear();
        this.exhaustedSearches.clear();
        this.currentlyCalculating.clear();
        this.getResult().clear();
        System.gc();
    }

    public Collection<ArrayList<Coordinate>> getPathsTried() {
        ArrayList<ArrayList<Coordinate>> ret = new ArrayList<ArrayList<Coordinate>>();
        for (SearchHead s : this.exhaustedSearches) {
            ret.add(new ArrayList(s.path));
        }
        return ret;
    }

    @Override
    public void complete(World world, AbstractSearch.PropagationCondition propagation, AbstractSearch.TerminationCondition terminate) {
        while (!this.tick(world, propagation, terminate)) {
        }
    }

    public static LinkedList<Coordinate> getPath(World world, double x, double y, double z, AbstractSearch.TerminationCondition t, AbstractSearch.PropagationCondition c) {
        return BreadthFirstSearch.getPath(world, x, y, z, t, c, null);
    }

    public static LinkedList<Coordinate> getPath(World world, double x, double y, double z, AbstractSearch.TerminationCondition t, AbstractSearch.PropagationCondition c, BlockBox bounds) {
        BreadthFirstSearch s = new BreadthFirstSearch(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
        if (bounds != null) {
            s.limit = bounds;
        }
        while (!s.tick(world, c, t)) {
        }
        return s.getResult().isEmpty() ? null : s.getResult();
    }

    public static LinkedList<Coordinate> getOpenPathBetween(World world, double x1, double y1, double z1, double x2, double y2, double z2, int r) {
        Coordinate start = new Coordinate(x1, y1, z1);
        Coordinate end = new Coordinate(x2, y2, z2);
        return BreadthFirstSearch.getOpenPathBetween(world, start, end, r);
    }

    public static LinkedList<Coordinate> getOpenPathBetween(World world, Coordinate start, Coordinate end, int r) {
        return BreadthFirstSearch.getOpenPathBetween(world, start, end, r, null);
    }

    public static LinkedList<Coordinate> getOpenPathBetween(World world, Coordinate start, Coordinate end, int r, BlockBox bounds) {
        OpenPathFinder f = new OpenPathFinder(start, end, r);
        AbstractSearch.LocationTerminus t = new AbstractSearch.LocationTerminus(end);
        return BreadthFirstSearch.getPath(world, start.xCoord, start.yCoord, start.zCoord, t, f, bounds);
    }

    private static class SearchHead {
        private LinkedList<Coordinate> path = new LinkedList();
        private Coordinate headLocation;
        private boolean isExhausted = false;

        private SearchHead(Coordinate c) {
            this.headLocation = c;
            this.path.add(c);
        }

        public int length() {
            return this.path.size();
        }

        public SearchHead extendTo(Coordinate c) {
            SearchHead s = new SearchHead(this.headLocation);
            s.path = new LinkedList<Coordinate>(this.path);
            s.path.add(c);
            s.headLocation = c;
            return s;
        }
    }
}

