/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.BlockStruct;

import Reika.DragonAPI.Instantiable.Data.BlockStruct.AbstractSearch;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class OpenPathFinder
implements AbstractSearch.PropagationCondition {
    public final int searchRadius;
    private final Coordinate startLocation;
    private final Coordinate endLocation;

    public OpenPathFinder(Coordinate c1, Coordinate c2, int r) {
        this.startLocation = c1;
        this.endLocation = c2;
        this.searchRadius = Math.max(r, c2.getTaxicabDistanceTo(c1));
    }

    @Override
    public final boolean isValidLocation(World world, int x, int y, int z, Coordinate from) {
        if (this.startLocation.equals(x, y, z) || this.endLocation.equals(x, y, z)) {
            return true;
        }
        if (!this.startLocation.isWithinDistOnAllCoords(x, y, z, this.searchRadius)) {
            return false;
        }
        return this.isValidBlock(world, x, y, z);
    }

    protected boolean isValidBlock(World world, int x, int y, int z) {
        return OpenPathFinder.isEmptyBlock(world, x, y, z);
    }

    public static boolean isEmptyBlock(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        return b.isAir((IBlockAccess)world, x, y, z) || ReikaWorldHelper.softBlocks((IBlockAccess)world, x, y, z);
    }
}

