/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Immutable;

import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Data.Immutable.LineSegment;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public final class DecimalLineSegment {
    public final DecimalPosition origin;
    public final DecimalPosition target;

    public DecimalLineSegment(double x, double y, double z, double x2, double y2, double z2) {
        this.origin = new DecimalPosition(x, y, z);
        this.target = new DecimalPosition(x2, y2, z2);
    }

    public DecimalLineSegment(DecimalPosition c1, DecimalPosition c2) {
        this(c1.xCoord, c1.yCoord, c1.zCoord, c2.xCoord, c2.yCoord, c2.zCoord);
    }

    public static final DecimalLineSegment getFromXYZDir(double x1, double y1, double z1, ForgeDirection dir, double len) {
        return new DecimalLineSegment(x1, y1, z1, x1 + len * (double)dir.offsetX, y1 + len * (double)dir.offsetY, z1 + len * (double)dir.offsetZ);
    }

    public static final DecimalLineSegment getFromXYZDir(double x1, double y1, double z1, ReikaDirectionHelper.CubeDirections dir, double len) {
        return new DecimalLineSegment(x1, y1, z1, MathHelper.func_76128_c((double)(x1 + len * dir.offsetX)), y1, MathHelper.func_76128_c((double)(z1 + len * dir.offsetZ)));
    }

    public double getLength() {
        return this.target.getDistanceTo(this.origin);
    }

    public String toString() {
        return this.origin.toString() + " >> " + this.target.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof DecimalLineSegment) {
            DecimalLineSegment ls = (DecimalLineSegment)o;
            return ls.origin.equals(this.origin) && ls.target.equals(this.target);
        }
        return false;
    }

    public int hashCode() {
        return this.origin.hashCode() ^ this.target.hashCode();
    }

    public DecimalPosition findIntersection(LineSegment l) {
        return this.findIntersection(l.asDecimalSegment());
    }

    public DecimalPosition findIntersection(DecimalLineSegment l) {
        return null;
    }

    public DecimalPosition findIntersection2D(DecimalLineSegment l) {
        double x1 = this.origin.xCoord;
        double x2 = this.target.xCoord;
        double y3 = l.origin.zCoord;
        double y4 = l.target.zCoord;
        double y1 = this.origin.zCoord;
        double y2 = this.target.zCoord;
        double x3 = l.origin.xCoord;
        double x4 = l.target.xCoord;
        double denom = (x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4);
        if (denom == 0.0) {
            return null;
        }
        double px = ((x1 * y2 - y1 * x2) * (x3 - x4) - (x1 - x2) * (x3 * y4 - y3 * x4)) / denom;
        double pz = ((x1 * y2 - y1 * x2) * (y3 - y4) - (y1 - y2) * (x3 * y4 - y3 * x4)) / denom;
        if (px < this.origin.xCoord && px < this.target.xCoord || px > this.origin.xCoord && px > this.target.xCoord) {
            return null;
        }
        if (pz < this.origin.zCoord && pz < this.target.zCoord || pz > this.origin.zCoord && pz > this.target.zCoord) {
            return null;
        }
        if (px < l.origin.xCoord && px < l.target.xCoord || px > l.origin.xCoord && px > l.target.xCoord) {
            return null;
        }
        if (pz < l.origin.zCoord && pz < l.target.zCoord || pz > l.origin.zCoord && pz > l.target.zCoord) {
            return null;
        }
        return new DecimalPosition(px, 0.0, pz);
    }
}

