/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Maps;

import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SequenceMap<V> {
    private final HashMap<V, TreeEntry<V>> data = new HashMap();

    public Collection<V> getParents(V obj) {
        TreeEntry<V> t = this.data.get(obj);
        return t != null ? Collections.unmodifiableCollection(((TreeEntry)t).parents) : null;
    }

    public Collection<V> getChildren(V obj) {
        TreeEntry<V> t = this.data.get(obj);
        return t != null ? Collections.unmodifiableCollection(((TreeEntry)t).children) : null;
    }

    public Collection<V> getRecursiveParents(V obj) {
        ArrayList c = new ArrayList();
        TreeEntry<V> tree = this.data.get(obj);
        if (tree != null) {
            for (Object par : ((TreeEntry)tree).parents) {
                c.add(par);
                c.addAll(this.getRecursiveParents(par));
            }
        }
        return c;
    }

    public Collection<V> getRecursiveChildren(V obj) {
        ArrayList c = new ArrayList();
        TreeEntry<V> tree = this.data.get(obj);
        if (tree != null) {
            for (Object par : ((TreeEntry)tree).children) {
                c.add(par);
                c.addAll(this.getRecursiveChildren(par));
            }
        }
        return c;
    }

    public void addParent(V obj, V parent) {
        this.addParent(obj, parent, true);
    }

    public void addChild(V obj, V child) {
        this.addChild(obj, child, true);
    }

    public void addChildless(V obj) {
        this.data.put(obj, new TreeEntry());
    }

    private void addParent(V obj, V parent, boolean cross) {
        TreeEntry<V> tree = this.data.get(obj);
        if (tree == null) {
            tree = new TreeEntry();
            this.data.put((TreeEntry<V>)obj, (TreeEntry<TreeEntry<V>>)tree);
        }
        ((TreeEntry)tree).parents.add(parent);
        if (cross) {
            this.addChild(parent, obj, false);
        }
    }

    private void addChild(V obj, V child, boolean cross) {
        TreeEntry<V> tree = this.data.get(obj);
        if (tree == null) {
            tree = new TreeEntry();
            this.data.put((TreeEntry<V>)obj, (TreeEntry<TreeEntry<V>>)tree);
        }
        ((TreeEntry)tree).children.add(child);
        if (cross) {
            this.addParent(child, obj, false);
        }
    }

    public boolean containsStep(V p1, V p2) {
        TreeEntry<V> tree = this.data.get(p1);
        return tree != null && ((TreeEntry)tree).children.contains(p2);
    }

    public boolean hasElementAsParent(V obj) {
        return this.data.containsKey(obj);
    }

    public boolean hasElementAsChild(V obj) {
        for (TreeEntry<V> e : this.data.values()) {
            if (!((TreeEntry)e).children.contains(obj)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.data.clear();
    }

    public Topology<V> getTopology() {
        return this.getTopology(new HashMap());
    }

    public Topology<V> getTopology(Map<V, Integer> initialValues) {
        return new Topology(this, initialValues);
    }

    public Collection valueSet() {
        ArrayList values = new ArrayList();
        for (TreeEntry<V> t : this.data.values()) {
            values.addAll(((TreeEntry)t).children);
        }
        return values;
    }

    public Collection fullSet() {
        Collection values = this.valueSet();
        for (V obj : this.data.keySet()) {
            if (values.contains(obj)) continue;
            values.add(obj);
        }
        return values;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (V v : this.data.keySet()) {
            TreeEntry<V> e = this.data.get(v);
            if (!((TreeEntry)e).parents.isEmpty()) continue;
            sb.append(this.getKeyString(v));
        }
        return sb.toString();
    }

    private String getKeyString(V v) {
        StringBuilder sb = new StringBuilder();
        TreeEntry<V> e = this.data.get(v);
        sb.append(v);
        sb.append("={");
        for (Object in : ((TreeEntry)e).children) {
            sb.append(this.getKeyString(in));
        }
        sb.append("}");
        return sb.toString();
    }

    public static class Topology<V> {
        private final SequenceMap<V> map;
        private final HashMap<V, Integer> depths = new HashMap();
        private final MultiMap<Integer, V> depthInverse = new MultiMap();
        private int maxDepth = 0;

        private Topology(SequenceMap m, Map<V, Integer> initialValues) {
            this.map = m;
            this.calculateDepths(initialValues);
        }

        private void calculateDepths(Map<V, Integer> initialValues) {
            ArrayList c = new ArrayList(this.map.fullSet());
            for (Object obj : c) {
                Integer n = initialValues.get(obj);
                int val = n != null ? n : 0;
                this.depths.put((Integer)obj, val);
            }
            boolean change = false;
            do {
                change = false;
                Iterator<Object> it = c.iterator();
                while (it.hasNext()) {
                    Object e = it.next();
                    boolean locchange = false;
                    Collection par = this.getParents(e);
                    for (Object p : par) {
                        int o = this.depths.get(e);
                        int d = this.depths.get(p) + 1;
                        if (d <= o) continue;
                        this.depths.put((Integer)e, d);
                        this.maxDepth = Math.max(this.maxDepth, d);
                        change = true;
                        locchange = true;
                    }
                    if (locchange) continue;
                    it.remove();
                }
            } while (change);
            for (Map.Entry entry : this.depths.entrySet()) {
                this.depthInverse.addValue((Integer)entry.getValue(), entry.getKey());
            }
            if (this.depthInverse.keySet().size() < this.maxDepth) {
                ArrayList<Integer> li = new ArrayList<Integer>(this.depthInverse.keySet());
                HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
                Collections.sort(li);
                for (int idx = 0; idx < li.size(); ++idx) {
                    int val = li.get(idx);
                    if (idx == val) continue;
                    hashMap.put(val, idx);
                }
                if (!hashMap.isEmpty()) {
                    Collection<V> c2;
                    HashMap replInv = new HashMap();
                    for (Map.Entry e : hashMap.entrySet()) {
                        c2 = this.depthInverse.remove((Integer)e.getKey());
                        replInv.put(e.getValue(), c2);
                    }
                    for (Map.Entry e : replInv.entrySet()) {
                        this.depthInverse.put((Integer)e.getKey(), (Collection)e.getValue());
                    }
                    this.depths.clear();
                    for (Integer depth : this.depthInverse.keySet()) {
                        c2 = this.depthInverse.get(depth);
                        for (V v : c2) {
                            this.depths.put((Integer)v, depth);
                        }
                    }
                }
            }
        }

        public int getNumberParents(V obj) {
            return ((TreeEntry)((SequenceMap)this.map).data.get(obj)).parents.size();
        }

        public int getNumberChildren(V obj) {
            return ((TreeEntry)((SequenceMap)this.map).data.get(obj)).children.size();
        }

        public Collection<V> getChildren(V obj) {
            return this.map.getChildren(obj);
        }

        public Collection<V> getParents(V obj) {
            return this.map.getParents(obj);
        }

        public Map<V, Integer> getDepthMap() {
            return Collections.unmodifiableMap(this.depths);
        }

        public Collection<V> getByDepth(int depth) {
            return Collections.unmodifiableCollection(this.depthInverse.get(depth));
        }

        public String toString() {
            return this.depths.toString();
        }

        public int getMaxDepth() {
            return this.maxDepth;
        }
    }

    private static class TreeEntry<V> {
        private Collection<V> parents = new ArrayList<V>();
        private Collection<V> children = new ArrayList<V>();

        private TreeEntry() {
        }
    }
}

