/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Maps;

import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

public class TierMap<V> {
    private int maxTier;
    private final HashMap<V, Integer> data = new HashMap();
    private final MultiMap<Integer, V> tiers = new MultiMap(MultiMap.CollectionType.HASHSET);

    public void addObject(V val, int tier) {
        this.data.put((Integer)val, tier);
        this.tiers.addValue(tier, val);
        this.maxTier = Math.max(this.maxTier, tier);
    }

    public int getTier(V val) {
        Integer ret = this.data.get(val);
        return ret != null ? ret : -1;
    }

    public Set<V> getByTier(int tier) {
        return Collections.unmodifiableSet((Set)this.tiers.get(tier));
    }

    public int getMaxTier() {
        return this.maxTier;
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public void clear() {
        this.data.clear();
        this.tiers.clear();
        this.maxTier = -1;
    }

    public boolean containsKey(V val) {
        return this.data.containsKey(val);
    }
}

