/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data;

import Reika.DragonAPI.Instantiable.Data.BlockStruct.AbstractSearch;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BreadthFirstSearch;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockBox;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Interfaces.EntityPathfinder;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class RoutingWeb
implements EntityPathfinder {
    private static final AbstractSearch.PropagationCondition passableBlocks = AbstractSearch.PassablePropagation.instance;
    private static final AbstractSearch.PropagationCondition walkableBlocks = AbstractSearch.WalkablePropagation.instance;
    private final Coordinate root;
    private final BreadthFirstSearch pathfinder;
    private final AbstractSearch.PropagationCondition propagation;
    private final HashMap<Coordinate, Coordinate> pathMap = new HashMap();

    public RoutingWeb(TileEntity te, int rx, int ry, int rz, boolean canFly) {
        this(te.field_145851_c, te.field_145848_d, te.field_145849_e, rx, ry, rz, canFly);
    }

    public RoutingWeb(int x, int y, int z, int rx, int ry, int rz, boolean canFly) {
        this.pathfinder = new BreadthFirstSearch(x, y, z);
        this.root = new Coordinate(x, y, z);
        this.pathfinder.limit = BlockBox.block(x, y, z).expand(rx, ry, rz);
        this.pathfinder.perCycleCalcLimit = 2048;
        this.propagation = new AbstractSearch.CompoundPropagationCondition().addCondition(canFly ? passableBlocks : walkableBlocks);
    }

    public boolean runCalc(World world) {
        return this.pathfinder.tick(world, this.propagation, null);
    }

    public BlockBox getAoE() {
        return this.pathfinder.limit;
    }

    public void buildPaths() {
        for (ArrayList<Coordinate> li : this.pathfinder.getPathsTried()) {
            for (int i = 0; i < li.size(); ++i) {
                Coordinate c = li.get(i);
                Coordinate c2 = i == 0 ? this.root : li.get(i - 1);
                this.pathMap.put(c, c2);
            }
        }
        this.pathfinder.clear();
    }

    public Coordinate getNextCoordinateAlongPath(Coordinate c) {
        Coordinate ret = this.pathMap.get(c);
        return ret;
    }

    @Override
    public DecimalPosition getNextWaypoint(Entity e) {
        return new DecimalPosition(this.getNextCoordinateAlongPath(new Coordinate(e)));
    }

    @Override
    public boolean isInRange(Entity e) {
        return this.getAoE().isBlockInside(new Coordinate(e));
    }

    public boolean isDone() {
        return this.pathfinder.isDone();
    }
}

