/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class RunningAverage {
    private int numberDataPoints;
    private double currentAverage;

    public void addValue(double val) {
        this.currentAverage = this.numberDataPoints == 0 ? val : (this.currentAverage * (double)this.numberDataPoints + val) / (double)(1 + this.numberDataPoints);
        ++this.numberDataPoints;
    }

    public double getAverage() {
        return this.currentAverage;
    }

    public void readFromNBT(String key, NBTTagCompound nbt) {
        NBTTagCompound tag = nbt.func_74775_l(key);
        this.numberDataPoints = tag.func_74762_e("npoints");
        this.currentAverage = tag.func_74769_h("avg");
    }

    public void writeToNBT(String key, NBTTagCompound nbt) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("npoints", this.numberDataPoints);
        tag.func_74780_a("avg", this.currentAverage);
        nbt.func_74782_a(key, (NBTBase)tag);
    }
}

