/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data;

import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import java.util.Random;

public class ShuffledGrid {
    public final int gridSize;
    public final int maxDeviation;
    public final int averageSeparation;
    private final boolean[][] data;

    public ShuffledGrid(int size, int dev, int sep) {
        this(size, dev, sep, false);
    }

    public ShuffledGrid(int size, int dev, int sep, boolean allowOverlap) {
        this.gridSize = size;
        this.maxDeviation = dev;
        this.averageSeparation = sep;
        if (dev >= sep / 2 && !allowOverlap) {
            throw new IllegalArgumentException("Shuffled grid may have row overlap: " + sep + " +/- " + dev + "!");
        }
        this.data = new boolean[size][size];
    }

    public void calculate(long seed) {
        this.calculate(new Random(seed));
    }

    public void calculate(Random rand) {
        rand.nextBoolean();
        rand.nextBoolean();
        for (int x = 0; x < this.gridSize; x += this.averageSeparation) {
            for (int z = 0; z < this.gridSize; z += this.averageSeparation) {
                int x2 = ReikaRandomHelper.getRandomPlusMinus(x, this.maxDeviation, rand);
                int z2 = ReikaRandomHelper.getRandomPlusMinus(z, this.maxDeviation, rand);
                x2 = (x2 + this.gridSize) % this.gridSize;
                z2 = (z2 + this.gridSize) % this.gridSize;
                this.data[x2][z2] = true;
            }
        }
    }

    public boolean isValid(int x, int z) {
        x = (x % this.gridSize + this.gridSize) % this.gridSize;
        z = (z % this.gridSize + this.gridSize) % this.gridSize;
        return this.data[x][z];
    }
}

