/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data;

import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Instantiable.Data.Maps.CountMap;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class StatisticalRandom<K> {
    private final CountMap<K> data = new CountMap();
    private final HashSet<K> options = new HashSet();
    private ReikaNBTHelper.NBTIO<K> converter;

    public StatisticalRandom() {
    }

    public StatisticalRandom(Collection<K> set) {
        this.options.addAll(set);
    }

    public StatisticalRandom(K ... set) {
        this(ReikaJavaLibrary.makeListFromArray(set));
    }

    public StatisticalRandom(Class<? extends K> set) {
        if (!set.isEnum()) {
            throw new MisuseException("You can only specify enum types via a class reference!");
        }
        K[] data = set.getEnumConstants();
        this.options.addAll(ReikaJavaLibrary.makeListFromArray(data));
        this.setNBTConverter(new ReikaNBTHelper.EnumNBTConverter(set));
    }

    public void setNBTConverter(ReikaNBTHelper.NBTIO<K> c) {
        this.converter = c;
    }

    public K roll() {
        return this.roll(null);
    }

    public K roll(WeightedRandom<K> base) {
        K result = this.genRandom(base).getRandomEntry();
        this.data.increment(result);
        return result;
    }

    private WeightedRandom<K> genRandom(WeightedRandom<K> base) {
        WeightedRandom<K> w = new WeightedRandom<K>();
        for (K k : this.options) {
            double wt = this.getWeightOf(base, k);
            if (!(wt > 0.0)) continue;
            w.addEntry(k, wt);
        }
        return w;
    }

    private double getWeightOf(WeightedRandom<K> src, K k) {
        double base = 1.0 / (double)this.options.size();
        double frac = this.data.getFraction(k);
        if (src != null) {
            base *= src.getWeight(k) / src.getTotalWeight();
        }
        double chance = base - (frac - base);
        return chance;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.data.clear();
        HashSet set = new HashSet();
        this.data.readFromNBT(tag.func_74775_l("data"), this.converter);
        ReikaNBTHelper.readCollectionFromNBT(set, tag, "set", this.converter);
        this.options.addAll(set);
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagCompound nbt = new NBTTagCompound();
        this.data.writeToNBT(nbt, this.converter);
        tag.func_74782_a("data", (NBTBase)nbt);
        ReikaNBTHelper.writeCollectionToNBT(this.options, tag, "set", this.converter);
    }

    public String toString() {
        return this.data.toString() + " > " + this.genRandom(null).toString();
    }
}

