/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Effects;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Rendering.ParticleEngine;
import Reika.DragonAPI.Interfaces.ColorController;
import Reika.DragonAPI.Interfaces.Entity.CustomRenderFX;
import Reika.DragonAPI.Interfaces.MotionController;
import Reika.DragonAPI.Interfaces.PositionController;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class EntityBlurFX
extends EntityFX
implements CustomRenderFX {
    private float scale;
    private boolean noSlow = false;
    private boolean rapidExpand = false;
    private boolean alphaFade = false;
    private AxisAlignedBB bounds = null;
    private int bounceAction = 0;
    private double collideAngle;
    private boolean colliding = false;
    private int clearOnCollide = -1;
    private int lifeFreeze;
    private int preColor = -1;
    private int fadeColor = -1;
    private float defaultRed;
    private float defaultGreen;
    private float defaultBlue;
    private double accelerationX;
    private double accelerationY;
    private double accelerationZ;
    private double drag;
    private Coordinate destination;
    private EntityFX lock;
    private Collection<EntityFX> locks = new HashSet<EntityFX>();
    private boolean additiveBlend = true;
    private boolean depthTest = true;
    private boolean alphaTest = false;
    private boolean renderOverLimit = false;
    private ParticleEngine.RenderMode renderMode;
    private MotionController motionController;
    private PositionController positionController;
    private ColorController colorController;

    public EntityBlurFX(World world, double x, double y, double z, IIcon ico) {
        this(world, x, y, z, 0.0, 0.0, 0.0, ico);
    }

    public EntityBlurFX(World world, double x, double y, double z, double vx, double vy, double vz, IIcon ico) {
        super(world, x, y, z, vx, vy, vz);
        this.field_70545_g = 0.0f;
        this.field_70145_X = true;
        this.field_70547_e = 60;
        this.field_70159_w = vx;
        this.field_70181_x = vy;
        this.field_70179_y = vz;
        this.scale = 1.0f;
        this.alphaTest = false;
        this.additiveBlend = true;
        this.field_70550_a = ico;
    }

    public final EntityBlurFX setIcon(IIcon ii) {
        this.field_70550_a = ii;
        return this;
    }

    public final EntityBlurFX setScale(float f) {
        this.scale = f;
        return this;
    }

    public final EntityBlurFX setLife(int time) {
        this.field_70547_e = time;
        return this;
    }

    public final EntityBlurFX setNoSlowdown() {
        this.noSlow = true;
        return this;
    }

    public final EntityBlurFX setRapidExpand() {
        this.rapidExpand = true;
        return this;
    }

    public final EntityBlurFX setAlphaFading() {
        this.alphaFade = true;
        return this;
    }

    public final EntityBlurFX setGravity(float g) {
        this.field_70545_g = g;
        return this;
    }

    public final EntityBlurFX setDrag(double d) {
        this.drag = d;
        return this;
    }

    public final EntityBlurFX setColor(int r, int g, int b) {
        this.field_70552_h = (float)r / 255.0f;
        this.field_70553_i = (float)g / 255.0f;
        this.field_70551_j = (float)b / 255.0f;
        this.defaultRed = this.field_70552_h;
        this.defaultGreen = this.field_70553_i;
        this.defaultBlue = this.field_70551_j;
        return this;
    }

    public final EntityBlurFX setColor(int rgb) {
        return this.setColor(ReikaColorAPI.getRed(rgb), ReikaColorAPI.getGreen(rgb), ReikaColorAPI.getBlue(rgb));
    }

    public final EntityBlurFX fadeColors(int c1, int c2) {
        this.preColor = c1;
        this.fadeColor = c2;
        return this.setColor(c1);
    }

    public final EntityBlurFX bound(AxisAlignedBB box, boolean bounce, boolean cull) {
        this.bounds = box;
        this.bounceAction = (bounce ? 1 : 0) | (cull ? 2 : 0);
        return this;
    }

    public final EntityBlurFX setColliding() {
        return this.setColliding(-1);
    }

    public final EntityBlurFX setColliding(int clear) {
        return this.setColliding(this.field_70146_Z.nextDouble() * 360.0, clear);
    }

    public final EntityBlurFX setColliding(double ang) {
        return this.setColliding(ang, -1);
    }

    public final EntityBlurFX setColliding(double ang, int clear) {
        this.field_70145_X = false;
        this.colliding = true;
        this.collideAngle = ang;
        this.clearOnCollide = clear;
        this.onSetColliding();
        return this;
    }

    protected void onSetColliding() {
    }

    public final EntityBlurFX markDestination(int x, int y, int z) {
        this.destination = new Coordinate(x, y, z);
        return this;
    }

    public final EntityBlurFX lockTo(EntityFX fx) {
        this.lock = fx;
        if (this == fx) {
            DragonAPICore.logError("Cannot lock a particle to itself!");
            return this;
        }
        if (fx instanceof EntityBlurFX) {
            EntityBlurFX bfx = (EntityBlurFX)fx;
            if (!bfx.getRenderMode().equals(this.getRenderMode())) {
                DragonAPICore.logError("Cannot accurately lock two different particle render types: " + fx + " & " + this);
            }
            bfx.locks.add(this);
        }
        return this;
    }

    public final EntityBlurFX setAcceleration(double x, double y, double z) {
        this.accelerationX = x;
        this.accelerationY = y;
        this.accelerationZ = z;
        return this;
    }

    public final EntityBlurFX setAdditiveBlend() {
        this.additiveBlend = true;
        this.renderMode = null;
        return this;
    }

    public final EntityBlurFX setBasicBlend() {
        this.additiveBlend = false;
        this.renderMode = null;
        return this;
    }

    public final EntityBlurFX setNoDepthTest() {
        this.depthTest = false;
        this.renderMode = null;
        return this;
    }

    public final EntityBlurFX enableAlphaTest() {
        this.alphaTest = true;
        this.renderMode = null;
        return this;
    }

    public final EntityBlurFX forceIgnoreLimits() {
        this.renderOverLimit = true;
        return this;
    }

    public final EntityBlurFX setAge(int age) {
        this.field_70546_d = age;
        return this;
    }

    public final EntityBlurFX freezeLife(int ticks) {
        this.lifeFreeze = ticks;
        return this;
    }

    public final EntityBlurFX setMotionController(MotionController m) {
        this.motionController = m;
        return this;
    }

    public final EntityBlurFX setPositionController(PositionController m) {
        this.positionController = m;
        return this;
    }

    public final EntityBlurFX setColorController(ColorController m) {
        this.colorController = m;
        return this;
    }

    protected final boolean isAlphaFade() {
        return this.alphaFade;
    }

    public final int getMaxAge() {
        return this.field_70547_e;
    }

    public final int getMaximumSizeAge() {
        return this.rapidExpand ? this.field_70547_e / 12 : this.field_70547_e / 2;
    }

    public void func_70071_h_() {
        Coordinate c;
        this.field_70173_aa = this.field_70546_d;
        if (this.field_70546_d < 0) {
            return;
        }
        if (this.colliding) {
            if (this.field_70124_G) {
                double v = this.field_70146_Z.nextDouble() * 0.0625;
                if (Double.isFinite(this.collideAngle)) {
                    this.field_70159_w = v * Math.sin(Math.toRadians(this.collideAngle));
                    this.field_70179_y = v * Math.cos(Math.toRadians(this.collideAngle));
                } else {
                    double vel = ReikaMathLibrary.py3d(this.field_70159_w, 0.0, this.field_70179_y);
                    this.field_70159_w = this.field_70159_w * v / vel;
                    this.field_70179_y = this.field_70179_y * v / vel;
                }
                this.colliding = false;
                this.setNoSlowdown();
                if (this.clearOnCollide != Integer.MIN_VALUE) {
                    this.lifeFreeze = this.clearOnCollide >= 0 ? Math.min(this.clearOnCollide, 20) : 20;
                }
                this.field_70545_g *= 4.0f;
                if (this.clearOnCollide >= 0) {
                    this.setLife(Math.max(1, this.clearOnCollide - this.lifeFreeze));
                }
                this.onCollision();
            }
            if (this.field_70123_F) {
                // empty if block
            }
        }
        if (this.destination != null && (c = new Coordinate((Entity)this)).equals(this.destination)) {
            this.func_70106_y();
        }
        this.field_70159_w += this.accelerationX;
        this.field_70181_x += this.accelerationY;
        this.field_70179_y += this.accelerationZ;
        if (this.noSlow) {
            double mx = this.field_70159_w;
            double my = this.field_70181_x;
            double mz = this.field_70179_y;
            super.func_70071_h_();
            this.field_70159_w = mx;
            this.field_70181_x = my;
            this.field_70179_y = mz;
        } else {
            if (this.drag != 0.0) {
                this.field_70159_w *= this.drag;
                this.field_70181_x *= this.drag;
                this.field_70179_y *= this.drag;
            }
            super.func_70071_h_();
        }
        if (this.lifeFreeze > 0) {
            --this.lifeFreeze;
            --this.field_70546_d;
        }
        int age = Math.max(this.field_70546_d, 1);
        if (this.fadeColor != -1) {
            int c2 = ReikaColorAPI.mixColors(this.fadeColor, this.preColor, (float)age / (float)this.field_70547_e);
            this.setColor(c2);
        }
        if (this.alphaFade) {
            this.field_70544_f = this.scale;
            float f = 1.0f;
            f = this.rapidExpand ? (this.field_70547_e / age >= 12 ? (float)age * 12.0f / (float)this.field_70547_e : 1.0f - (float)age / (float)this.field_70547_e) : MathHelper.func_76126_a((float)((float)Math.toRadians(180.0 * (double)age / (double)this.field_70547_e)));
            if (this.additiveBlend) {
                this.field_70552_h = this.defaultRed * f;
                this.field_70553_i = this.defaultGreen * f;
                this.field_70551_j = this.defaultBlue * f;
            } else {
                this.field_82339_as = f;
            }
        } else {
            this.field_70544_f = this.rapidExpand ? this.scale * (this.field_70547_e / age >= 12 ? (float)age * 12.0f / (float)this.field_70547_e : 1.0f - (float)age / (float)this.field_70547_e) : this.scale * MathHelper.func_76126_a((float)((float)Math.toRadians(180.0 * (double)age / (double)this.field_70547_e)));
        }
        if (this.bounds != null) {
            boolean cull;
            boolean bounce = (this.bounceAction & 1) != 0;
            boolean bl = cull = (this.bounceAction & 2) != 0;
            if (this.field_70165_t <= this.bounds.field_72340_a && this.field_70159_w < 0.0 || this.field_70165_t >= this.bounds.field_72336_d && this.field_70159_w > 0.0) {
                double d = this.field_70159_w = bounce ? -this.field_70159_w : 0.0;
                if (cull) {
                    this.func_70106_y();
                }
            }
            if (this.field_70163_u <= this.bounds.field_72338_b && this.field_70181_x < 0.0 || this.field_70163_u >= this.bounds.field_72337_e && this.field_70181_x > 0.0) {
                double d = this.field_70181_x = bounce ? -this.field_70181_x : 0.0;
                if (cull) {
                    this.func_70106_y();
                }
            }
            if (this.field_70161_v <= this.bounds.field_72339_c && this.field_70179_y < 0.0 || this.field_70161_v >= this.bounds.field_72334_f && this.field_70179_y > 0.0) {
                double d = this.field_70179_y = bounce ? -this.field_70179_y : 0.0;
                if (cull) {
                    this.func_70106_y();
                }
            }
        }
        if (this.lock != null) {
            this.field_70165_t = this.lock.field_70165_t;
            this.field_70163_u = this.lock.field_70163_u;
            this.field_70161_v = this.lock.field_70161_v;
            this.field_70159_w = this.lock.field_70159_w;
            this.field_70181_x = this.lock.field_70181_x;
            this.field_70179_y = this.lock.field_70179_y;
        }
        if (!this.locks.isEmpty()) {
            for (EntityFX fx : this.locks) {
                fx.field_70159_w = this.field_70159_w;
                fx.field_70181_x = this.field_70181_x;
                fx.field_70179_y = this.field_70179_y;
            }
        }
        if (this.motionController != null) {
            this.field_70159_w = this.motionController.getMotionX((Entity)this);
            this.field_70181_x = this.motionController.getMotionY((Entity)this);
            this.field_70179_y = this.motionController.getMotionZ((Entity)this);
            this.motionController.update((Entity)this);
        }
        if (this.positionController != null) {
            this.field_70165_t = this.positionController.getPositionX((Entity)this);
            this.field_70163_u = this.positionController.getPositionY((Entity)this);
            this.field_70161_v = this.positionController.getPositionZ((Entity)this);
            if (this.positionController != this.motionController) {
                this.positionController.update((Entity)this);
            }
        }
        if (this.colorController != null) {
            int rgb = this.colorController.getColor((Entity)this);
            float f = 1.0f;
            if (this.alphaFade) {
                f = this.rapidExpand ? (this.field_70547_e / age >= 12 ? (float)age * 12.0f / (float)this.field_70547_e : 1.0f - (float)age / (float)this.field_70547_e) : MathHelper.func_76126_a((float)((float)Math.toRadians(180.0 * (double)age / (double)this.field_70547_e)));
            }
            this.field_70552_h = (float)ReikaColorAPI.getRed(rgb) * f / 255.0f;
            this.field_70553_i = (float)ReikaColorAPI.getGreen(rgb) * f / 255.0f;
            this.field_70551_j = (float)ReikaColorAPI.getBlue(rgb) * f / 255.0f;
            this.colorController.update((Entity)this);
        }
    }

    public void func_70091_d(double vx, double vy, double vz) {
        if (this.field_70145_X) {
            super.func_70091_d(vx, vy, vz);
        } else {
            this.field_70139_V *= 0.4f;
            double vxCopy = vx;
            double vyCopy = vy;
            double vzCopy = vz;
            List list = this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D.func_72321_a(vx, vy, vz));
            if (!list.isEmpty()) {
                for (AxisAlignedBB box : list) {
                    vx = box.func_72316_a(this.field_70121_D, vx);
                    vy = box.func_72323_b(this.field_70121_D, vy);
                    vz = box.func_72322_c(this.field_70121_D, vz);
                }
            }
            this.field_70121_D.func_72317_d(vx, vy, vz);
            this.field_70165_t = (this.field_70121_D.field_72340_a + this.field_70121_D.field_72336_d) * 0.5;
            this.field_70163_u = this.field_70121_D.field_72338_b + (double)this.field_70129_M - (double)this.field_70139_V;
            this.field_70161_v = (this.field_70121_D.field_72339_c + this.field_70121_D.field_72334_f) * 0.5;
            this.field_70123_F = vxCopy != vx || vzCopy != vz;
            this.field_70124_G = vyCopy != vy;
            this.field_70122_E = vyCopy != vy && vyCopy < 0.0;
            boolean bl = this.field_70132_H = this.field_70123_F || this.field_70124_G;
            if (this.field_70123_F) {
                this.field_70159_w = 0.0;
                this.field_70179_y = 0.0;
            }
            if (this.field_70124_G) {
                this.field_70181_x = 0.0;
            }
        }
    }

    protected void onCollision() {
    }

    public final int func_70070_b(float par1) {
        return 240;
    }

    public final int func_70537_b() {
        return 2;
    }

    @Override
    public final ParticleEngine.RenderMode getRenderMode() {
        if (this.renderMode == null) {
            this.renderMode = new ParticleEngine.RenderMode().setFlag(ParticleEngine.RenderModeFlags.ADDITIVE, this.additiveBlend).setFlag(ParticleEngine.RenderModeFlags.DEPTH, this.depthTest).setFlag(ParticleEngine.RenderModeFlags.LIGHT, false).setFlag(ParticleEngine.RenderModeFlags.ALPHACLIP, this.alphaTest && this.additiveBlend);
        }
        return this.renderMode;
    }

    @Override
    public final ParticleEngine.TextureMode getTexture() {
        return ParticleEngine.blockTex;
    }

    @Override
    public boolean rendersOverLimit() {
        return this.renderOverLimit;
    }

    @Override
    public double getRenderRange() {
        return this.scale * 96.0f;
    }
}

