/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Effects;

import Reika.DragonAPI.Interfaces.MotionController;
import Reika.DragonAPI.Interfaces.PositionController;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Rendering.ReikaLiquidRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public class EntityFluidFX
extends EntityFX {
    private Fluid type;
    private MotionController motionController;
    private PositionController positionController;
    private boolean colliding = false;

    public EntityFluidFX(World world, double x, double y, double z, Fluid f) {
        this(world, x, y, z, 0.0, 0.0, 0.0, f);
    }

    public EntityFluidFX(World world, double x, double y, double z, double vx, double vy, double vz, Fluid f) {
        super(world, x, y, z, vx, vy, vz);
        this.field_70550_a = ReikaLiquidRenderer.getFluidIconSafe(f);
        this.field_70544_f = 1.0f;
        this.type = f;
        this.field_70159_w = vx;
        this.field_70181_x = vy;
        this.field_70179_y = vz;
    }

    public final EntityFluidFX setColliding() {
        this.field_70145_X = false;
        this.colliding = true;
        return this;
    }

    public EntityFluidFX setGravity(float g) {
        this.field_70545_g = g;
        return this;
    }

    public EntityFluidFX setScale(float s) {
        this.field_70544_f = s;
        return this;
    }

    public EntityFluidFX setLife(int l) {
        this.field_70547_e = l;
        return this;
    }

    public EntityFluidFX setMotionController(MotionController m) {
        this.motionController = m;
        return this;
    }

    public EntityFluidFX setPositionController(PositionController m) {
        this.positionController = m;
        return this;
    }

    public int func_70070_b(float par1) {
        return this.type.getLuminosity() > 12 ? 240 : super.func_70070_b(par1);
    }

    public int func_70537_b() {
        return 1;
    }

    public void func_70071_h_() {
        int fadeTicks;
        super.func_70071_h_();
        if (this.colliding) {
            if (this.field_70124_G) {
                double v = this.field_70146_Z.nextDouble() * 0.0625;
                double vel = ReikaMathLibrary.py3d(this.field_70159_w, 0.0, this.field_70179_y);
                this.field_70159_w = this.field_70159_w * v / vel;
                this.field_70181_x = 0.0;
                this.field_70179_y = this.field_70179_y * v / vel;
                this.colliding = false;
                this.field_70545_g *= 4.0f;
            }
            if (this.field_70123_F) {
                // empty if block
            }
        }
        if (this.field_70547_e - this.field_70546_d <= (fadeTicks = Math.min(this.field_70547_e / 2, 8))) {
            this.field_82339_as = (float)((double)this.field_82339_as - 1.0 / (double)fadeTicks);
        }
        if (this.motionController != null) {
            this.field_70159_w = this.motionController.getMotionX((Entity)this);
            this.field_70181_x = this.motionController.getMotionY((Entity)this);
            this.field_70179_y = this.motionController.getMotionZ((Entity)this);
            this.motionController.update((Entity)this);
        }
        if (this.positionController != null) {
            this.field_70165_t = this.positionController.getPositionX((Entity)this);
            this.field_70163_u = this.positionController.getPositionY((Entity)this);
            this.field_70161_v = this.positionController.getPositionZ((Entity)this);
            this.positionController.update((Entity)this);
        }
    }
}

