/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Effects;

import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import java.util.Random;

public class LightningBolt {
    public final int nsteps;
    private double varianceX = 1.0;
    private double varianceY = 1.0;
    private double varianceZ = 1.0;
    private double velocityX = 1.0;
    private double velocityY = 1.0;
    private double velocityZ = 1.0;
    public final DecimalPosition start;
    public final DecimalPosition end;
    private final DecimalPosition[] middle;
    private final double[][] offsets;
    private final double[][] offsetTargets;
    private Random rand = new Random();

    public LightningBolt(double x1, double y1, double z1, double x2, double y2, double z2, int steps) {
        this(new DecimalPosition(x1, y1, z1), new DecimalPosition(x2, y2, z2), steps);
    }

    public LightningBolt(DecimalPosition p1, DecimalPosition p2, int steps) {
        this.nsteps = steps;
        this.start = p1;
        this.end = p2;
        this.offsets = new double[this.nsteps + 1][3];
        this.offsetTargets = new double[this.nsteps + 1][3];
        this.middle = new DecimalPosition[this.nsteps + 1];
        for (int i = 0; i < this.middle.length; ++i) {
            double dx = p1.xCoord + (p2.xCoord - p1.xCoord) * (double)i / (double)this.nsteps;
            double dy = p1.yCoord + (p2.yCoord - p1.yCoord) * (double)i / (double)this.nsteps;
            double dz = p1.zCoord + (p2.zCoord - p1.zCoord) * (double)i / (double)this.nsteps;
            this.middle[i] = new DecimalPosition(dx, dy, dz);
        }
    }

    public void maximize() {
        for (int i = 1; i < this.nsteps; ++i) {
            double tx = ReikaRandomHelper.getRandomPlusMinus(0.0, this.varianceX, this.rand);
            double ty = ReikaRandomHelper.getRandomPlusMinus(0.0, this.varianceY, this.rand);
            double tz = ReikaRandomHelper.getRandomPlusMinus(0.0, this.varianceZ, this.rand);
            this.offsets[i][0] = tx;
            this.offsets[i][1] = ty;
            this.offsets[i][2] = tz;
        }
    }

    public void update() {
        for (int i = 1; i < this.nsteps; ++i) {
            double dx = this.offsets[i][0];
            double dy = this.offsets[i][1];
            double dz = this.offsets[i][2];
            double tx = this.offsetTargets[i][0];
            double ty = this.offsetTargets[i][1];
            double tz = this.offsetTargets[i][2];
            if (ReikaMathLibrary.approxr(dx, tx, this.varianceX / 8.0)) {
                tx = ReikaRandomHelper.getRandomPlusMinus(0.0, this.varianceX, this.rand);
            }
            if (ReikaMathLibrary.approxr(dy, ty, this.varianceY / 8.0)) {
                ty = ReikaRandomHelper.getRandomPlusMinus(0.0, this.varianceY, this.rand);
            }
            if (ReikaMathLibrary.approxr(dz, tz, this.varianceZ / 8.0)) {
                tz = ReikaRandomHelper.getRandomPlusMinus(0.0, this.varianceZ, this.rand);
            }
            if (tx > dx) {
                dx += this.velocityX;
            } else if (tx < dx) {
                dx -= this.velocityX;
            }
            if (ty > dy) {
                dy += this.velocityY;
            } else if (ty < dy) {
                dy -= this.velocityY;
            }
            if (tz > dz) {
                dz += this.velocityZ;
            } else if (tz < dz) {
                dz -= this.velocityZ;
            }
            this.offsets[i][0] = dx;
            this.offsets[i][1] = dy;
            this.offsets[i][2] = dz;
            this.offsetTargets[i][0] = tx;
            this.offsetTargets[i][1] = ty;
            this.offsetTargets[i][2] = tz;
        }
    }

    public DecimalPosition getPosition(int n) {
        return new DecimalPosition(this.middle[n].xCoord + this.offsets[n][0], this.middle[n].yCoord + this.offsets[n][1], this.middle[n].zCoord + this.offsets[n][2]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Bolt [");
        for (int i = 0; i <= this.nsteps; ++i) {
            sb.append(this.getPosition(i));
            if (i >= this.nsteps) continue;
            sb.append(" > ");
        }
        sb.append("];");
        return sb.toString();
    }

    public LightningBolt setRandom(Random r) {
        this.rand = r;
        return this;
    }

    public LightningBolt setVariance(double v) {
        return this.setVariance(v, v, v);
    }

    public LightningBolt setVariance(double vx, double vy, double vz) {
        this.varianceX = vx;
        this.varianceY = vy;
        this.varianceZ = vz;
        return this;
    }

    public LightningBolt setVelocity(double v) {
        return this.setVelocity(v, v, v);
    }

    public LightningBolt setVelocity(double vx, double vy, double vz) {
        this.velocityX = vx;
        this.velocityY = vy;
        this.velocityZ = vz;
        return this;
    }

    public LightningBolt scaleVariance(double v) {
        return this.scaleVariance(v, v, v);
    }

    public LightningBolt scaleVariance(double vx, double vy, double vz) {
        this.varianceX *= vx;
        this.varianceY *= vy;
        this.varianceZ *= vz;
        return this;
    }

    public LightningBolt scaleVelocity(double v) {
        return this.scaleVelocity(v, v, v);
    }

    public LightningBolt scaleVelocity(double vx, double vy, double vz) {
        this.velocityX *= vx;
        this.velocityY *= vy;
        this.velocityZ *= vz;
        return this;
    }

    public LightningBolt setVelocity(LightningBolt b) {
        return this.setVelocity(b.velocityX, b.velocityY, b.velocityZ);
    }

    public LightningBolt setVariance(LightningBolt b) {
        return this.setVariance(b.varianceX, b.varianceY, b.varianceZ);
    }
}

