/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import Reika.DragonAPI.Instantiable.Data.BlockStruct.AbstractSearch;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.DepthFirstSearch;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockBox;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Math.Spline;
import Reika.DragonAPI.Interfaces.EntityPathfinder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityPathSpline
implements EntityPathfinder {
    private final HashMap<Integer, List<DecimalPosition>> paths = new HashMap();
    private final DecimalPosition target;

    public EntityPathSpline(TileEntity te) {
        this(new DecimalPosition(te));
    }

    public EntityPathSpline(double x, double y, double z) {
        this(new DecimalPosition(x, y, z));
    }

    public EntityPathSpline(DecimalPosition c) {
        this.target = c;
    }

    public void addEntity(Entity e, AbstractSearch.PropagationCondition propagation) {
        LinkedList<Coordinate> li;
        if (this.isInRange(e)) {
            return;
        }
        AbstractSearch.LocationTerminus t = new AbstractSearch.LocationTerminus(this.target.getCoordinate());
        DepthFirstSearch s = new DepthFirstSearch(MathHelper.func_76128_c((double)e.field_70165_t), MathHelper.func_76128_c((double)e.field_70163_u), MathHelper.func_76128_c((double)e.field_70161_v));
        s.limit = new BlockBox(t.target.xCoord, t.target.yCoord, t.target.zCoord, s.root.xCoord, s.root.yCoord, s.root.zCoord);
        s.limit = s.limit.expand(24);
        while (!s.tick(e.field_70170_p, propagation, t)) {
        }
        LinkedList<Coordinate> linkedList = li = s.getResult().isEmpty() ? null : s.getResult();
        if (li != null) {
            ArrayList<Coordinate> lic = new ArrayList<Coordinate>(li);
            boolean flag = true;
            while (flag) {
                int cut1 = -1;
                int cut2 = -1;
                flag = false;
                for (int i = 0; i < lic.size() && cut1 == -1 && cut2 == -1; ++i) {
                    Coordinate c1 = lic.get(i);
                    for (int i2 = 0; i2 < lic.size() && cut1 == -1 && cut2 == -1; ++i2) {
                        Coordinate c2;
                        if (Math.abs(i - i2) <= 1 || (c2 = lic.get(i2)).getTaxicabDistanceTo(c1) != 1) continue;
                        cut1 = i;
                        cut2 = i2;
                    }
                }
                if (cut1 < 0 || cut2 < 0) continue;
                if (cut2 < cut1) {
                    int temp = cut1;
                    cut1 = cut2;
                    cut2 = temp;
                }
                flag = true;
                ArrayList<Coordinate> lic2 = new ArrayList<Coordinate>();
                for (int i = 0; i < lic.size(); ++i) {
                    if (i > cut1 && i < cut2) continue;
                    lic2.add(lic.get(i));
                }
                lic.clear();
                lic.addAll(lic2);
            }
            Spline s1 = new Spline(Spline.SplineType.CENTRIPETAL);
            s1.addPoint(new Spline.BasicSplinePoint(new DecimalPosition(e)));
            for (Coordinate c : lic) {
                s1.addPoint(new Spline.BasicSplinePoint(new DecimalPosition(c)));
            }
            s1.addPoint(new Spline.BasicSplinePoint(this.target));
            List<DecimalPosition> li2 = s1.get(12, false);
            Collections.reverse(li2);
            this.paths.put(e.func_145782_y(), li2);
        }
    }

    public void clear() {
        this.paths.clear();
    }

    @Override
    public DecimalPosition getNextWaypoint(Entity e) {
        List<DecimalPosition> li = this.paths.get(e.func_145782_y());
        return li != null && !li.isEmpty() ? li.remove(li.size() - 1) : null;
    }

    @Override
    public boolean isInRange(Entity e) {
        List<DecimalPosition> li = this.paths.get(e.func_145782_y());
        return li != null && !li.isEmpty();
    }

    public void removeDeadEntities(World world) {
        Iterator<Integer> it = this.paths.keySet().iterator();
        while (it.hasNext()) {
            Integer key = it.next();
            Entity e = world.func_73045_a(key.intValue());
            if (e != null && !e.field_70128_L) continue;
            it.remove();
        }
    }
}

