/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Event;

import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Instantiable.Event.Base.WorldPositionEvent;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockGrass;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class BlockTickEvent
extends WorldPositionEvent {
    public static boolean disallowAllUpdates = false;
    public final Block block;
    private final int flags;

    public BlockTickEvent(World world, int x, int y, int z, Block b, int flags) {
        super(world, x, y, z);
        this.block = b;
        this.flags = flags;
    }

    public boolean isCancelable() {
        return !UpdateFlags.REQUIRE.isFlagPresent(this.flags);
    }

    public boolean isFlagPresent(UpdateFlags flag) {
        return flag.isFlagPresent(this.flags);
    }

    public static void fire(World world, int x, int y, int z, int flags) {
        BlockTickEvent.fire(world.func_147439_a(x, y, z), world, x, y, z, world.field_73012_v, flags);
    }

    public static void fire(World world, int x, int y, int z, UpdateFlags flag) {
        BlockTickEvent.fire(world.func_147439_a(x, y, z), world, x, y, z, flag);
    }

    public static void fire(Block b, World world, int x, int y, int z, UpdateFlags flag) {
        BlockTickEvent.fire(b, world, x, y, z, world.field_73012_v, flag);
    }

    public static void fire(World world, int x, int y, int z, Random rand, int flags) {
        BlockTickEvent.fire(world.func_147439_a(x, y, z), world, x, y, z, rand, flags);
    }

    public static void fire(World world, int x, int y, int z, Random rand, UpdateFlags flag) {
        BlockTickEvent.fire(world.func_147439_a(x, y, z), world, x, y, z, rand, flag);
    }

    public static void fire(Block b, World world, int x, int y, int z, Random rand, UpdateFlags flag) {
        BlockTickEvent.fire(b, world, x, y, z, rand, flag.flag);
    }

    public static void fire(Block b, World world, int x, int y, int z, Random rand, int flags) {
        if (!disallowAllUpdates && BlockTickEvent.canTickAt(b, world, x, y, z, flags) && !MinecraftForge.EVENT_BUS.post((Event)new BlockTickEvent(world, x, y, z, b, flags))) {
            b.func_149674_a(world, x, y, z, rand);
        }
    }

    private static boolean canTickAt(Block b, World world, int x, int y, int z, int flags) {
        if (UpdateFlags.FORCED.isFlagPresent(flags) || UpdateFlags.REQUIRE.isFlagPresent(flags)) {
            return true;
        }
        return DragonOptions.STOPUNLOADSPREAD.getState() && BlockTickEvent.requireLoadedArea(b) ? BlockTickEvent.hasLoadedRadius(world, x, y, z) : true;
    }

    private static boolean requireLoadedArea(Block b) {
        return ReikaBlockHelper.isLiquid(b) || b instanceof BlockGrass || b instanceof BlockFire;
    }

    private static boolean hasLoadedRadius(World world, int x, int y, int z) {
        int cx = x >> 4 << 4;
        int cz = z >> 4 << 4;
        return world.func_72904_c(cx - 16, y, cz - 16, cx + 16, y, cz + 16);
    }

    public static enum UpdateFlags {
        NATURAL,
        SCHEDULED,
        FORCED,
        REQUIRE;

        public final int flag = 1 << this.ordinal();

        public boolean isFlagPresent(int flags) {
            return (flags & this.flag) != 0;
        }

        public static int getForcedUnstoppableTick() {
            return UpdateFlags.FORCED.flag + UpdateFlags.REQUIRE.flag;
        }
    }
}

