/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import Reika.DragonAPI.Instantiable.HybridTank;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public final class FlaggedTank
extends HybridTank {
    private final TankWatcher te;

    public FlaggedTank(TankWatcher tw, String name, int capacity) {
        super(name, capacity);
        this.te = tw;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        Fluid oldf = this.getActualFluid();
        FluidStack fs = super.drain(maxDrain, doDrain);
        Fluid newf = this.getActualFluid();
        if (oldf != newf) {
            this.te.onTankChangeFluidType(this.name, oldf, newf);
        }
        return fs;
    }

    public int fill(FluidStack resource, boolean doFill) {
        Fluid oldf = this.getActualFluid();
        int fill = super.fill(resource, doFill);
        Fluid newf = this.getActualFluid();
        if (oldf != newf) {
            this.te.onTankChangeFluidType(this.name, oldf, newf);
        }
        return fill;
    }

    public void setFluid(FluidStack fluid) {
        Fluid oldf = this.getActualFluid();
        super.setFluid(fluid);
        Fluid newf = this.getActualFluid();
        if (oldf != newf) {
            this.te.onTankChangeFluidType(this.name, oldf, newf);
        }
    }

    public static interface TankWatcher {
        public void onTankChangeFluidType(String var1, Fluid var2, Fluid var3);
    }
}

