/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import Reika.ChromatiCraft.TileEntity.AOE.Defence.TileEntityExplosionShield;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.EntityTumblingBlock;
import Reika.DragonAPI.Interfaces.Block.SemiUnbreakable;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModList;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FlyingBlocksExplosion
extends Explosion {
    private World world;
    private TumbleCreator tumbleCreator = null;
    public boolean canBreakBedrock = false;

    public FlyingBlocksExplosion(WorldLocation loc, float power) {
        this(loc.getWorld(), (double)loc.xCoord + 0.5, (double)loc.yCoord + 0.5, (double)loc.zCoord + 0.5, power);
    }

    public FlyingBlocksExplosion(TileEntity loc, float power) {
        this(loc.field_145850_b, (double)loc.field_145851_c + 0.5, (double)loc.field_145848_d + 0.5, (double)loc.field_145849_e + 0.5, power);
    }

    public FlyingBlocksExplosion(World world, double x, double y, double z, float power) {
        super(world, null, x, y, z, power);
        this.world = world;
    }

    public void doExplosion() {
        this.func_77278_a();
        this.func_77279_a(true);
    }

    public FlyingBlocksExplosion setTumbling(TumbleCreator c) {
        this.tumbleCreator = c;
        return this;
    }

    public void func_77278_a() {
        int i;
        int r = (int)this.field_77280_f + 2;
        int x = (int)Math.floor(this.field_77284_b);
        int y = (int)Math.floor(this.field_77285_c);
        int z = (int)Math.floor(this.field_77282_d);
        ArrayList<EntityFallingBlock> li = new ArrayList<EntityFallingBlock>();
        if (!this.world.field_72995_K) {
            for (i = x - r; i <= x + r; ++i) {
                for (int j = y - r; j <= y + r; ++j) {
                    for (int k = z - r; k <= z + r; ++k) {
                        if (ModList.CHROMATICRAFT.isLoaded() && this.isLocationProtected(x, y, z)) continue;
                        Block b = this.world.func_147439_a(i, j, k);
                        int meta = this.world.func_72805_g(i, j, k);
                        Effect e = this.calcEffect(this.world, i, j, k, b, meta);
                        e.trigger(this.world, i, j, k, b, meta, this.tumbleCreator, li);
                    }
                }
            }
        }
        super.func_77278_a();
        for (i = 0; i < li.size(); ++i) {
            EntityFallingBlock e = (EntityFallingBlock)li.get(i);
            double dx = e.field_70165_t - this.field_77284_b;
            double dy = e.field_70163_u - this.field_77285_c;
            double dz = e.field_70161_v - this.field_77282_d;
            double dd = 0.3;
            double vy = 1.5;
            Random rand = new Random();
            e.field_70159_w = dx * dd * rand.nextDouble();
            e.field_70181_x = dy * dd * rand.nextDouble() + vy;
            e.field_70179_y = dz * dd * rand.nextDouble();
            e.field_70133_I = true;
        }
    }

    @DependentMethodStripper.ModDependent(value={ModList.CHROMATICRAFT})
    private boolean isLocationProtected(int x, int y, int z) {
        return TileEntityExplosionShield.isLocationProtected((World)this.world, (int)x, (int)y, (int)z, (double)this.field_77280_f);
    }

    protected final Effect calcEffect(World world, int x, int y, int z, Block b, int meta) {
        Effect e = this.getEffect(world, x, y, z, b, meta);
        if (e == Effect.NOTHING) {
            return e;
        }
        double dd = ReikaMathLibrary.py3d((double)x + 0.5 - this.field_77284_b, (double)y + 0.5 - this.field_77285_c, (double)z + 0.5 - this.field_77282_d);
        return dd <= (double)this.field_77280_f + 0.5 ? e : Effect.NOTHING;
    }

    protected final Effect getEffect(World world, int x, int y, int z, Block b, int meta) {
        if (b == Blocks.field_150350_a) {
            return Effect.NOTHING;
        }
        if (b == Blocks.field_150357_h) {
            return this.canBreakBedrock ? Effect.ENTITIZE : Effect.NOTHING;
        }
        if (b.field_149782_v < 0.0f) {
            return this.canBreakBedrock ? Effect.ENTITIZE : Effect.NOTHING;
        }
        if (b instanceof SemiUnbreakable) {
            return ((SemiUnbreakable)b).isUnbreakable(world, x, y, z, meta) ? Effect.NOTHING : Effect.ENTITIZE;
        }
        if (b.hasTileEntity(meta)) {
            return Effect.NOTHING;
        }
        if (ReikaWorldHelper.softBlocks((IBlockAccess)world, x, y, z)) {
            return Effect.BREAK;
        }
        if (b.func_149645_b() == 0 || b.func_149686_d() || !b.func_149662_c()) {
            // empty if block
        }
        return Effect.ENTITIZE;
    }

    private static enum Effect {
        ENTITIZE,
        BREAK,
        NOTHING;


        public void trigger(World world, int x, int y, int z, Block b, int meta, TumbleCreator c, List<EntityFallingBlock> li) {
            switch (this) {
                case BREAK: {
                    ReikaWorldHelper.dropAndDestroyBlockAt(world, x, y, z, null, true, false);
                    break;
                }
                case ENTITIZE: {
                    EntityFallingBlock e = c != null ? c.createBlock(world, x, y, z, b, meta) : new EntityFallingBlock(world, (double)x, (double)y, (double)z, b, meta);
                    li.add(e);
                    e.field_145812_b = -10000;
                    e.field_145813_c = false;
                    world.func_147468_f(x, y, z);
                    world.func_72838_d((Entity)e);
                    break;
                }
            }
        }
    }

    public static interface TumbleCreator {
        public EntityTumblingBlock createBlock(World var1, int var2, int var3, int var4, Block var5, int var6);
    }
}

