/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class HybridTank
extends FluidTank {
    protected final String name;

    public HybridTank(String name, int capacity) {
        super(capacity);
        this.name = name;
    }

    public HybridTank(String name, FluidStack stack, int capacity) {
        this(name, capacity);
        this.setFluid(stack);
    }

    public HybridTank(String name, Fluid fluid, int amount, int capacity) {
        this(name, new FluidStack(fluid, amount), capacity);
    }

    public final NBTTagCompound writeToNBT(NBTTagCompound NBT) {
        NBTTagCompound tankData = new NBTTagCompound();
        super.writeToNBT(tankData);
        String fluidName = tankData.func_74779_i("FluidName");
        String repl = ReikaFluidHelper.getFluidNameSwap(fluidName);
        if (repl != null && FluidRegistry.getFluid((String)repl) != null && !fluidName.equals(repl)) {
            tankData.func_74778_a("FluidName", repl);
            DragonAPICore.log("Tank " + (Object)((Object)this) + " has replaced its FluidName of '" + fluidName + "' with '" + repl + "', as the fluid has changed names.");
        }
        NBT.func_74782_a(this.name, (NBTBase)tankData);
        return NBT;
    }

    public final FluidTank readFromNBT(NBTTagCompound NBT) {
        try {
            if (NBT.func_74764_b(this.name)) {
                NBTTagCompound tankData = NBT.func_74775_l(this.name);
                String fluidName = tankData.func_74779_i("FluidName");
                String repl = ReikaFluidHelper.getFluidNameSwap(fluidName);
                if (repl != null && FluidRegistry.getFluid((String)repl) != null && !fluidName.equals(repl)) {
                    tankData.func_74778_a("FluidName", repl);
                    DragonAPICore.log("Tank " + (Object)((Object)this) + " has replaced its FluidName of '" + fluidName + "' with '" + repl + "', as the fluid has changed names.");
                }
                super.readFromNBT(tankData);
            }
        }
        catch (IllegalArgumentException e) {
            DragonAPICore.logError("Loading HybridTank '" + this.name + "' has errored, its machine will not keep its fluid!");
            e.printStackTrace();
        }
        return this;
    }

    public boolean isEmpty() {
        return this.getFluid() == null || this.getFluid().amount <= 0;
    }

    public boolean isFull() {
        return this.getFluid() != null && this.getFluid().amount >= this.getCapacity();
    }

    public int getLevel() {
        if (this.getFluid() == null) {
            return 0;
        }
        return this.getFluid().amount;
    }

    public void removeLiquid(float amt) {
        this.removeLiquid((int)amt);
    }

    public void removeLiquid(int amt) {
        if (this.getFluid() == null) {
            DragonAPICore.logError("Could not remove liquid from empty tank!");
            ReikaJavaLibrary.dumpStack();
        } else if (amt <= 0) {
            DragonAPICore.logError("Cannot remove <= 0!");
            ReikaJavaLibrary.dumpStack();
        } else {
            this.drain(amt, true);
        }
    }

    public void addLiquid(int amt, Fluid type) {
        if (type == null) {
            return;
        }
        if (amt > this.capacity) {
            amt = this.capacity;
        }
        if (this.getFluid() == null) {
            this.fill(new FluidStack(type, amt), true);
        } else if (type.equals(this.getFluid().getFluid())) {
            this.fill(new FluidStack(this.getFluid().getFluid(), amt), true);
        }
    }

    public void empty() {
        this.drain(this.getLevel(), true);
    }

    public void setFluidType(Fluid type) {
        int amt = this.getLevel();
        this.drain(amt, true);
        this.fill(new FluidStack(type, amt), true);
    }

    public void setContents(int amt, Fluid f) {
        this.empty();
        this.addLiquid(amt, f);
    }

    public Fluid getActualFluid() {
        if (this.getFluid() == null) {
            return null;
        }
        return this.getFluid().getFluid();
    }

    public float getFraction() {
        return (float)this.getLevel() / (float)this.getCapacity();
    }

    public String toString() {
        if (this.isEmpty()) {
            return "Empty Tank " + this.name;
        }
        return "Tank " + this.name + ", containing " + this.getLevel() + " mB of " + this.getActualFluid().getLocalizedName();
    }

    public int getRemainingSpace() {
        return this.capacity - this.getLevel();
    }

    public boolean canTakeIn(int amt) {
        return this.getRemainingSpace() >= amt;
    }

    public boolean canTakeIn(Fluid f, int amt) {
        if (this.isEmpty()) {
            return this.capacity >= amt;
        }
        return this.getRemainingSpace() >= amt && this.getActualFluid().equals(f);
    }

    public boolean canTakeIn(FluidStack fs) {
        int amt = fs.amount;
        return this.isEmpty() ? this.capacity >= amt : this.getRemainingSpace() >= amt && this.getActualFluid().equals(fs.getFluid());
    }

    public void setNBT(NBTTagCompound nbt) {
        if (this.getFluid() != null) {
            this.getFluid().tag = nbt;
        }
    }

    public void setNBTInt(String key, int val) {
        if (this.getFluid() != null) {
            if (this.getFluid().tag == null) {
                this.getFluid().tag = new NBTTagCompound();
            }
            this.getFluid().tag.func_74768_a(key, val);
        }
    }

    public void setNBTString(String key, String s) {
        if (this.getFluid() != null) {
            if (this.getFluid().tag == null) {
                this.getFluid().tag = new NBTTagCompound();
            }
            this.getFluid().tag.func_74778_a(key, s);
        }
    }

    public void setNBTBoolean(String key, boolean b) {
        if (this.getFluid() != null) {
            if (this.getFluid().tag == null) {
                this.getFluid().tag = new NBTTagCompound();
            }
            this.getFluid().tag.func_74757_a(key, b);
        }
    }

    public int getNBTInt(String key) {
        return this.getFluid() != null && this.getFluid().tag != null ? this.getFluid().tag.func_74762_e(key) : 0;
    }

    public String getNBTString(String key) {
        return this.getFluid() != null && this.getFluid().tag != null ? this.getFluid().tag.func_74779_i(key) : "";
    }

    public boolean getNBTBoolean(String key) {
        return this.getFluid() != null && this.getFluid().tag != null ? this.getFluid().tag.func_74767_n(key) : false;
    }
}

