/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.IO;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Libraries.Java.ReikaASMHelper;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.io.Charsets;

public abstract class LuaBlock {
    private static final Comparator<String> outputSorter = new OutputSorter();
    private static final Pattern TYPE_SPECIFIER = Pattern.compile("\\[(.*?)\\]");
    public static final String NULL_KEY_INHERIT = "[NULL KEY INHERIT]";
    public static final String NULL_PARENT_INHERIT = "[NULL PARENT INHERIT]";
    public static final String NULL_DATA = "[NULL DATA]";
    public final boolean isRoot;
    public final String name;
    private final LuaBlock parent;
    private final LinkedHashMap<LuaBlockKey, LuaBlock> children = new LinkedHashMap();
    private final LinkedHashMap<String, String> data = new LinkedHashMap();
    protected final LuaBlockDatabase tree;
    protected final HashSet<String> requiredElements = new HashSet();
    private boolean isListEntry = false;
    private boolean isList = true;
    private HashMap<String, String> comments = new HashMap();

    protected LuaBlock(String n, LuaBlock parent, LuaBlockDatabase db) {
        boolean bl = this.isRoot = parent == null;
        if (n.equals("{")) {
            n = Integer.toHexString(System.identityHashCode(this));
            this.isListEntry = true;
        }
        this.name = n;
        this.parent = parent;
        LuaBlockDatabase luaBlockDatabase = this.tree = parent != null ? parent.tree : db;
        if (this.tree == null) {
            throw new MisuseException("You cannot create a LuaBlock without a containing tree!");
        }
        if (parent != null) {
            parent.children.put(this.createKey(this.name), this);
        }
        this.requiredElements.add("type");
    }

    private LuaBlockKey createKey(String n) {
        return this.tree.hasDuplicateKeys ? new LuaBlockKey(n, n + "_" + this.parent.children.size()) : new LuaBlockKey(n);
    }

    public final boolean isList() {
        return this.isList && !this.isRoot && (!this.data.isEmpty() || this.children.isEmpty());
    }

    public final LuaBlock getParent() {
        return this.parent;
    }

    public final LuaBlock getTopParent() {
        LuaBlock lb = this;
        while (lb.parent != null) {
            lb = lb.parent;
        }
        return lb;
    }

    public final double getDouble(String key) {
        return this.containsKeyInherit(key) ? Double.parseDouble(this.getString(key)) : 0.0;
    }

    public final boolean getBoolean(String key) {
        return this.containsKeyInherit(key) ? Boolean.parseBoolean(this.getString(key)) : false;
    }

    public final int getInt(String key) {
        return this.containsKeyInherit(key) ? this.parseInt(this.getString(key)) : 0;
    }

    public final long getLong(String key) {
        return Long.parseLong(this.getString(key));
    }

    public final String getString(String key) {
        if (this.data.containsKey(key)) {
            return this.data.get(key);
        }
        String fallback = this.getFallbackValue(key);
        if (fallback != null) {
            return fallback;
        }
        if (!this.canInherit(key)) {
            throw new IllegalArgumentException("Missing key '" + key + "' for '" + this.name + "'");
        }
        return this.inherit(key);
    }

    protected String getFallbackValue(String key) {
        return null;
    }

    private int parseInt(String s) {
        if (s.startsWith("0x")) {
            return Integer.parseInt(s.substring(2), 16);
        }
        if (s.startsWith("0b")) {
            return Integer.parseInt(s.substring(2), 2);
        }
        if (s.startsWith("0o")) {
            return Integer.parseInt(s.substring(2), 8);
        }
        return Integer.decode(s);
    }

    private boolean isString(String s) {
        return !Character.isDigit(s.charAt(s.charAt(0) == '-' && s.length() > 1 ? 1 : 0)) && !s.equalsIgnoreCase("true") && !s.equalsIgnoreCase("false");
    }

    public final Collection<String> getKeys() {
        return Collections.unmodifiableCollection(this.data.keySet());
    }

    public final Collection<String> getDataValues() {
        return Collections.unmodifiableCollection(this.data.values());
    }

    public final void putData(String key, boolean val) {
        this.putData(key, String.valueOf(val));
    }

    public final void putData(String key, double val) {
        this.putData(key, String.valueOf(val));
    }

    public final void putData(String key, int val) {
        this.putData(key, String.valueOf(val));
    }

    public final void putData(String key, String val) {
        this.data.put(key, val);
        this.isList = false;
    }

    public final void addListData(String val) {
        if (!this.isList) {
            throw new MisuseException("You can only add list data to list-type entries!");
        }
        this.data.put(String.valueOf(this.data.size()), val);
    }

    public final boolean containsKey(String key) {
        return this.data.containsKey(key);
    }

    public final boolean containsKeyInherit(String key) {
        if (this.data.containsKey(key)) {
            return true;
        }
        return !this.inherit(key).startsWith("[NULL");
    }

    public boolean hasChild(String s) {
        return this.children.containsKey(this.createKey(s));
    }

    public final Collection<LuaBlock> getChildren() {
        return Collections.unmodifiableCollection(this.children.values());
    }

    private String inherit(String key) {
        LuaBlock b = this;
        ArrayList<LuaBlockKey> steps = new ArrayList<LuaBlockKey>();
        LuaBlock orig = b;
        while (!b.data.containsKey("inherit") && b.parent != null) {
            steps.add(this.createKey(b.name));
            b = b.parent;
        }
        String inherit = b.data.get("inherit");
        if (inherit == null) {
            return NULL_KEY_INHERIT;
        }
        LuaBlock lb = this.tree.getBlock(inherit);
        if (lb == null) {
            return NULL_PARENT_INHERIT;
        }
        for (LuaBlockKey s : steps) {
            if (lb.children.containsKey(s)) {
                lb = lb.children.get(s);
                continue;
            }
            throw new IllegalStateException("'" + orig.parent.name + "/" + orig.name + "' tried to inherit property '" + key + "', but could not.");
        }
        return lb.data.containsKey(key) ? lb.getString(key) : NULL_DATA;
    }

    protected boolean canInherit(String key) {
        return !this.requiredElements.contains(key) && !key.equals("inherit");
    }

    public final LuaBlock getChild(String s) {
        LuaBlockKey key = this.createKey(s);
        return this.children.containsKey(key) ? this.children.get(key) : this.inheritChild(s);
    }

    private LuaBlock inheritChild(String sg) {
        LuaBlock b = this;
        ArrayList<LuaBlockKey> steps = new ArrayList<LuaBlockKey>();
        while (!b.data.containsKey("inherit") && b.parent != null) {
            if (b != this) {
                steps.add(this.createKey(b.name));
            }
            b = b.parent;
        }
        String inherit = b.data.get("inherit");
        if (inherit == null) {
            return null;
        }
        LuaBlock lb = this.tree.getBlock(inherit);
        if (lb == null) {
            return null;
        }
        for (LuaBlockKey s : steps) {
            lb = lb.children.get(s);
        }
        LuaBlockKey key = this.createKey(sg);
        return lb.children.containsKey(key) ? lb.children.get(key) : null;
    }

    public String toString() {
        return this.toString(0);
    }

    private String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append(this.getIndent("----", indent) + "-------------" + this.name + "-------------\n");
        sb.append(this.getIndent("====", indent) + "=============DATA=============\n");
        for (String s : this.data.keySet()) {
            String val = this.data.get(s);
            sb.append(this.getIndent("\t", indent) + s + "=" + val);
            sb.append("\n");
        }
        if (!this.children.isEmpty()) {
            sb.append("\n");
            sb.append(this.getIndent("====", indent) + "=============CHILDREN=============\n");
            for (LuaBlock lb : this.children.values()) {
                sb.append(lb.toString(indent + 1));
            }
        }
        sb.append(this.getIndent("----", indent) + "---------------------------------------\n");
        sb.append("\n");
        sb.append("\n");
        return sb.toString();
    }

    private String getIndent(String rpt, int idt) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < idt; ++i) {
            sb.append(rpt);
        }
        return sb.toString();
    }

    public void setComment(String key, String comment) {
        HashMap<String, String> map = this.comments;
        String ckey = key;
        if (key == null && this.parent != null) {
            ckey = this.name;
            map = this.parent.comments;
        }
        map.put(ckey, comment);
    }

    public final HashMap<String, Object> asHashMap() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (String string : this.data.keySet()) {
            ret.put(string, this.parseObject(this.data.get(string)));
        }
        for (LuaBlockKey luaBlockKey : this.children.keySet()) {
            LuaBlock b = this.children.get(luaBlockKey);
            ret.put(luaBlockKey.lookupKey, this.getObject(b));
        }
        return ret;
    }

    protected void onFinish() {
    }

    public final WeightedRandom<String> asWeightedRandom() {
        WeightedRandom<String> wr = new WeightedRandom<String>();
        for (String s : this.data.keySet()) {
            wr.addEntry(s, this.getDouble(s));
        }
        return wr;
    }

    public void writeData(List li) {
        int idx = 0;
        for (Object o : li) {
            BasicLuaBlock child;
            if (o instanceof Map) {
                child = new BasicLuaBlock(String.valueOf(idx), this, this.tree);
                child.writeData((Map)o);
            } else if (o instanceof List) {
                child = new BasicLuaBlock(String.valueOf(idx), this, this.tree);
                child.writeData((List)o);
            } else {
                this.putData(String.valueOf(idx), String.valueOf(o));
            }
            ++idx;
        }
    }

    public void writeData(Map<String, ?> map) {
        for (Map.Entry<String, ?> e : map.entrySet()) {
            BasicLuaBlock child;
            if (e.getValue() instanceof Map) {
                child = new BasicLuaBlock(e.getKey(), this, this.tree);
                child.writeData((Map)e.getValue());
                continue;
            }
            if (e.getValue() instanceof List) {
                child = new BasicLuaBlock(e.getKey(), this, this.tree);
                child.writeData((List)e.getValue());
                continue;
            }
            this.putData(e.getKey(), String.valueOf(e.getValue()));
        }
    }

    public final List<Object> asList() {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (LuaBlock b : this.children.values()) {
            ret.add(this.getObject(b));
        }
        return ret;
    }

    private Object getObject(LuaBlock b) {
        return b.isList() && b.data.size() == 1 && b.children.isEmpty() ? this.parseObject(b.data.values().iterator().next()) : (b.isList() ? b.asList() : b.asHashMap());
    }

    private Object parseObject(String s) {
        if (s.equalsIgnoreCase("true")) {
            return true;
        }
        if (s.equalsIgnoreCase("false")) {
            return false;
        }
        Enum override = null;
        if (s.contains("[datatype=")) {
            String type = s.replace("datatype=", "");
            Matcher m = TYPE_SPECIFIER.matcher(type);
            type = m.find() ? m.group(1) : null;
            s = s.replace("[datatype=" + type + "]", "");
            try {
                override = ReikaASMHelper.PrimitiveType.valueOf(type.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (override != null) {
            try {
                switch (1.$SwitchMap$Reika$DragonAPI$Libraries$Java$ReikaASMHelper$PrimitiveType[override.ordinal()]) {
                    case 1: {
                        return Byte.parseByte(s);
                    }
                    case 2: {
                        return (byte)Short.parseShort(s);
                    }
                    case 3: {
                        return Long.parseLong(s);
                    }
                    case 4: {
                        return Float.valueOf(Float.parseFloat(s));
                    }
                    case 5: {
                        return Float.valueOf((float)Double.parseDouble(s));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            return Integer.parseInt(s);
        }
        catch (Exception exception) {
            try {
                return Long.parseLong(s);
            }
            catch (Exception exception2) {
                try {
                    return Double.parseDouble(s);
                }
                catch (Exception exception3) {
                    return s;
                }
            }
        }
    }

    public ArrayList<String> writeToStrings() {
        return this.writeToStrings(1);
    }

    private ArrayList<String> writeToStrings(int indent) {
        ArrayList<String> li = new ArrayList<String>();
        String pre = ReikaStringParser.getNOf("\t", indent);
        if (indent == 1) {
            String s = "{";
            li.add(s);
        }
        ArrayList<String> keys = new ArrayList<String>(this.data.keySet());
        Collections.sort(keys, outputSorter);
        for (String s : keys) {
            String val = this.data.get(s);
            if (this.isString(val)) {
                val = "\"" + val + "\"";
            }
            if (this.isList()) {
                li.add(pre + val);
                continue;
            }
            String put = pre + s + " = " + val;
            String comment = this.comments.get(s);
            if (comment != null) {
                put = put + " --" + comment;
            }
            li.add(put);
        }
        ArrayList<LuaBlockKey> keys2 = new ArrayList<LuaBlockKey>(this.children.keySet());
        Collections.sort(keys2);
        for (LuaBlockKey s : keys2) {
            LuaBlock c = this.children.get(s);
            String put = c.isListEntry || s.name.equals("-") ? pre + "{" : pre + s.name + " = {";
            String comment = this.comments.get(s.name);
            if (comment != null) {
                put = put + " --" + comment;
            }
            li.add(put);
            li.addAll(c.writeToStrings(indent + 1));
            li.add(pre + "}");
        }
        if (indent == 1) {
            li.add("}");
        }
        return li;
    }

    public Class<? extends LuaBlock> getChildBlockType() {
        return this.getClass();
    }

    public static boolean isErrorCode(String s) {
        return NULL_DATA.equals(s) || NULL_KEY_INHERIT.equals(s) || NULL_PARENT_INHERIT.equals(s);
    }

    private static class LuaBlockKey
    implements Comparable<LuaBlockKey> {
        public final String name;
        public final String lookupKey;

        private LuaBlockKey(String s) {
            this(s, s);
        }

        private LuaBlockKey(String s, String k) {
            this.name = s;
            this.lookupKey = k;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            return o instanceof LuaBlockKey && ((LuaBlockKey)o).lookupKey.equals(this.lookupKey);
        }

        public int hashCode() {
            return this.lookupKey.hashCode();
        }

        @Override
        public int compareTo(LuaBlockKey o) {
            return this.name.compareTo(o.name);
        }
    }

    private static class OutputSorter
    implements Comparator<String> {
        private OutputSorter() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1.equals("type")) {
                return Integer.MIN_VALUE;
            }
            if (o2.equals("type")) {
                return Integer.MAX_VALUE;
            }
            return o1.compareToIgnoreCase(o2);
        }
    }

    public static class LuaBlockDatabase {
        private LuaBlock activeBlock = new BasicLuaBlock("top", null, this);
        private final HashMap<String, LuaBlock> rawData = new HashMap();
        public boolean hasDuplicateKeys = false;
        public Class<? extends LuaBlock> defaultBlockType;

        public final void loadFromFile(File f) {
            this.loadFromLines(ReikaFileReader.getFileAsLines(f, false, Charsets.UTF_8));
        }

        public final void loadFromLines(ArrayList<String> li) {
            int bracketLevel = 0;
            for (String s : li) {
                if ((s = this.cleanString(s)).isEmpty()) continue;
                if (s.contains("{")) {
                    ++bracketLevel;
                    if (s.endsWith(" = {")) {
                        s = s.substring(0, s.length() - 4);
                    }
                    try {
                        this.activeBlock = this.createChild(s, this.activeBlock);
                    }
                    catch (Exception e) {
                        DragonAPICore.logError("Failed to construct proper child LuaBlock for " + s + "' in " + this + ": ");
                        e.printStackTrace();
                        this.activeBlock = new BasicLuaBlock(s, this.activeBlock, this);
                    }
                } else if (s.contains("}")) {
                    if (this.activeBlock.containsKey("type") && this.activeBlock.parent != null && ((LuaBlock)this.activeBlock).parent.isRoot) {
                        this.addBlock(this.activeBlock.getString("type"), this.activeBlock);
                    }
                    this.activeBlock.onFinish();
                    this.activeBlock = this.activeBlock.getParent();
                    --bracketLevel;
                }
                if (s.equals("{") || s.equals("}") || s.equals(this.activeBlock.name)) continue;
                String[] parts = (s = s.replaceAll("\"", "")).split("=");
                if (parts.length == 2) {
                    String s2;
                    String s1 = parts[0].substring(0, parts[0].length() - 1);
                    if (s1.charAt(s1.length() - 1) == ' ') {
                        s1 = s1.substring(1);
                    }
                    if ((s2 = parts[1]).charAt(0) == ' ') {
                        s2 = s2.substring(1);
                    }
                    this.activeBlock.putData(s1, s2);
                    continue;
                }
                this.activeBlock.addListData(s);
            }
            if (bracketLevel != 0) {
                throw new IllegalArgumentException("Malformed file: bracket mismatch");
            }
        }

        private LuaBlock createChild(String s, LuaBlock parent) throws Exception {
            Class<? extends LuaBlock> c = parent.getChildBlockType();
            if (parent.isRoot && this.defaultBlockType != null) {
                c = this.defaultBlockType;
            }
            Constructor<? extends LuaBlock> ctr = c.getDeclaredConstructor(String.class, LuaBlock.class, LuaBlockDatabase.class);
            ctr.setAccessible(true);
            LuaBlock child = ctr.newInstance(s, parent, this);
            return child;
        }

        private String cleanString(String s) {
            if (s.startsWith("//") || s.startsWith("--")) {
                return "";
            }
            if ((s = s.replaceAll("\t", "")).contains("--")) {
                s = s.substring(0, s.indexOf("--"));
            }
            if (s.contains("//")) {
                s = s.substring(0, s.indexOf("//"));
            }
            if (s.length() > 0) {
                while (!s.isEmpty() && s.charAt(s.length() - 1) == ' ') {
                    s = s.substring(0, s.length() - 1);
                }
                while (!s.isEmpty() && s.charAt(0) == ' ') {
                    s = s.substring(1, s.length());
                }
            }
            return s;
        }

        public void addBlock(String key, LuaBlock b) {
            this.rawData.put(key, b);
        }

        public void clear() {
            this.rawData.clear();
        }

        public LuaBlock getBlock(String key) {
            return this.rawData.get(key);
        }

        public LuaBlock getRootBlock() {
            return this.activeBlock.getTopParent();
        }

        public LuaBlock createRootBlock() {
            BasicLuaBlock lb = new BasicLuaBlock("base", null, this);
            this.addBlock("base", lb);
            return lb;
        }
    }

    public static final class NBTLuaBlock
    extends LuaBlock {
        public NBTLuaBlock(String n, LuaBlock parent, LuaBlockDatabase db, NBTTagCompound tag, boolean parseEnchants) {
            super(n, parent, db);
            HashMap map = ReikaNBTHelper.readMapFromNBT(tag);
            if (parseEnchants) {
                map = this.parseEnchantments(map);
            }
            this.writeData(map);
        }

        private HashMap parseEnchantments(HashMap map) {
            Object ench = map.remove("StoredEnchantments");
            if (ench == null) {
                ench = map.remove("ench");
            }
            if (ench instanceof ArrayList) {
                ArrayList<String> li = new ArrayList<String>();
                ArrayList data = (ArrayList)ench;
                for (HashMap in : data) {
                    short lvl = (Short)in.get("lvl");
                    short id = (Short)in.get("id");
                    li.add(Enchantment.field_77331_b[id].func_77316_c((int)lvl));
                }
                map.put("Enchantments", li);
            }
            return map;
        }
    }

    public static final class ItemStackLuaBlock
    extends LuaBlock {
        public ItemStackLuaBlock(String n, LuaBlock parent, LuaBlockDatabase db) {
            super(n, parent, db);
        }

        public void write(ItemStack is, boolean writeSize) {
            this.putData("item_id", Item.field_150901_e.func_148750_c((Object)is.func_77973_b()));
            this.putData("metadata", String.valueOf(is.func_77960_j()));
            if (writeSize) {
                this.putData("stack_size", String.valueOf(is.field_77994_a));
            }
            this.putData("display_name", is.func_82833_r());
            NBTLuaBlock nbt = is.field_77990_d != null ? new NBTLuaBlock("nbt", this, this.tree, is.field_77990_d, true) : null;
        }
    }

    private static class BasicLuaBlock
    extends LuaBlock {
        protected BasicLuaBlock(String n, LuaBlock lb, LuaBlockDatabase db) {
            super(n, lb, db);
        }
    }
}

